#ifndef __NETWORK_H
#define __NETWORK_H

#if G_BYTE_ORDER == G_LITTLE_ENDIAN
#define BSWAP16(x) (x)
#define BSWAP32(x) (x)
#elif G_BYTE_ORDER == G_BIG_ENDIAN
#define BSWAP16(x) (((x & 0xff) << 8) | ((x >> 8) & 0xff))
#define BSWAP32(x) (((x & 0xff) << 24) | ((x & 0xff00) << 8) | ((x & 0xff0000) >> 8) | (x >> 24))
#else
#error EEP! Unknown byte order!?
#endif

/* I'll add threading in the next release so we'll gethostbyname() this */
#define SERVER_NAPSTER_COM "64.124.41.16"

#define DOWNLOAD 0
#define UPLOAD   1

#define RW_BUFFER 512

struct _Packet {
   unsigned short len;
   unsigned short cmd;
};

enum _TransferInfo {
   TRANSFER_FINISHED =    0x01,
   TRANSFER_CLOSED =      0x02,
   TRANSFER_FILE_REMOVE = 0x04,
   TRANSFER_CANCEL =      0x08,
   TRANSFER_TIMEOUT =     0x10,
   TRANSFER_ERROR =       0x20,
};

/* prototypes */
int n_send(int sock, char *fmt, ...);
void set_blocking(int s, int block);
int sock_err(int source);
void handle_dcc_request(STab *stab, char *user, char *msg);
void download_close(Transfer *download, TransferInfo info);
void upload_close(Transfer *upload, TransferInfo info);
void transfer_close(Transfer *t, TransferInfo info);
int start_timeout(void *data);
int accept_timeout(void *data);
void show_download(Transfer *download);
FILE *open_path(Transfer *t);
float get_avg_kps(Transfer *t);
float mod_xfer_stats(Transfer *t);
void inc_xfer_size(Transfer *t, size_t n);
int get_temp_size(int type);
void transfers_disable(int type);
void transfers_enable(int type);
int h_bandwidth_cap(Transfer *t);
void h_download(void *data, int source, GdkInputCondition cond);
void h_upload(void *data, int source, GdkInputCondition cond);
int update_transfer(void *data);
void finalize_connect_download(void *data, int source, GdkInputCondition cond);
void setup_download_finish(Transfer *t);
int connect_complete(Transfer *t);
int setup_transfer(Transfer *t);
void transfer_callbacks(Transfer *t);
void start_download(Transfer *download);
void start_upload(Transfer *upload);
void start_transfer(Transfer *t);
void finish_submit(STab *stab, Connection *c);
GList *find_pending_dir(GList **list);
char *construct_packet(STab *stab, Connection *c);
void handle_submit(void *data, int source, GdkInputCondition cond);
void push_transfer_info(Transfer *t, char *nick, char *file, unsigned long int *size);
int accept_complete(Transfer *t);
void close_accept(Connection *c);
void close_transfer(Transfer *t);
void setup_accept_browse(Connection *c, char *buf);
void setup_accept_transfer(Connection *c, char *buf);
void handle_accept_header(void *data, int source, GdkInputCondition cond);
void transfer_header(void *data, int source, GdkInputCondition cond);
void handle_connection(void *data, int source, GdkInputCondition cond);
void conn_outgoing_header(void *data, int source, GdkInputCondition cond);
void conn_outgoing(void *data, int source, GdkInputCondition cond);
void network_read_cb(void *data, int source, GdkInputCondition cond);
void read_best_host(void *data, int source, GdkInputCondition cond);
void conn_main(void *data, int source, GdkInputCondition cond);
void login(STab *stab, int source);
void conn_final(void *data, int source, GdkInputCondition cond);
/* !prototypes */

#endif /* __NETWORK_H */
