#include "gnapster.h"

#include "servers.h"
#include "napigator.h"

void napigator_finish(STab *stab, int s) {
   /* repopulate */
   populate_browse_dlg_clist();
   
   /* close it */
   refresh_dlg_cb(NULL, NULL);
   
   INPUT_REMOVE(stab->ci->napigator_input);
   CLOSE(s);
}

int napigator_process(char *data) {
   char *dptr, *dup;
   char *ip, *port, *network, *title;
   unsigned long users, files, gigs;
   int ret = 1;
   
   d_assert_return(data != NULL, 0);
   
   dup = d_strdup(data);
   dptr = dup;
   
   ip = next_arg(dptr, &dptr);
   port = next_arg(dptr, &dptr);
   network = next_arg(dptr, &dptr);
   convert(next_arg(dptr, &dptr), "%lu", &users);
   convert(next_arg(dptr, &dptr), "%lu", &files);
   convert(next_arg(dptr, &dptr), "%lu", &gigs);
   title = next_arg(dptr, &dptr);
   
   if (na_err)
     d_free(dup);
   
   NA_ERR_HANDLE(ret);
   
   if (!strcmp(network, "Napster"))
     ret = 0;
   else if (!check_server_match(ip, port))
     append_server_entry(ip, port, title, network, users, files, gigs);
   
   d_free(dup);
   
   return ret;
}

void napigator_read(void *data, int source, GdkInputCondition cond) {
   int n;
   STab *stab;
   char buf[1024], *ptr;
   NBRead *nb;
   
   d_assert(data != NULL);
   
   stab = data;
   
   n = recv(source, buf, sizeof(buf) - 1, 0);
   if (n <= 0) {
      napigator_finish(stab, source);
      return;
   }
   
   buf[n] = 0;
   
   nb = nb_active(NAPIGATOR);
   
   for(ptr=buf; n>0; ptr++, n--) {
      if (*ptr == '\n') {
	 nb_terminate(nb);

	 hack_chr(nb->data, '\r');

	 /* HTTP header */
	 if (!strcmp(nb->data, "Content-Type: text/html"))
	   nb->flag++;
	 else if (nb->flag) {
	    if (!napigator_process(nb->data)) {
	       napigator_finish(stab, source);
	       
	       nb_finish(nb);
	       
	       return;
	    }
	 }
      } else
	nb_add(nb, *ptr);
   }
}

void napigator_conn(void *data, int source, GdkInputCondition cond) {
   STab *stab;
   
   d_assert(data != NULL);
   
   stab = data;
   
   gdk_input_remove(stab->ci->napigator_input);
   
   if (sock_err(source)) {
      j_error_dialog("Could not create connection to www.napigator.com");
      return;
   }
   
   set_blocking(source, 1);
   
   n_send(source, "GET /servers.php?version=107&client=gnapster HTTP/1.0\n\n");
   
   stab->ci->napigator_input = INPUT_ADD(source, GDK_INPUT_READ,
				   napigator_read, stab);
}

void napigator_connect() {
   STab *stab;
   
   stab = get_current_stab();
   
   /* gah, quit hardcoding stuff! */
   dispatch_connect(inet_addr("209.25.178.23"), htons(80),
		    &(stab->ci->napigator_sock), &(stab->ci->napigator_input),
		    GDK_INPUT_WRITE, napigator_conn, stab);
}
