#ifndef __GNAPSTER_H
#define __GNAPSTER_H

#include "config.h"
#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <libintl.h>
#define _(string) dgettext(PACKAGE, string)
#define N_(string) string
#endif /* HAVE_GNOME */

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#include <sys/time.h>

#include <ctype.h>

#include "types.h"
#include "nb.h"
#include "napster.h"
#include "search.h"
#include "network.h"
#include "clist.h"
#include "callbacks.h"
#include "fuckgnome.h"
#include "connect.h"
#include "text.h"
#include "utils.h"
#include "upload.h"
#include "debug.h"
#include "ui.h"

#include <errno.h>

extern int na_err;

extern GList *ttbl;

#define NAP_VERSION "Gnapster 1.5.0"

/* default napster port */
#define NAP_PORT 6699


#define FORSTABS(x) { STab *stab;ConnInfo *ci;GList *ptr;for(ptr=ttbl;ptr;ptr=ptr->next) {stab=ptr->data;if(!stab)continue;ci=stab->ci;x;} }


#define NA_RESET_CONTINUE() { na_err = 0; continue; }
#define NA_RESET_BREAK() { na_err = 0; break; }
#define NA_RESET_RETURN(x) { na_err = 0; return (x); }
#define NA_RESET() na_err = 0

#define NA_ERR_HANDLE(x) if (na_err) NA_RESET_RETURN(x)
#define NA_ERR_HANDLE_CONTINUE() if (na_err) NA_RESET_CONTINUE()
#define NA_ERR_HANDLE_BREAK() if (na_err) NA_RESET_BREAK()

#define INT(x) GPOINTER_TO_INT(x)

/* these are in place to make sure we are not closing/removing
 * things twice */
#define CLOSE(x) if (x >= 0) { close(x); x=-1; } /*else DEBUG_OUT("%s\n", #x);*/
#define INPUT_REMOVE(x) if (x > 0) { gdk_input_remove(x); x=-1; } /*else DEBUG_OUT("%s\n", #x);*/
#define TIMEOUT_REMOVE(x) if (x > 0) { gtk_timeout_remove(x); x=-1; } /*else DEBUG_OUT("%s\n", #x);*/

#define MESSAGE ""
#define SYSTEM "system"
#define SYSTEM_N "system_negative"
#define SYSTEM_P "system_positive"

#define MAX_HISTORY 15

#define DOWNLOAD_FORCE 0x01
#define DOWNLOAD_NORMAL 0x02

#define CURR -2
#define CONSOLE 0
#define MOTD 1

struct _ConfigTable {
   char *conf_str;
   int key;
   int conf_val;
};

typedef void (*GnapsterFreeFunc) (char *file, int line, void *data);
struct _FreeTable {
   StructType type;
   GnapsterFreeFunc func;
   size_t size;
};

struct _HookTable {
   unsigned short command;
   char *hook;
};

struct _Type {
   int type;
};

struct _Theme {
   char *file;
   char *name;
   char *author;
};

struct _ThemeHook {
   char *name;
   char *data;
};

struct _FileEntry {
   char *line;
   char *lptr;
};

struct _ChannelInfo {
   char *channel_name;
   int user;
   GtkWidget *text;
   GtkWidget *clist;
   GtkWidget *label;
   GtkWidget *vbox;
   GtkWidget *topic;
};

enum {
   NAME_FIX, LINE_SPEED_SWITCH, LINE_SPEED_CMP, LINE_SPEED,
   BITRATE_SWITCH, BITRATE_CMP, BITRATE, MAX_UPLOADS_SWITCH, MAX_UPLOADS,
   REJECT_UL, FIREWALL, MAX_PERUSER_UPLOADS_SWITCH, MAX_PERUSER_UPLOADS,
   AUTOQUERY, MAX_DOWNLOADS_SWITCH, MAX_DOWNLOADS,
   MAX_PERUSER_DOWNLOADS_SWITCH, MAX_PERUSER_DOWNLOADS, HIDE_USERS,
   LOGGING, HIDE_JOINPART, SOCKS_FIREWALL, SOCKS4, SOCKS5, TINT,
   TINT_RED, TINT_GREEN, TINT_BLUE, AUTOCANCEL, SEARCH_LOCAL, LIST_REFRESH,
   BROADCAST, SHOW_STABS, DISABLE_UL, EXEC_DL_OPTN, BW_DOWN, BW_UP,
   TIMESTAMP_EV,
   TERMINATION
};

struct _UserInfo {
/*   char *user;
   char *pass;*/
   
   char *download_dir;
   char *upload_dir;
   
   int connection;
   
   int conf[TERMINATION + 1];
   
   int new_user;
   
   char *default_font;
   
   char *theme;
};

/* prototypes */
Transfer *real_download_guess(STab **st, char *user, char *file, int *row);
int real_upload_guess(STab **st, char *user, char *file);
Transfer *real_download(STab *stab, char *user, char *file, int *row);
char *gnapster_sv();
int gnapster_key_lookup(char *s);
void config_combo_widget(GtkWidget *w, char *key);
void config_toggle_widget(GtkWidget *w, char *key, ...);
int upload_accepted(STab *st, char *user, char *file);
int verify_file_shared(char *sfile);
FILE *open_file(Transfer *download, char *file);
void *download_dup(Transfer *download);
void *search_dup(Search *search, int type);
void construct_path(GtkWidget *w, Search *orig, Transfer *out);
Transfer *gnapster_parse_download(STab *stab, char *s, int alt);
Search *gnapster_parse_search(STab *st, char *s);
Search *gnapster_parse_resume(char *s);
void check_resume(Transfer *t);
Search *gnapster_parse_browse(STab *stab, char *s, char **next, int opennap);
int gnapster_update_appbar();
void update_status(int x, STab *stab, char *s, int i);
void change_title(STab *stab);
void change_status(STab *stab);
void highlight(GtkWidget *notebook, GtkWidget *vbox);
int user_lookup(STab *stab, char *user);
int gnapster_get_pagenum(STab *stab);
int gnapster_clist_append(GtkWidget *clist, GtkWidget *vbox, void *data, ...);
void *gnapster_get_selection_data(GtkWidget *clist, int *row);
void *gnapster_get_ctree_selection_data(GtkWidget *ctree, int *row);
void gnapster_get_styles(GtkWidget *widget);
void gnapster_config_set_int(int defaults);
void gnapster_config_get_int();
int verify_shared();
void load_signore();
int idle_startup_cb(gpointer data);
void load_pixmaps();
void set_window_geometry();
void gnapster_142to150();
int main(int argc, char **argv);
/* !prototypes */

#endif /* __GNAPSTER_H */
