#include "gnapster.h"

#include "download.h"
#include "queue.h"

extern UserInfo user_info;

#ifndef HAVE_GNOME
extern GtkItemFactory *download_popup_menu, *queue_popup_menu;
#else
static GnomeUIInfo download_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Browse user's mp3s"), NULL, browse_user_menu_cb,
			  GNOME_STOCK_MENU_OPEN),
   GNOMEUIINFO_ITEM_STOCK(N_("Whois user"), NULL, whois_user_menu_cb,
			  GNOME_STOCK_MENU_INDEX),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Retry Download"), NULL, retry_download_cb,
			  GNOME_STOCK_MENU_REFRESH),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Move to queue"), NULL, cancel_movequeue_cb,
			  GNOME_STOCK_MENU_REVERT),
   GNOMEUIINFO_ITEM_STOCK(N_("Cancel download"), NULL, cancel_download_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_ITEM_STOCK(N_("Cancel and remove file"), NULL, cancel_remove_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_END,
};

static GnomeUIInfo queue_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Browse user's mp3s"), NULL, browse_user_menu_cb,
			  GNOME_STOCK_MENU_OPEN),
   GNOMEUIINFO_ITEM_STOCK(N_("Whois user"), NULL, whois_user_menu_cb,
			  GNOME_STOCK_MENU_INDEX),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Force download"), NULL, force_queue_cb,
			  GNOME_STOCK_MENU_REVERT),
   GNOMEUIINFO_ITEM_STOCK(N_("Cancel queue"), NULL, cancel_queue_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_END,
};
#endif /* ! HAVE_GNOME */

DownloadTab *create_download_tab(GtkWidget *notebook) {
   int w;
   char *titles[] = { _("Filename"), _("Connection"), _("User"), _("Kbps"), _("Info"), NULL };
   char *queue_titles[] = { _("Filename"), _("Connection"), _("User"), _("Size"), _("Length"), _("Kbps"), NULL };
   DownloadTab *dt;
   
   w = j_config_get_int("/gnapster/Geometry/w");
   
   dt = d_new(DOWNLOAD_TAB);
   
   dt->vbox = gtk_vbox_new(FALSE, 5);
   
   
   dt->hbox = j_line_new(dt->vbox, 0, 0);


   dt->max_downloads_switch = gtk_check_button_new_with_label(_("Max simultaneous downloads:"));
   j_box_pack(dt->hbox, dt->max_downloads_switch, 0, 0, 0);

   
   dt->max_downloads = gtk_spin_button_new((GtkAdjustment *)gtk_adjustment_new(5.0, 0.0, 50.0, 1.0, 5.0, 0.0),
						    0, 0);
   gtk_widget_set_sensitive(dt->max_downloads, user_info.conf[MAX_DOWNLOADS_SWITCH]);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(dt->max_downloads),
			     user_info.conf[MAX_DOWNLOADS]);
   config_combo_widget(dt->max_downloads, "max_downloads");
   j_box_pack(dt->hbox, dt->max_downloads, 0, 0, 0);
   
   config_toggle_widget(dt->max_downloads_switch, "max_downloads_switch",
			dt->max_downloads, NULL);
   
   
   dt->max_peruser_downloads_switch = gtk_check_button_new_with_label(_("Max per user downloads:"));
   j_box_pack(dt->hbox, dt->max_peruser_downloads_switch, 0, 0, 0);

   
   dt->max_peruser_downloads = gtk_spin_button_new((GtkAdjustment *)gtk_adjustment_new(1.0, 0.0, 50.0, 1.0, 5.0, 0.0),
							   0, 0);
   gtk_widget_set_sensitive(dt->max_peruser_downloads, user_info.conf[MAX_PERUSER_DOWNLOADS_SWITCH]);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(dt->max_peruser_downloads),
			     user_info.conf[MAX_PERUSER_DOWNLOADS]);
   config_combo_widget(dt->max_peruser_downloads, "max_peruser_downloads");
   j_box_pack(dt->hbox, dt->max_peruser_downloads, 0, 0, 0);
   
   config_toggle_widget(dt->max_peruser_downloads_switch,
			"max_peruser_downloads_switch",
			dt->max_peruser_downloads, NULL);

   dt->autocancel = gtk_check_button_new_with_label("Auto-cancel remotely queued");
   config_toggle_widget(dt->autocancel, "autocancel", NULL);
   j_box_pack(dt->hbox, dt->autocancel, 0, 0, 0);
   
   dt->hbox = j_line_new(dt->vbox, 1, 1);
   
   dt->vpane = gtk_vpaned_new();
   j_box_pack(dt->hbox, dt->vpane, 1, 1, 0);
   
   
   dt->scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(dt->scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
/*   gtk_box_pack_start(GTK_BOX(dt->vpane), dt->scroller,
		      TRUE, TRUE, 0);*/
   gtk_paned_pack1(GTK_PANED(dt->vpane), dt->scroller, 0, 1);
   
   
   dt->clist = gtk_clist_new_with_titles(5, titles);
   gtk_clist_set_selection_mode(GTK_CLIST(dt->clist),
				GTK_SELECTION_EXTENDED);
   gtk_clist_set_column_width(GTK_CLIST(dt->clist), 0, 290 + (w - DEFAULT_WIDTH));
   gtk_clist_set_column_width(GTK_CLIST(dt->clist), 2, 75);
   gtk_clist_set_column_width(GTK_CLIST(dt->clist), 3, 35);
/*   GTK_CLIST(dt->clist)->button_actions[2] = GTK_BUTTON_SELECTS;*/
   gtk_container_add(GTK_CONTAINER(dt->scroller), dt->clist);
   gtk_signal_connect(GTK_OBJECT(dt->clist), "button_press_event",
		      GTK_SIGNAL_FUNC(menu_popup_cb), download_popup_menu);
   
   
/*   dt->hbox = j_line_new(dt->vbox, 1, 1); */
   
   
   dt->scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(dt->scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
/*   gtk_box_pack_start(GTK_BOX(dt->vpane), dt->scroller,
		      TRUE, TRUE, 0);   */
   gtk_paned_pack2(GTK_PANED(dt->vpane), dt->scroller, 0, 1);
   
   
   dt->queue_clist = gtk_clist_new_with_titles(6, queue_titles);
   gtk_clist_set_selection_mode(GTK_CLIST(dt->queue_clist),
				GTK_SELECTION_EXTENDED);
   gtk_clist_set_column_width(GTK_CLIST(dt->queue_clist), 0, 310 + (w - DEFAULT_WIDTH));
   gtk_clist_set_column_width(GTK_CLIST(dt->queue_clist), 2, 75);
   gtk_clist_set_column_width(GTK_CLIST(dt->queue_clist), 3, 40);
   gtk_clist_set_reorderable(GTK_CLIST(dt->queue_clist), 1);
/*   GTK_CLIST(dt->queue_clist)->button_actions[2] = GTK_BUTTON_SELECTS;*/
   gtk_container_add(GTK_CONTAINER(dt->scroller), dt->queue_clist);
   gtk_signal_connect(GTK_OBJECT(dt->queue_clist), "button_press_event",
		      GTK_SIGNAL_FUNC(menu_popup_cb), queue_popup_menu);

   
   gtk_container_set_border_width(GTK_CONTAINER(dt->vbox), 5);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			    dt->vbox, gtk_label_new("Download"));
   
   return dt;
}


