/* bla bla bla */

#ifndef __DEBUG_H
#define __DEBUG_H

#define DEADBEEF ((void *)0xdeadbeef)

/* this is for input/timeout debugging */
/* #define CB_DEBUG */

/* function trace debugging (limited function set) */
/* #define DEBUG_TRACING */

void d_warning(const char *, int, char *, char *, void *);
void d_trace(const char *, int, char *, int);
void *d_memory_hunk_append(const char *, int, void *, unsigned int);
char *d_config_get_string(const char *, int, const char *);
void *d_hunk_add(const char *, int, void *, unsigned int);
void *d_new(const char *, int, int);
void *d_malloc(const char *, int, unsigned int);
void *d_realloc(const char *, int, void *, unsigned int);
void *d_calloc(const char *, int, unsigned int);
char *d_strdup_vprintf(const char *, int, const char *s, va_list args);
char *d_str_expand(char **, const char *, ...);
char *d_strdup_printf(char **, const char *s, ...);
void *dbg_free(const char *, int, void *ptr);
int d_strcmp(const char *, const char *);
char *d_strdup(const char *, int, const char *s);
void d_summary();

#define ASSERT(exp) fprintf(stderr, "%s:%i: %s(): assertion `%s' failed\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, #exp)

#define d_assert(exp) if (!(exp)) { ASSERT(exp); return; }
#define d_assert_return(exp,ret) if (!(exp)) { ASSERT(exp); return ret; }

#define DEBUG __FILE__,__LINE__,


#ifdef DEBUG_TRACING
#define DEBUG_TRACE() d_trace(DEBUG __PRETTY_FUNCTION__, 0)
#define DEBUG_TRACEOUT() d_trace(DEBUG __PRETTY_FUNCTION__, 1)
#else
#define DEBUG_TRACE()
#define DEBUG_TRACEOUT()
#endif /* DEBUG_TRACING */

#define DEBUG_OUT printf("%s:%i: %s(): ", DEBUG __PRETTY_FUNCTION__); fflush(stdout); printf

#define D_PRINT(x) printf("%s = 0x%08x\n", #x, (unsigned int)x)

#ifdef CB_DEBUG
# define INPUT_ADD_FULL(a,b,c,d,e) gdk_input_add_full(a, (b & GDK_INPUT_WRITE) ? b | GDK_INPUT_EXCEPTION : b, cb_input_debug, cb_pack(DEBUG #c, c, NULL, d), (GtkDestroyNotify)e)
# define INPUT_ADD(a,b,c,d) INPUT_ADD_FULL(a, b, c, d, gnapster_destroy)
# define TIMEOUT_ADD(a,b,c) gtk_timeout_add_full(a, cb_timeout_debug, NULL, cb_pack(DEBUG #b, NULL, b, c), (GtkDestroyNotify)gnapster_destroy)
#else
# define INPUT_ADD_FULL(a,b,c,d,e) gdk_input_add_full(a, b, c, d, e)
# define INPUT_ADD(a,b,c,d) gdk_input_add(a, b, c, d)
# define TIMEOUT_ADD(a,b,c) gtk_timeout_add(a, b, c) 
#endif /* CB_DEBUG */

#define read_file(x) read_file(DEBUG x)
#define read_file_with_n(x) read_file_with_n(DEBUG x)
#define d_config_get_string(x) d_config_get_string(DEBUG x)
#define d_hunk_add(x,y) d_hunk_add(DEBUG x,y)
#define d_new(x) d_new(DEBUG x)
#define d_malloc(x) d_malloc(DEBUG x)
#define d_realloc(x,y) d_realloc(DEBUG x,y)
#define d_calloc(x) d_calloc(DEBUG x)
#define d_strdup_vprintf(x,y) d_strdup_vprintf(DEBUG x,y)

#define d_strexp d_hunk_add(DEADBEEF, sizeof(void *)), d_str_expand
#define d_msprintf d_hunk_add(DEADBEEF, sizeof(void *)), d_strdup_printf

#define D_FREE(x,y,z) dbg_free(x, y, z)
#define d_free(x) dbg_free(DEBUG x)
#define j_free(x,y) j_dbg_free(DEBUG x,y)

#define d_strdup(x) d_strdup(DEBUG x)

#endif /* __DEBUG_H */
