#include "gnapster.h"

#include "text.h"
#include "chan.h"

extern UserInfo user_info;
extern GnapsterMain *gmain;

#ifndef HAVE_GNOME
extern GtkItemFactory *chat_popup_menu;
#else
static GnomeUIInfo chat_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Browse user's mp3s"), NULL, browse_user_menu_cb,
			  GNOME_STOCK_MENU_OPEN),
   GNOMEUIINFO_ITEM_STOCK(N_("Whois user"), NULL, whois_user_menu_cb,
			  GNOME_STOCK_MENU_INDEX),
   GNOMEUIINFO_END,
};
#endif /* ! HAVE_GNOME */

ConsoleTab *create_console_tab(STab *stab, GtkWidget *notebook) {
   ConsoleTab *ct;
   
   ct = d_new(CONSOLE_TAB);
   
/*   ct->main_vbox = gtk_vbox_new(FALSE, 5);*/
   ct->main_vbox = stab->vbox;
   
 /*  ct->notebook = gtk_notebook_new();
   gtk_signal_connect(GTK_OBJECT(ct->notebook), "switch_page",
		      GTK_SIGNAL_FUNC(switch_page_cb), NULL);
   j_box_pack(ct->main_vbox, ct->notebook, 1, 1, 1);*/
   ct->notebook = notebook;

   ct->vbox = gtk_vbox_new(FALSE, 5);
   
   ct->hbox = j_line_new(ct->vbox, 1, 1);
   
   
   /* NEW XTEXT METHOD */
   
   ct->text = gtk_xtext_new(0, 0);
   gtk_xtext_set_palette(GTK_XTEXT(ct->text), colors);
   gtk_xtext_set_font(GTK_XTEXT(ct->text), xtext_font, 0);
   gtk_xtext_set_background(GTK_XTEXT(ct->text),
			    NULL, user_info.conf[TINT], user_info.conf[TINT]);
   
   GTK_XTEXT(ct->text)->tint_red = user_info.conf[TINT_RED];
   GTK_XTEXT(ct->text)->tint_green = user_info.conf[TINT_GREEN];
   GTK_XTEXT(ct->text)->tint_blue = user_info.conf[TINT_BLUE];
   
   hook_configure_event(gmain->window, ct->text);
   
   GTK_WIDGET_UNSET_FLAGS(ct->text, GTK_CAN_FOCUS);
   j_box_pack(ct->hbox, ct->text, 1, 1, 0);
   
   ct->scroller = gtk_vscrollbar_new(GTK_XTEXT(ct->text)->adj);
   j_box_pack(ct->hbox, ct->scroller, 0, 0, 0);
   
/*   ct->text = gtk_text_new(NULL, NULL);
   gtk_text_set_point(GTK_TEXT(ct->text), 0);
   gtk_text_set_editable(GTK_TEXT(ct->text), FALSE);
   gtk_container_add(GTK_CONTAINER(ct->scroller), ct->text);*/

   ct->entry = gtk_entry_new();
   SET_DATA(stab->vbox, "focus_widget", ct->entry);
   gtk_signal_connect(GTK_OBJECT(ct->entry), "activate",
		      GTK_SIGNAL_FUNC(console_activate_cb), NULL);
   gtk_signal_connect(GTK_OBJECT(ct->entry), "key_press_event",
		      GTK_SIGNAL_FUNC(console_keypress_cb), NULL);
   j_box_pack(ct->main_vbox, ct->entry, 0, 0, 0);
   
   ct->channel_list = NULL;

   ct->links = NULL;
   
   gtk_container_set_border_width(GTK_CONTAINER(ct->vbox), 5);

   gtk_widget_show_all(ct->main_vbox);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(ct->notebook),
			    ct->vbox, gtk_label_new("Messages"));
   
   
   
/*   gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			    ct->main_vbox, gtk_label_new("Console"));*/
   
   gtk_widget_realize(ct->text);
   
   return ct;
}

void append_console_tab(STab *stab, char *channel_name, int user) {
   char *titles[] = { _("Username"), _("Shares"), _("Connection"), NULL };
   ChannelTab channel;
   ChannelInfo *chan;
   ConsoleTab *ct;
   GtkWidget *thbox = NULL, *htopic, *topic, *hbox, *vbox = NULL, *vbox_bbar;
   
   ct = stab->ct;

   if (!channel_name) 
     return;
   
   topic = NULL;
   
   channel.vbox = gtk_vbox_new(FALSE, 5);

   if (!user) {
      thbox = j_line_new(channel.vbox, 0, 0);
   
      channel.label = gtk_label_new("Topic: ");
      j_box_pack(thbox, channel.label, 0, 0, 0);
      
      topic = gtk_entry_new();
      GTK_WIDGET_UNSET_FLAGS(topic, GTK_CAN_FOCUS);
      gtk_entry_set_editable(GTK_ENTRY(topic), 0);
      j_box_pack(thbox, topic, 1, 1, 0);
      
      channel.label = gtk_label_new("Users: ");
      j_box_pack(thbox, channel.label, 0, 0, 0);
   }
   
   channel.hbox = j_line_new(channel.vbox, 1, 1);

   channel.text = gtk_xtext_new(0, 0);
   
   gtk_xtext_set_palette(GTK_XTEXT(channel.text), colors);
   gtk_xtext_set_font(GTK_XTEXT(channel.text), xtext_font, 0);
   gtk_xtext_set_background(GTK_XTEXT(channel.text),
			    NULL, user_info.conf[TINT], user_info.conf[TINT]);
   
   GTK_XTEXT(channel.text)->tint_red = user_info.conf[TINT_RED];
   GTK_XTEXT(channel.text)->tint_green = user_info.conf[TINT_GREEN];
   GTK_XTEXT(channel.text)->tint_blue = user_info.conf[TINT_BLUE];

   hook_configure_event(gmain->window, channel.text);
   
   GTK_WIDGET_UNSET_FLAGS(channel.text, GTK_CAN_FOCUS);
   j_box_pack(channel.hbox, channel.text, 1, 1, 0);
   
   channel.scroller = gtk_vscrollbar_new(GTK_XTEXT(channel.text)->adj);
   j_box_pack(channel.hbox, channel.scroller, 0, 0, 0);
   
   if (!user) {
      vbox = gtk_vbox_new(FALSE, 5);
      j_box_pack(channel.hbox, vbox, 0, 0, 0);
      
      hbox = j_line_new(vbox, 0, 0);
      
/*      channel.label = gtk_label_new("Users: ");
      j_box_pack(hbox, channel.label, 0, 0, 0);*/
      
      channel.scroller2 = gtk_scrolled_window_new(NULL, NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(channel.scroller2),
				     GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
      j_box_pack(vbox, channel.scroller2, 1, 1, 0);

      channel.clist = gtk_clist_new_with_titles(3, titles);
      gtk_clist_set_column_width(GTK_CLIST(channel.clist), 0, 90);
      gtk_clist_set_column_width(GTK_CLIST(channel.clist), 1, 30);
      gtk_clist_set_sort_column(GTK_CLIST(channel.clist), 0);
      gtk_clist_set_compare_func(GTK_CLIST(channel.clist), compare_chan_user);
      gtk_widget_set_usize(GTK_WIDGET(channel.clist), 200, -1);
      gtk_container_add(GTK_CONTAINER(channel.scroller2),
			channel.clist);
      gtk_signal_connect(GTK_OBJECT(channel.clist), "button_press_event",
			 GTK_SIGNAL_FUNC(menu_popup_cb), chat_popup_menu);
      gtk_signal_connect(GTK_OBJECT(channel.clist), "click-column",
			 GTK_SIGNAL_FUNC(channel_sort), NULL);
      
      vbox_bbar = gtk_vbox_new(FALSE, 5);
      j_box_pack(channel.hbox, vbox_bbar, 0, 0, 0);
      
      htopic = gtk_button_new_with_label("");
      j_box_pack(vbox_bbar, htopic, 0, 0, 0);
      gtk_signal_connect(GTK_OBJECT(htopic), "clicked",
			 GTK_SIGNAL_FUNC(hide_topic_cb), thbox);

      channel.hide_list = gtk_button_new_with_label(">");
      j_box_pack(vbox_bbar, channel.hide_list, 1, 1, 0);
      gtk_signal_connect(GTK_OBJECT(channel.hide_list), "clicked",
			 GTK_SIGNAL_FUNC(hide_list_cb), vbox);
   } else {
      channel.scroller2 = NULL;
      channel.clist = NULL;
   }
   
   gtk_container_set_border_width(GTK_CONTAINER(channel.vbox), 5);

   gtk_widget_show_all(channel.vbox);
   if (user_info.conf[HIDE_USERS])
     hide_list_cb(channel.hide_list, vbox);

   gtk_notebook_append_page(GTK_NOTEBOOK(ct->notebook),
			    channel.vbox, gtk_label_new(channel_name));
   
   gtk_widget_realize(channel.text);

   chan = d_calloc(sizeof(ChannelInfo));
   chan->channel_name = d_strdup(channel_name);
   chan->user = user;
   chan->text = channel.text;
   chan->clist = channel.clist;
   chan->topic = topic;
   chan->label = channel.label;
   chan->vbox = channel.vbox;
   
   ct->channel_list = g_list_append(ct->channel_list, chan);
}

int remove_console_tab(STab *stab, char *data, int user) {
   int page_num;
   GList *ptr;
   ChannelInfo *ch;
   char *chan;
   GtkCList *clist = NULL;
   
   if (!data)
     page_num = gtk_notebook_get_current_page(GTK_NOTEBOOK(stab->ct->notebook));
   else
     page_num = (chan_lookup(stab, data) - 1);
   
   if (page_num <= 0) 
     return 0;
  
   chan = chan_lookup_chan(stab, page_num - 1);
   
   if (!chan && !user) 
     return 0;
   if (chan && user) 
     return 0;
   
   if (chan)
     clist = chan_lookup_clist(stab, chan);
   if (clist)
     gtk_clist_clear(clist);
   
   ptr = g_list_nth(stab->ct->channel_list, (page_num - 1));
   if (!ptr)
     return 0;
   
   stab->ct->channel_list = 
     g_list_remove_link(stab->ct->channel_list, ptr);
   
   ch = ptr->data;
   
   if (!user)
     napster_send(stab->ci->sock, NAPSTER_PART_CHAN, ch->channel_name);
   
   d_free(ch->channel_name);
   d_free(ch);
   
   gtk_notebook_remove_page(GTK_NOTEBOOK(stab->ct->notebook), page_num);
   
   return 1;
}

