#ifndef __COMMAND_H
#define __COMMAND_H

typedef void (*GCommand) (char *command, char *args);
typedef int (*GLinkedCommand) (LinkedCommand *cmd, char **args);

#define COMMAND(x) void x (char *command, char *args)
#define LINKED_COMMAND(x) int x (LinkedCommand *cmd, char **args)

typedef enum {
   STRING             = 0x01,
   INT                = 0x02,
   LAST               = 0x04,
   QUOTED             = 0x08,
} CommandArg;

struct _LinkedCommand {
   char *command;
   GCommand func;
   GLinkedCommand link_func;
   
   unsigned short cmd;
   
   int min_args;
   int max_args;
   
   GList *args;
   
   char *syntax;
   char *help;
};

/*struct _Command {
   char *command;
   GCommand func;
   char *syntax;
   char *help;
};*/

/* prototypes */
void invalid_args(char *command);
int handle_command(STab *stab, char *command, char *args);
void exec_cmd(LinkedCommand *cmd, char *args);
void dispatch_text(ChannelInfo *chan, int page_num, char *text);
void exec_linked_cmd(LinkedCommand *cmd, char *args);
void new_linked_cmd(GList **tbl, char *group, unsigned short command, int min_args, int max_args, void *special, ...);
void new_cmd_group(GList **tbl, char *group);
void new_cmd(GList **tbl, char *command, void *func, char *args, char *desc);
void new_cmd_alias(GList **tbl, char *orig, ...);
void command_setup();
/* !prototypes */

COMMAND(do_sendtext);
COMMAND(do_xfer_stats);
COMMAND(do_help);
COMMAND(do_version);
COMMAND(do_wallop);
COMMAND(do_global);
COMMAND(do_topic);
COMMAND(do_clear);
COMMAND(do_sv);
COMMAND(do_whois);
COMMAND(do_msg);
COMMAND(do_me);
COMMAND(do_query);
COMMAND(do_ignore);
COMMAND(do_unignore);
COMMAND(do_join);
COMMAND(do_part);
COMMAND(do_raw);
COMMAND(do_kill);
COMMAND(do_kick);
COMMAND(do_ban);
COMMAND(do_tban);
COMMAND(do_unban);
COMMAND(do_muzzle);
COMMAND(do_unmuzzle);
COMMAND(do_mode);
COMMAND(do_setport);
COMMAND(do_userlevel);
COMMAND(do_setline);
COMMAND(do_links);
COMMAND(do_signore);
COMMAND(do_unsignore);
COMMAND(do_sigsave);
COMMAND(do_stats);
COMMAND(do_chanlevel);
COMMAND(do_usermode);
COMMAND(do_op);
COMMAND(do_deop);
COMMAND(do_ops);
COMMAND(do_cbans);
COMMAND(do_cban);
COMMAND(do_cunban);
COMMAND(do_cunban_all);
COMMAND(do_bans);
COMMAND(do_load);
COMMAND(do_reload);
COMMAND(do_nuke);
COMMAND(do_hook);
COMMAND(do_stab);
COMMAND(do_debug);
COMMAND(do_admin);
LINKED_COMMAND(tban);
LINKED_COMMAND(kickban);
LINKED_COMMAND(prepend_chan);
LINKED_COMMAND(prepend_nick);
LINKED_COMMAND(cmd_ack);

#endif /* __COMMAND_H */
