#ifndef __CALLBACKS_H
#define __CALLBACKS_H

#ifndef HAVE_GNOME
void thunk(gpointer data, guint function, GtkWidget *item);
enum {
   SEARCH_DOWNLOAD_CB,
   BROWSE_USER_MENU_CB,
   WHOIS_USER_MENU_CB,
   BROWSE_DOWNLOAD_CB,
   RETRY_DOWNLOAD_CB,
   CANCEL_DOWNLOAD_CB,
   CANCEL_REMOVE_CB,
   CANCEL_UPLOAD_CB,
   FORCE_QUEUE_CB,
   CANCEL_QUEUE_CB,
   MOVEQUEUE_CB
};

typedef void (*GnomeReplyCallback) (gint reply, gpointer data);

#endif /* !HAVE_GNOME */

typedef void (*CBInputFunc) (void *data, int source, GdkInputCondition cond);
typedef int (*CBTimeoutFunc) (void *data);

struct _CBPack {
   int type;
   
   char *file;
   int line;
   
   char *func_name;
   CBInputFunc input_func;
   CBTimeoutFunc timeout_func;
   
   void *data;
};

#define DCBPACK() CBPack *cb; char *file; int line; char *func_name; CBInputFunc input_func; CBTimeoutFunc timeout_func
#define CBPACK(x) cb = data; file = cb->file; line = cb->line; func_name = cb->func_name; input_func = cb->input_func; timeout_func = cb->timeout_func; x = cb->data

/* prototypes */
void thunk(gpointer data, guint function, GtkWidget *item);
CBPack *cb_pack(char *file, int line, char *func_name, void *input_func, void *timeout_func, void *data);
void cb_input_debug(void *data, int source, GdkInputCondition cond);
int cb_timeout_debug(void *data);
void disable_ul_cb(GtkWidget *w, void *data);
void total_xfer_stats();
void xfer_stats();
void switch_stab_gnome(GtkWidget *w, void *data);
void switch_stab_gtk(void *data, int callback_action, GtkWidget *w);
void show_stabs(GtkWidget *w);
void show_stabs_gnome(GtkWidget *w, void *data);
void show_stabs_gtk(void *data, int cb_action, GtkWidget *w);
FILE *open_stabs(char *flags);
void account_show(GtkWidget *w, int row, int col, GdkEvent *ev, void *data);
int account_rem(GtkWidget *w, void *data);
void account_change(GtkWidget *w, void *data);
void account_add(GtkWidget *w, void *data);
void stab_snapshot();
void browse_clear(GtkWidget *w, void *data);
int property_notify(GtkWidget *w, GdkEventProperty *event, void *data);
void gnapster_exit_cb();
void safe_exit_check();
void safe_exit_cb();
void set_trans(GtkWidget *text);
void update_xtext(GtkWidget *w);
void browse_font_ok_cb(GtkWidget *w, GtkWidget *dlg);
void browse_font_cancel_cb(GtkWidget *w, GtkWidget *dlg);
void browse_font_cb();
void update_shares_cb();
void connect_last_cb();
void already_connected_cb(gint reply, void *data);
void already_connected(STab *stab, Server *nsrv);
void connect_official_cb();
void switch_page_cb(GtkWidget *widget, GtkNotebookPage *page, int page_num, gpointer data);
void build_list_cb();
void update_list_cb();
void query_user_cb(GtkWidget *w, gpointer data);
void unquery_user_cb(GtkWidget *w, gpointer data);
void menu_popup_cb(GtkWidget *widget, GdkEventButton *event, gpointer data);
void console_activate_cb();
GList *add_nick_history(GList *nh, char *user);
void msg_cycle(STab *stab);
void tab_complete(STab *stab, char *text);
int console_keypress_cb(GtkWidget *w, GdkEventKey *key);
Search *get_data(const void *row);
User *get_chan_data(const void *row);
int compare_chan_user(GtkCList *clist, const void *row1, const void *row2);
int compare_chan_conn(GtkCList *clist, const void *row1, const void *row2);
int compare_chan_shares(GtkCList *clist, const void *row1, const void *row2);
void channel_sort(GtkCList *clist, int column);
int compare_file(GtkCList *clist, const void *row1, const void *row2);
int compare_user(GtkCList *clist, const void *row1, const void *row2);
int compare_size(GtkCList *clist, const void *row1, const void *row2);
int compare_length(GtkCList *clist, const void *row1, const void *row2);
int compare_bitrate(GtkCList *clist, const void *row1, const void *row2);
int compare_connection(GtkCList *clist, const void *row1, const void *row2);
void search_sort(GtkCList *clist, int column);
void cancel_search_cb();
void search_click_cb();
void browse_user_menu(GtkWidget *clist);
void browse_user_menu_cb(GtkWidget *w, gpointer data);
void browse_user_cb();
void whois_user_menu_cb(GtkWidget *w, gpointer data);
void connect_cb(STab *stab);
int reconnect_cb(void *data);
void disconnect(STab *stab);
void disconnect_all_cb();
void reconnect_all_cb();
void disconnect_cb();
void search_download_cb(GtkWidget *w, gpointer data);
void browse_download_cb(GtkWidget *w, gpointer data);
void cancel_upload_cb();
char *listint_to_str(int i, int type);
int liststr_to_int(char *s);
void prop_set_state(GtkWidget *widget, WidgetProperty *prop, char *s, float f);
void combo_changed(GtkWidget *widget, gpointer data);
void preferences_changed_cb();
void preferences_destroy_cb(GtkWidget *widget, gint arg1, gpointer data);
void set_prop_tog_state(GtkWidget *w, WidgetProperty *prop, int sens, int data);
void clicked_cb(GtkWidget *widget, int *data);
void preferences_clicked_cb(GtkWidget *widget, int *data);
void preferences_cb();
void build_dlg_cancel_cb();
void about_cb();
/* !prototypes */

#ifdef HAVE_GNOME
void preferences_button_cb(GtkWidget *, gint, gpointer);
#else
void preferences_button_cb(GtkWidget *, gpointer);
#endif /* HAVE_GNOME */

#endif /* __CALLBACKS_H */
