-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/import_export.adb,v $
--  Description     : Implement the import/export features
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/12/02 20:42:52 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This package implements the export of a table into an external ASCII     --
--  file. Each colon is seperated by a seperator charcter                    --
--                                                                           --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;

with GUI_Logging;              use GUI_Logging;
with ODBC;                     use ODBC;

package body Import_Export is

   Version : constant String := "$Id: import_export.adb,v 1.1 2001/12/02 20:42:52 me Exp $";

   Record_Length : Positive := 2000;

   ------------
   -- Export --
   ------------
   procedure Export(
      Table     : in String;
      Name      : in String ) is
      -- export a table into a file
      File      : File_Type;
      Last_Line : Natural := 0;
      Line      : String( 1..Record_Length );
      Length    : Natural;
   begin
      GUI_Logging.Log("Exporting table " & Table & " to file " & Name );

      Create( File, Out_File, Name );
      Close( File );

   exception
      when Error : others =>
         GUI_Logging.Error( Exception_Name (Error) );
         GUI_Logging.Error( Exception_Message (Error) );
         GUI_Logging.Error( "Import aborted at line " & Natural'Image(Last_Line) );
   end Export;

   ------------
   -- Import --
   ------------
   procedure Import(
      Table     : in String;
      Name      : in String ) is
      File      : File_Type;
      Last_Line : Natural := 0;
      Line      : String( 1..Record_Length );
      Length    : Natural;
   begin
      GUI_Logging.Log("Importing table " & Table & " from file " & Name );
      Open( File, In_File, Name );

      while not End_Of_File( File ) loop
         Last_Line := Last_Line + 1;
         Get_Line( File, Line, Length );
      end loop;

      Close( File );

   exception
      when Error : others =>
         GUI_Logging.Error( Exception_Name (Error) );
         GUI_Logging.Error( Exception_Message (Error) );
         GUI_Logging.Error( "Import aborted at line " & Natural'Image(Last_Line) );
   end Import;

end Import_Export;
