-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_editor.ads,v $
--  Description     : query editor implementation
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/07 11:49:21 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;               use Ada.Strings.Unbounded;

with Gtk.Text;                            use Gtk.Text;
with Gtk.Box;                             use Gtk.Box;
with Gtk.Gentry;                          use Gtk.Gentry;

with GSQL_Types;                          use GSQL_Types;
with GUI_Worksheet;                       use GUI_Worksheet;

package GUI_Editor is

   type Object is new GUI_Worksheet.Object with private;

   procedure Get_Result(
      This       : in Object;
      Text       : out Text_Buffer;
      Last       : out Positive );

   procedure Set_Input(
      This   : in Object;
      Text   : in Text_Buffer );

   procedure Query(
      This   : in Object;
      Text   : out Text_Buffer;
      Last   : out Positive );

private

   type Object is new GUI_Worksheet.Object with record
         Title       : Gtk_Entry;
         Description : Gtk_Text;
         Query       : Gtk_Text;
         Vbox        : Gtk_Box;
      end record;

   procedure Display(
      This        : in out Object;
      Box         : in out Gtk_Box );

   procedure Command(
      This : in out Object;
      Cmd  : in Natural );

end GUI_Editor;
