------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-binds-lob.adb,v 1.6 2003/11/24 11:43:48 vagul Exp $

with System;
package body OCI.Thick.Binds.Lob is

   Type4Bind : array (Lobs.Lob_Type) of Ub2
     := (Lobs.File  => SQLT_FILE,
         Lobs.Bin   => SQLT_BLOB,
         Lobs.NChar => SQLT_CLOB,
         Lobs.Char  => SQLT_CLOB);

   ----------
   -- Bind --
   ----------

   procedure Bind
     (Stmt  : in     Statement;
      Var   : in out Bind_Lob;
      Value : in     Lobs.Lob;
      Name  : in     String)
   is
      use type Sb4;

      use Lobs;
   begin
      Bind
        (Stmt    => Stmt,
         Var     => Var,
         Name    => Name,
         Type_Id => Type4Bind (Get_Lob_Type (Value)),
         Value   => Get_Bind_Address (Value),
         Size    => OCIHandle'Size / System.Storage_Unit,
         Ind     => Get_Bind_Indicator (Value));

      Var.Loc := Value;
   end Bind;

   -------------
   -- Get_Lob --
   -------------

   function Get_Lob (Var : Bind_Lob) return Lobs.Lob is
   begin
      return Var.Loc;
   end Get_Lob;

end OCI.Thick.Binds.Lob;

