------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-envcreate80.adb,v 1.3 2003/03/18 17:14:35 vagul Exp $

package body oci.EnvCreate80 is

   flag : boolean := False;

   function OCIEnvCreate
     (Envh : access OCIEnv;
      Mode : Ub4;
      Ctxp : Undefined;
      Malocfp : Undefined;
      Ralocfp : Undefined;
      Mfreefp : Undefined;
      Xtramemsz : Undefined;
      Usrmempp : Undefined)
      return Sword
   is
      use type Ub4;
      use type sword;
      init_mode : ub4 := 0;
      rc : sword;
   begin
      if not Flag then
         rc := OCIInitialize (mode =>
            Mode and (OCI_THREADED + OCI_OBJECT + OCI_EVENTS + OCI_SHARED),
            Ctxp => Ctxp,
            Malocfp => Malocfp,
            Ralocfp => Ralocfp,
            Mfreefp => Mfreefp);
         if rc = OCI_SUCCESS then
            Flag := True;
         else
            return rc;
         end if;
      end if;
      if (Mode and OCI_NO_UCB) /= 0 then
         init_mode := OCI_ENV_NO_UCB;
      end if;
      if (Mode and OCI_NO_MUTEX) /= 0 then
         init_mode := init_mode or OCI_ENV_NO_MUTEX;
      end if;
      return OCIEnvInit (Envh, init_mode, Xtramemsz, Usrmempp);
   end OCIEnvCreate;

   function OCILOBCREATETEMPORARY (svchp   : OCISVCCTX;
                                   errhp   : OCIERROR;
                                   locp    : OCILOBLOCATOR;
                                   csid    : ub2;
                                   csfrm   : ub1;
                                   lobtype : ub1;
                                   cache   : c.int;
                                   duration : OCIDURATION)
                                             return sword is
   begin
      raise Not_Implemented_In_This_Version;
      return OCI_ERROR;
   end OCILOBCREATETEMPORARY;

   function Not_Implemented_2 return sword is
   begin
      raise Not_Implemented_In_This_Version;
      return OCI_ERROR;
   end Not_Implemented_2;

end oci.EnvCreate80;

