--|
--| Filename        : $Source: /var/cvs/gnuada/gnade/esql/options.ads,v $
--| Description     : Option flags for the esql translator
--| Author          : Michael Erdmann
--| Created On      : 22.12.2000
--| Last Modified By: $Author: me $
--| Last Modified On: $Date: 2001/07/08 10:11:31 $
--| Status          : $State: Exp $
--|
--| Copyright (C) 2000 Michael Erdmann
--|
--| This program is free software; you can redistribute it and/or
--| modify it under the terms of the GNU General Public License
--| as published by the Free Software Foundation; either version 2
--| of the License, or (at your option) any later version.
--|
--| This program/code is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License along
--| with this program; if not, write to the Free Software Foundation, Inc.,
--| 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--|
--| As a special exception,  if other files  instantiate  generics from this
--| unit, or you link  this unit with other files  to produce an executable,
--| this  unit  does not  by itself cause  the resulting  executable  to  be
--| covered  by the  GNU  General  Public  License.  This exception does not
--| however invalidate  any other reasons why  the executable file  might be
--| covered by the  GNU Public License.
--|
--| Functional Description
--| ======================
--| This package contains the Option flags for the esql translator
--|
--| Restrictions
--| ============
--| None
--|
--| References
--| ==========
--| None
--|
with Ada.Strings.Unbounded;             use Ada.Strings.Unbounded;
with Ada.Text_IO;                       use Ada.Text_IO;

package Options is

   -- print out the activities
   Option_Verbose         : Boolean := False;

   -- if true, no copyright notices etc are printed out
   Option_SILENT          : Boolean := False;

   -- this forces the checks to be pedantic, which means deviations from
   -- ISO are indicated a warnings.
   Option_Pedantic        : Boolean := False;

   -- Controls the eception behaviour. If true the ISO/92 Section 19.2
   -- will be applied, which means after each embedded SQL all conditions
   -- are cleared.
   Option_ISO92_Exception : Boolean := False;

   -- This will generate additional in line debug code
   Option_Debug_Code      : Boolean := False;

   -- this is the max. number of error before the processing stops.
   Option_Error_Limit     : Natural := 200;

   -- do not insert the sqlstate/sqlcode automatically
   Option_No_SQLSTATE     : Boolean := False;

   -- Debugging output
   Option_DEBUG           : Boolean := False;

   -- dbcs name
   Option_DBCS            : Unbounded_String := To_Unbounded_String("ODBC");

   -- schema file
   Option_SCHEMA          : Boolean := False;
   Schema_File            : File_Type;

   -- compiler option
   type Target_Compiler_Type is (
      GNU_Ada,
      Aonix,
      Unknown   );

   Target_Compiler : Target_Compiler_Type := GNU_Ada;

end Options;


