#include <glib-object.h>

#include "common.h"

#include <gmyth/gmyth_uri.h>
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_livetv.h>
#include <gmyth/gmyth_programinfo.h>
#include <gmyth/gmyth_common.h>

#define URI_DEFAULT	"myth://192.168.3.165:6543/livetv?channel=9"

static          gboolean
test_program_info_setup(gchar * uri)
{
    GMythLiveTV    *livetv = NULL;
    GMythStringList *str_list = NULL;
    GMythProgramInfo *program_info = NULL;

    gchar          *channel_name = NULL;
    gboolean        ret = TRUE;
    gboolean        live_tv = FALSE;

    if (NULL == uri)
        uri = g_strdup(URI_DEFAULT);

    GMythURI       *gmyth_uri = gmyth_uri_new_with_value(uri);

    GMythBackendInfo *backend_info = gmyth_backend_info_new_with_uri(uri);
    live_tv = gmyth_uri_is_livetv(gmyth_uri);
    if (live_tv) {
        livetv = gmyth_livetv_new(backend_info);

        gchar          *ch = gmyth_uri_get_channel_name(gmyth_uri);
        if (ch != NULL)
            channel_name = ch;

        if (channel_name != NULL) {
            if (gmyth_livetv_channel_name_setup(livetv, channel_name) ==
                FALSE) {
                g_debug("LiveTV setup felt down on error.");
                ret = FALSE;
                goto init_failed;
            }
        } else {
            if (gmyth_livetv_setup(livetv) == FALSE) {
                g_debug("LiveTV setup felt down on error");
                ret = FALSE;
                goto init_failed;
            }
        }
    }

    g_debug("uri = %s", uri);

    if (ret == FALSE) {
        g_debug
            ("MythTV ProgramInfo request failed when setting up socket connection!");
        goto init_failed;
    }

    g_return_val_if_fail(livetv->proginfo != NULL, FALSE);

    g_debug("Printing  ProgramInfo... [%s]",
            gmyth_program_info_to_string(livetv->proginfo));

    str_list =
        gmyth_program_info_to_string_list(livetv->proginfo, str_list);

    g_return_val_if_fail(str_list != NULL
                         && gmyth_string_list_length(str_list) > 0, FALSE);

    program_info = gmyth_program_info_from_string_list(str_list);

    /*
     * assert it IS the same program info 
     */
    g_return_val_if_fail(gmyth_program_info_is_equals
                         (program_info, livetv->proginfo), FALSE);

    program_info->title =
        g_string_assign(program_info->title, "Another RaNdOm Title...");

    /*
     * assert it is not the same program info anymore 
     */
    g_return_val_if_fail(!gmyth_program_info_is_equals
                         (program_info, livetv->proginfo), FALSE);

  init_failed:
    if (str_list != NULL)
        g_object_unref(str_list);

    if (program_info != NULL)
        g_object_unref(program_info);

    if (livetv != NULL)
        g_object_unref(livetv);

    if (gmyth_uri != NULL)
        g_object_unref(gmyth_uri);

    return ret;

}

gint
main(gint args, const gchar ** argv)
{
    gboolean        ret;

    g_type_init();

    g_thread_init(NULL);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (args > 1)
        ret = test_program_info_setup(argv[1]);
    else
        ret = test_program_info_setup(NULL);

    if (!ret)
        g_debug
            ("Error when getting program info from the LiveTV instance!");
    else
        g_debug("LiveTV setup test script finished with success.");

    return (0);
}
