#include <glib-object.h>

#include "common.h"

#include <gmyth/gmyth_uri.h>
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_file.h>
#include <gmyth/gmyth_file_local.h>
#include <gmyth/gmyth_common.h>

#define URI_FILE_LOCAL_DEFAULT	"myth://192.168.3.165:6543/"

static          gboolean
test_file_local_setup(gchar * uri)
{
    GMythFileLocal *file = NULL;
    gboolean        ret = TRUE;

    if (NULL == uri)
        uri = g_strdup(URI_FILE_LOCAL_DEFAULT);

    GMythURI       *gmyth_uri = gmyth_uri_new_with_value(uri);

    GMythBackendInfo *backend_info = gmyth_backend_info_new_with_uri(uri);

    /*
     * Check if the file is local to this specific client renderer, and
     * tries to open a local connection 
     */
    if (gmyth_uri_is_local_file(gmyth_uri)) {
        g_debug("Opening local file connection to download...");
        file = gmyth_file_local_new(backend_info);
        ret = gmyth_file_local_open(file);
    } else {
        g_debug
            ("FileLocal object specified is not local to the current machine!");
        ret = FALSE;
        goto init_failed;
    }

    if (NULL == file) {
        g_debug("File is NULL");
        ret = FALSE;
        goto init_failed;
    }

    g_debug("uri = %s", uri);

    if (ret == FALSE) {
        g_debug
            ("MythTV FileLocal request failed when setting up socket connection!");
        goto init_failed;
    }

    g_debug("MythTV FileLocal filesize = %lld",
            gmyth_file_get_filesize(GMYTH_FILE(file)));

  init_failed:

    if (file != NULL)
        g_object_unref(file);

    if (gmyth_uri != NULL)
        g_object_unref(gmyth_uri);

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return ret;

}

gint
main(gint args, const gchar ** argv)
{
    gboolean        ret = FALSE;

    g_type_init();

    g_thread_init(NULL);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (args > 1)
        ret = test_file_local_setup(argv[1]);

    if (!ret)
        g_debug("Error when running FileLocal setup test script!");
    else
        g_debug("FileLocal setup test script finished with success.");

    return (0);
}
