/**
 * GMyth Library
 *
 * @file gmyth/gmyth_stringlist.h
 * 
 * @brief <p> This component contains functions for dealing with the stringlist
 * format of the mythprotocol.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Hallyson Luiz de Morais Melo <hallyson.melo@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GMYTH_STRING_LIST_H_
#define GMYTH_STRING_LIST_H_

#include <glib-object.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

G_BEGIN_DECLS
#define GMYTH_STRING_LIST_TYPE               (gmyth_string_list_get_type ())
#define GMYTH_STRING_LIST(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_STRING_LIST_TYPE, GMythStringList))
#define GMYTH_STRING_LIST_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_STRING_LIST_TYPE, GMythStringListClass))
#define IS_GMYTH_STRING_LIST(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_STRING_LIST_TYPE))
#define IS_GMYTH_STRING_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_STRING_LIST_TYPE))
#define GMYTH_STRING_LIST_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_STRING_LIST_TYPE, GMythStringListClass))
typedef struct _GMythStringList GMythStringList;
typedef struct _GMythStringListClass GMythStringListClass;

struct _GMythStringListClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
    /*
     * no one for now 
     */
};

struct _GMythStringList {
    GObject         parent;

    /*
     * string list 
     */
    GList          *glist;
};


GType           gmyth_string_list_get_type(void);

GMythStringList *gmyth_string_list_new(void);

void            gmyth_string_list_clear_all(GMythStringList * strlist);
int             gmyth_string_list_length(GMythStringList * strlist);

GString        *gmyth_string_list_append_float(GMythStringList * strlist,
                                             const gdouble value);

GString        *gmyth_string_list_append_int(GMythStringList * strlist,
                                             const gint value);
GString        *gmyth_string_list_append_uint64(GMythStringList * strlist,
                                                const guint64 value);

GString        *gmyth_string_list_append_int64(GMythStringList * strlist,
                                               const gint64 value);

GString        *gmyth_string_list_append_char_array(GMythStringList *
                                                    strlist,
                                                    const char *value);
GString        *gmyth_string_list_append_string(GMythStringList * strlist,
                                                GString * value);

int             gmyth_string_list_get_int(GMythStringList * strlist,
                                          const gint index);
guint64         gmyth_string_list_get_uint64(GMythStringList * strlist,
                                             const gint index);
gint64          gmyth_string_list_get_int64(GMythStringList * strlist,
                                            const gint index);
GString        *gmyth_string_list_get_string(GMythStringList * strlist,
                                             const gint index);

#define gmyth_string_list_get_char_array(strlist, index) \
	(gmyth_string_list_get_string(strlist, index))->str

G_END_DECLS
#endif                          /* GMYTH_STRING_LIST_H_ */
