/**
 * GMyth Library
 *
 * @file gmyth/gmyth_query.h
 * 
 * @brief <p> GMythQuery class provides a wrapper for accessing
 * the libmysqlclient funtions.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Leonardo Sobral Cunha <leonardo.cunha@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_QUERY_H__
#define __GMYTH_QUERY_H__

#include <glib-object.h>

/*
 * MYSQL includes 
 */
#include <mysql/mysql.h>

#include "gmyth_backendinfo.h"

G_BEGIN_DECLS

#define GMYTH_QUERY_STANDARD_TIMEOUT 10 /*seconds*/

#define GMYTH_QUERY_TYPE               (gmyth_query_get_type ())
#define GMYTH_QUERY(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_QUERY_TYPE, GMythQuery))
#define GMYTH_QUERY_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_QUERY_TYPE, GMythQueryClass))
#define IS_GMYTH_QUERY(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_QUERY_TYPE))
#define IS_GMYTH_QUERY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_QUERY_TYPE))
#define GMYTH_QUERY_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_QUERY_TYPE, GMythQueryClass))

typedef struct _GMythQuery GMythQuery;
typedef struct _GMythQueryClass GMythQueryClass;

struct _GMythQueryClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
    /*
     * no one for now 
     */
};

struct _GMythQuery {
    GObject         parent;

    GMythBackendInfo *backend_info;

    /*
     * pointer to connection handler 
     */
    MYSQL          *conn;
};


GType           gmyth_query_get_type(void);

GMythQuery     *gmyth_query_new(void);
MYSQL_RES      *gmyth_query_process_statement(GMythQuery * gmyth_query,
                                              gchar * stmt_str);
MYSQL_RES      *gmyth_query_process_statement_with_increment(GMythQuery *
                                                             gmyth_query,
                                                             char
                                                             *stmt_str,
                                                             gulong * id);

gboolean        gmyth_query_connect(GMythQuery * gmyth_query,
                                    GMythBackendInfo * backend_info);
gboolean        gmyth_query_connect_with_timeout(GMythQuery * gmyth_query,
                                                 GMythBackendInfo *backend_info,
                                                 guint timeout);
gboolean        gmyth_query_is_alive (GMythQuery *gmyth_query);
gboolean        gmyth_query_disconnect(GMythQuery * gmyth_query);

G_END_DECLS
#endif                          /* __GMYTH_QUERY_H__ */
