.TH GMTMATH l "18 Apr 2001"
.SH NAME
gmtmath \- Reverse Polish Notation calculator for data tables
.SH SYNOPSIS
\fBgmtmath\fP [ \fB\-C\fP\fIcols\fP ] [ \fB\-H\fP\fInrec\fP ] [ \fB\-N\fP\fIn_col\fP/\fIt_col\fP ] [ \fB\-Q\fP ]
 [ \fB\-S\fP ][ \fB\-T\fP\fIt_min/t_max/t_inc\fP ] [ \fB\-V\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ]
[ \fB\-bo\fP[\fBs\fP] ]
\fIoperand\fP [ \fIoperand\fP ] \fBOPERATOR\fP [ \fIoperand\fP ] \fBOPERATOR\fP ... \fB=\fP [ \fIoutfile\fP ]
.SH DESCRIPTION
\fBgmtmath\fP will perform operations like add, subtract, multiply, and divide on one or more table data files or constants using
Reverse Polish Notation (RPN) syntax (e.g., Hewlett-Packard calculator-style). Arbitrarily complicated expressions may therefore
be evaluated; the final result is written to an output file [or standard output]. When two data tables are
on the stack, each element in file A is modified by the corresponding element in file B.
However, some operators only require one operand (see below). If no data tables are used in the
expression then options \fB\-T, \-N\fP must be set (and optionally \fB\-b\fP). By default, all columns except the "time" column are operated on, but this can be changed (see \fB\-C\fP).
.TP
\fIoperand\fP
If \fIoperand\fP can be opened as a file it will be read as an ASCII (or binary, see \fB\-bi\fP) table data file. If not a file, it is interpreted
as a numerical constant or a special symbol (see below).
.TP
\fIoutfile\fP is a table data file that will hold the final result. If not given then
the output is sent to stdout.
.TP
.B OPERATORS
Choose among the following operators:
.br
Operator n_args Returns
.br
.sp
\fBABS\fP 1 abs (A).
.br
\fBACOS\fP 1 acos (A).
.br
\fBACOSH\fP 1 acosh (A).
.br
\fBADD(+)\fP 2 A + B.
.br
\fBAND\fP 2 NaN if A and B == NaN, B if A == NaN, else A.
.br
\fBASIN\fP 1 asin (A).
.br
\fBASINH\fP 1 asinh (A).
.br
\fBATAN\fP 1 atan (A).
.br
\fBATAN2\fP 2 atan2 (A, B).
.br
\fBATANH\fP 1 atanh (A).
.br
\fBBEI\fP 1 bei (A).
.br
\fBBER\fP 1 ber (A).
.br
\fBCEIL\fP 1 ceil (A) (smallest integer >= A).
.br
\fBCHIDIST\fP 2 Chi-squared-distribution P(chi2,n), with chi2 = A and n = B.
.br
\fBCOS\fP 1 cos (A) (A in radians).
.br
\fBCOSD\fP 1 cos (A) (A in degrees).
.br
\fBCOSH\fP 1 cosh (A).
.br
\fBD2DT2\fP 1 d^2(A)/dt^2 2nd derivative.
.br
\fBD2R\fP 1 Converts Degrees to Radians.
.br
\fBDILOG\fP 1 Dilog (A).
.br
\fBDIV(/)\fP 2 A / B.
.br
\fBDDT\fP 1 d(A)/dt 1st derivative.
.br
\fBDUP\fP 1 Places duplicate of A on the stack.
.br
\fBERF\fP 1 Error function of A.
.br
\fBERFC\fP 1 Complimentory Error function of A.
.br
\fBERFINV\fP 1 Inverse error function of A.
.br
\fBEQ\fP 2 1 if A == B, else 0.
.br
\fBEXCH\fP 2 Exchanges A and B on the stack.
.br
\fBEXP\fP 1 exp (A).
.br
\fBFDIST\fP 4 F-distribution Q(s1,s2,n1,n2), with s1 = A, s2 = B, n1 = C, and n2 = D.
.br
\fBFLOOR\fP 1 floor (A) (greatest integer <= A).
.br
\fBFMOD\fP 2 A % B (remainder).
.br
\fBGE\fP 2 1 if A >= B, else 0.
.br
\fBGT\fP 2 1 if A > B, else 0.
.br
\fBHYPOT\fP 2 hypot (A, B).
.br
\fBI0\fP 1 Modified Bessel function of A (1st kind, order 0).
.br
\fBI1\fP 1 Modified Bessel function of A (1st kind, order 1).
.br
\fBIN\fP 2 Modified Bessel function of A (1st kind, order B).
.br
\fBINT\fP 1 Numerically integrate A.
.br
\fBINV\fP 1 1 / A.
.br
\fBISNAN\fP 1 1 if A == NaN, else 0.
.br
\fBJ0\fP 1 Bessel function of A (1st kind, order 0).
.br
\fBJ1\fP 1 Bessel function of A (1st kind, order 1).
.br
\fBJN\fP 2 Bessel function of A (1st kind, order B).
.br
\fBK0\fP 1 Modified Kelvin function of A (2nd kind, order 0).
.br
\fBK1\fP 1 Modified Bessel function of A (2nd kind, order 1).
.br
\fBKN\fP 2 Modified Bessel function of A (2nd kind, order B).
.br
\fBKEI\fP 1 kei (A).
.br
\fBKER\fP 1 ker (A).
.br
\fBLE\fP 2 1 if A <= B, else 0.
.br
\fBLMSSCL\fP 1 LMS scale estimate (LMS STD) of A.
.br
\fBLOG\fP 1 log (A) (natural log).
.br
\fBLOG10\fP 1 log10 (A).
.br
\fBLOG1P\fP 1 log (1+A) (accurate for small A).
.br
\fBLOWER\fP 1 The lowest (minimum) value of A.
.br
\fBLT\fP 2 1 if A < B, else 0.
.br
\fBMAD\fP 1 Median Absolute Deviation (L1 STD) of A.
.br
\fBMAX\fP 2 Maximum of A and B.
.br
\fBMEAN\fP 1 Mean value of A.
.br
\fBMED\fP 1 Median value of A.
.br
\fBMIN\fP 2 Minimum of A and B.
.br
\fBMODE\fP 1 Mode value (LMS) of A.
.br
\fBMUL(x)\fP 2 A * B.
.br
\fBNAN\fP 2 NaN if A == B, else A.
.br
\fBNEG\fP 1 -A.
.br
\fBNRAND\fP 2 Normal, random values with mean A and std. deviation B.
.br
\fBOR\fP 2 NaN if A or B == NaN, else A.
.br
\fBPLM\fP 3 Associated Legendre polynomial P(-1<A<+1) degree B order C.
.br
\fBPOP\fP 1 Delete top element from the stack.
.br
\fBPOW(^)\fP 2 A ^ B.
.br
\fBR2\fP 2 R2 = A^2 + B^2.
.br
\fBR2D\fP 1 Convert Radians to Degrees.
.br
\fBRAND\fP 2 Uniform random values between A and B.
.br
\fBRINT\fP 1 rint (A) (nearest integer).
.br
\fBSIGN\fP 1 sign (+1 or -1) of A.
.br
\fBSIN\fP 1 sin (A) (A in radians).
.br
\fBSIND\fP 1 sin (A) (A in degrees).
.br
\fBSINH\fP 1 sinh (A).
.br
\fBSQRT\fP 1 sqrt (A).
.br
\fBSTD\fP 1 Standard deviation of A.
.br
\fBSTEP\fP 1 Heaviside step function H(A).
.br
\fBSTEPT\fP 1 Heaviside step function H(t-A).
.br
\fBSUB(-)\fP 2 A - B.
.br
\fBSUM\fP 1 Cumulative sum of A
.br
\fBTAN\fP 1 tan (A) (A in radians).
.br
\fBTAND\fP 1 tan (A) (A in degrees).
.br
\fBTANH\fP 1 tanh (A).
.br
\fBTDIST\fP 2 Student's t-distribution A(t,n), with t = A, and n = B).'
.br
\fBUPPER\fP 1 The highest (maximum) value of A.
.br
\fBXOR\fP 2 B if A == NaN, else A.
.br
\fBY0\fP 1 Bessel function of A (2nd kind, order 0).
.br
\fBY1\fP 1 Bessel function of A (2nd kind, order 1).
.br
\fBYN\fP 2 Bessel function of A (2nd kind, order B).
.br
.TP
.B SYMBOLS
The following symbols have special meaning:
.br
.sp
\fBPI\fP 3.1415926...
.br
\fBE \fP 2.7182818...
.br
\fBT \fP Table with t-coordinates
.br
.SH OPTIONS
.TP
.B \-C
Select the columns that will be operated on until next occurrence of \fB\-C\fP.
List columns separated by commas; ranges like 1,3-5,7 are allowed. [\fB\-C\fP
(no arguments) resets the default action of using all columns except time column (see \fB\-N\fP].
\fB\-Ca\fP selects all columns, inluding time column, while \fB\-Cr\fP reverses (toggles) the current
choices.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults file. If used, \fBGMT\fP default is 1 header record.
.TP
.B \-N
Select the number of columns and the column number that contains the
"time" variable. Columns are numbered starting at 0 [2/0].
.TP
.B \-Q
Quick mode for scalar calculation. Shorthand for \fB\-Ca \-N\fP1/0 \fB\-T\fP0/0/1.
.TP
.B \-S
Only report the first row of the results [Default is all rows]. This is useful if
you have computed a statistic (say the MODE) and only want to report a single number
instead of numerous records with idendical values.
.TP
.B \-T
Required when no input files are given. Sets the t-coordinates of the first
and last point and the equidistant sampling interval for the "time" column (see \fB\-N\fP).
If there is no time column (only data columns), give \fB\-T\fP with no arguments; this
also implies \fB\-Ca\fP.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
.SH BEWARE
The operator \fBPLM\fP calculates the associated Legendre polynomial
of degree L and order M, and its argument is the cosine of the colatitude
which must satisfy -1 <= x <= +1. \fBPLM\fP is not normalized.
.br
All derivatives are based on central finite differences, with natural
boundary conditions.
.SH EXAMPLES
To take log10 of the average of 2 data files, use
.br
        gmtmath file1.d file2.d \fBADD\fP 0.5 \fBMUL LOG10 =\fP file3.d
.br
.sp
Given the file samples.d, which holds seafloor ages in m.y. and seafloor depth in m, use the relation
depth(in m) = 2500 + 350 * sqrt (age) to print the depth anomalies:
.br
        gmtmath samples.d T \fBSQRT\fP 350 \fBMUL \fP2500 \fBADD SUB =\fP | lpr
.br
.sp
To take the average of columns 1 and 4-6 in the three data sets sizes.1, sizes.2, and sizes.3, use
.br
        gmtmath \fB\-C\fP1,4-6 sizes.1 sizes.2 \fBADD\fP sizes.3 \fBADD 3 DIV =\fP ave.d
.br
.sp
To take the 1-column data set ages.d and calculate the modal value and assign it to a variable, try
.br
        set mode_age = `gmtmath \fB\-S \-T\fP ages.d \fBMODE\fP \fB=\fP`
.br
.sp
To use gmtmath as a RPN Hewlett-Packard calculator on scalars (i.e., no input
files) and calculate arbitrary expressions, use the \fB\-Q\fP option.
As an example, we will calculate the value of Kei (((1 + 1.75)/2.2) + cos (60))
and store the result in the shell variable z:
.br
.sp
        set z = `gmtmath \fB\-Q\fP 1 1.75 \fBADD\fP 2.2 \fBDIV\fP 60 \fBCOSD ADD KEI =\fP`
.SH BUGS
Files that have the same name as some operators, e.g., ADD, SIGN, =, etc. cannot be read
and must not be present in the current directory. Piping of files is not allowed on input, but the output can be sent to stdout.
The stack limit is hard-wired to 50.
All functions expecting a positive radius (e.g., log, kei, etc.) are passed the
absolute value of their argument.
.SH REFERENCES
Abramowitz, M., and I. A. Stegun, 1964, \fIHandbook of Mathematical
Functions\fP, Applied Mathematics Series, vol. 55, Dover, New York.
.br
Press, W. H., S. A. Teukolsky, W. T. Vetterling, B. P. Flannery, 1992,
\fINumerical Recipes\fP, 2nd edition, Cambridge Univ., New York.
.SH "SEE ALSO"
.IR gmt (l),
.IR grd2xyz (l),
.IR grdedit (l),
.IR grdinfo (l),
.IR grdmath (l),
.IR xyz2grd (l)
