/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gmpc-metaimage.h"

#include "gmpc-metaimage-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) GMPC_METAIMAGE(x)
#define SELF_CONST(x) GMPC_METAIMAGE_CONST(x)
#define IS_SELF(x) GMPC_IS_METAIMAGE(x)
#define TYPE_SELF GMPC_TYPE_METAIMAGE
#define SELF_CLASS(x) GMPC_METAIMAGE_CLASS(x)

#define SELF_GET_CLASS(x) GMPC_METAIMAGE_GET_CLASS(x)

/* self typedefs */
typedef GmpcMetaImage Self;
typedef GmpcMetaImageClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void gmpc_metaimage_class_init (GmpcMetaImageClass * c) G_GNUC_UNUSED;
static void gmpc_metaimage_init (GmpcMetaImage * self) G_GNUC_UNUSED;
static void gmpc_metaimage_popup_destroy (GmpcMetaImage * self) G_GNUC_UNUSED;
static void gmpc_metaimage_popup_position (GmpcMetaImage * self) G_GNUC_UNUSED;
static gboolean gmpc_metaimage_popup_event (GmpcMetaImage * self) G_GNUC_UNUSED;
static gboolean gmpc_metaimage_motion_notify_event (GmpcMetaImage * self, GdkEventMotion * event, gpointer data) G_GNUC_UNUSED;
static gboolean gmpc_metaimage_leave_notify_event (GmpcMetaImage * self, GdkEventCrossing * event, gpointer data) G_GNUC_UNUSED;
static gboolean gmpc_metaimage_enter_notify_event (GmpcMetaImage * self, GdkEventCrossing * event, gpointer data) G_GNUC_UNUSED;
static void ___1a_gmpc_metaimage_finalize (GObject * obj) G_GNUC_UNUSED;
static void ___1b_gmpc_metaimage_dispose (GObject * obj) G_GNUC_UNUSED;
static void gmpc_metaimage_meta_callback (GmpcMetaWatcher * gmv, mpd_Song * song, MetaDataType type, MetaDataResult ret, char * path, gpointer data) G_GNUC_UNUSED;
static void ___real_gmpc_metaimage_image_changed (GmpcMetaImage * self, int type);
static gboolean gmpc_metaimage_menu_populate_callback (GmpcMetaImage * self, GdkEventButton * event, gpointer data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__image_changed(object,func,data)	gmpc_metaimage_connect__image_changed((object),(func),(data))
#define self_connect_after__image_changed(object,func,data)	gmpc_metaimage_connect_after__image_changed((object),(func),(data))
#define self_connect_data__image_changed(object,func,data,destroy_data,flags)	gmpc_metaimage_connect_data__image_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (GmpcMetaImage *, gint , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GmpcMetaImage *)data1,
		(gint ) g_value_get_int (param_values + 1),
		data2);
}


enum {
	IMAGE_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_LOADING_COVER_ICON,
	PROP_NO_COVER_ICON,
	PROP_IMAGE_TYPE,
	PROP_SIZE,
	PROP_HIDE_ON_NA,
	PROP_CONNECTION,
	PROP_DRAW_BORDER,
	PROP_DRAW_SHADOW,
	PROP_SQUARED
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkEventBoxClass *parent_class = NULL;

/* Short form macros */
#define self_get_loading_cover_icon gmpc_metaimage_get_loading_cover_icon
#define self_set_loading_cover_icon gmpc_metaimage_set_loading_cover_icon
#define self_get_no_cover_icon gmpc_metaimage_get_no_cover_icon
#define self_set_no_cover_icon gmpc_metaimage_set_no_cover_icon
#define self_get_image_type gmpc_metaimage_get_image_type
#define self_set_image_type gmpc_metaimage_set_image_type
#define self_get_size gmpc_metaimage_get_size
#define self_set_size gmpc_metaimage_set_size
#define self_get_hide_on_na gmpc_metaimage_get_hide_on_na
#define self_set_hide_on_na gmpc_metaimage_set_hide_on_na
#define self_get_connection gmpc_metaimage_get_connection
#define self_set_connection gmpc_metaimage_set_connection
#define self_get_draw_border gmpc_metaimage_get_draw_border
#define self_set_draw_border gmpc_metaimage_set_draw_border
#define self_get_draw_shadow gmpc_metaimage_get_draw_shadow
#define self_set_draw_shadow gmpc_metaimage_set_draw_shadow
#define self_get_squared gmpc_metaimage_get_squared
#define self_set_squared gmpc_metaimage_set_squared
#define self_popup_destroy gmpc_metaimage_popup_destroy
#define self_popup_position gmpc_metaimage_popup_position
#define self_popup_event gmpc_metaimage_popup_event
#define self_motion_notify_event gmpc_metaimage_motion_notify_event
#define self_leave_notify_event gmpc_metaimage_leave_notify_event
#define self_enter_notify_event gmpc_metaimage_enter_notify_event
#define self_new gmpc_metaimage_new
#define self_update_cover gmpc_metaimage_update_cover
#define self_connection_changed gmpc_metaimage_connection_changed
#define self_update_cover_from_song gmpc_metaimage_update_cover_from_song
#define self_meta_callback gmpc_metaimage_meta_callback
#define self_set_cover_na gmpc_metaimage_set_cover_na
#define self_set_cover_fetching gmpc_metaimage_set_cover_fetching
#define self_image_changed gmpc_metaimage_image_changed
#define self_set_cover_from_path gmpc_metaimage_set_cover_from_path
#define self_set_is_visible gmpc_metaimage_set_is_visible
#define self_get_is_visible gmpc_metaimage_get_is_visible
#define self_query_refetch gmpc_metaimage_query_refetch
#define self_menu_populate_callback gmpc_metaimage_menu_populate_callback
#define self_clear_entry gmpc_metaimage_clear_entry
#define self_select_file gmpc_metaimage_select_file
GType
gmpc_metaimage_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GmpcMetaImageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gmpc_metaimage_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GmpcMetaImage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gmpc_metaimage_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_EVENT_BOX, "GmpcMetaImage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GmpcMetaImage *)g_object_new(gmpc_metaimage_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GmpcMetaImage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GmpcMetaImage *
GET_NEW_VARG (const char *first, ...)
{
	GmpcMetaImage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GmpcMetaImage *)g_object_new_valist (gmpc_metaimage_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::finalize"
	GmpcMetaImage *self G_GNUC_UNUSED = GMPC_METAIMAGE (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 230 "gmpc-metaimage.gob"
	___1a_gmpc_metaimage_finalize(obj_self);
#line 208 "gmpc-metaimage.c"
#line 32 "gmpc-metaimage.gob"
	if(self->_priv->song) { mpd_freeSong ((gpointer) self->_priv->song); self->_priv->song = NULL; }
#line 211 "gmpc-metaimage.c"
#line 47 "gmpc-metaimage.gob"
	if(self->no_cover_icon) { g_free ((gpointer) self->no_cover_icon); self->no_cover_icon = NULL; }
#line 214 "gmpc-metaimage.c"
#line 48 "gmpc-metaimage.gob"
	if(self->loading_cover_icon) { g_free ((gpointer) self->loading_cover_icon); self->loading_cover_icon = NULL; }
#line 217 "gmpc-metaimage.c"
}
#undef __GOB_FUNCTION__

static void 
gmpc_metaimage_class_init (GmpcMetaImageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GmpcMetaImagePrivate));

	parent_class = g_type_class_ref (GTK_TYPE_EVENT_BOX);

	object_signals[IMAGE_CHANGED_SIGNAL] =
		g_signal_new ("image_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GmpcMetaImageClass, image_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_INT);
	if ___GOB_UNLIKELY(sizeof(int ) != sizeof(gint ) || parent_class == NULL /* avoid warning */) {
		g_error("gmpc-metaimage.gob line 447: Type mismatch of \"image_changed\" signal signature");
	}

#line 230 "gmpc-metaimage.gob"
	g_object_class->finalize = ___finalize;
#line 237 "gmpc-metaimage.gob"
	g_object_class->dispose = ___1b_gmpc_metaimage_dispose;
#line 447 "gmpc-metaimage.gob"
	c->image_changed = ___real_gmpc_metaimage_image_changed;
#line 250 "gmpc-metaimage.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("loading_cover_icon" /* name */,
		 _("Loading Cover Icon") /* nick */,
		 _("Stock icon to use when loading a cover") /* blurb */,
		 "media-loading-cover" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_LOADING_COVER_ICON,
		param_spec);
	param_spec = g_param_spec_string
		("no_cover_icon" /* name */,
		 _("No Cover Icon") /* nick */,
		 _("Stock icon to use when no cover is present") /* blurb */,
		 "media-no-cover" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_NO_COVER_ICON,
		param_spec);
	param_spec = g_param_spec_int
		("image_type" /* name */,
		 _("Image type") /* nick */,
		 _("Type of the image, like artist art") /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 META_ALBUM_ART /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_IMAGE_TYPE,
		param_spec);
	param_spec = g_param_spec_int
		("size" /* name */,
		 _("Size") /* nick */,
		 _("Size of the image") /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 64 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SIZE,
		param_spec);
	param_spec = g_param_spec_boolean
		("hide_on_na" /* name */,
		 _("HideOnNA") /* nick */,
		 _("Hide the image when not availibe") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_HIDE_ON_NA,
		param_spec);
	param_spec = g_param_spec_pointer
		("connection" /* name */,
		 _("Connection") /* nick */,
		 _("A mpdObj to check on") /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CONNECTION,
		param_spec);
	param_spec = g_param_spec_boolean
		("draw_border" /* name */,
		 _("DrawBorder") /* nick */,
		 _("Draw a border around the image") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DRAW_BORDER,
		param_spec);
	param_spec = g_param_spec_boolean
		("draw_shadow" /* name */,
		 _("DrawShadow") /* nick */,
		 _("Draw a shadow under the image") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DRAW_SHADOW,
		param_spec);
	param_spec = g_param_spec_boolean
		("squared" /* name */,
		 "Squared" /* nick */,
		 "Keep the widget squared" /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SQUARED,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 116 "gmpc-metaimage.gob"
static void 
gmpc_metaimage_init (GmpcMetaImage * self G_GNUC_UNUSED)
#line 346 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,GMPC_TYPE_METAIMAGE,GmpcMetaImagePrivate);
#line 26 "gmpc-metaimage.gob"
	self->_priv->status_signal = 0;
#line 352 "gmpc-metaimage.c"
#line 27 "gmpc-metaimage.gob"
	self->_priv->connect_signal = 0;
#line 355 "gmpc-metaimage.c"
#line 28 "gmpc-metaimage.gob"
	self->_priv->meta_id = 0;
#line 358 "gmpc-metaimage.c"
#line 30 "gmpc-metaimage.gob"
	self->_priv->image_url = NULL;
#line 361 "gmpc-metaimage.c"
#line 32 "gmpc-metaimage.gob"
	self->_priv->song = NULL;
#line 364 "gmpc-metaimage.c"
#line 34 "gmpc-metaimage.gob"
	self->_priv->popup_win = NULL;
#line 367 "gmpc-metaimage.c"
#line 35 "gmpc-metaimage.gob"
	self->_priv->popup_timer_id = 0;
#line 370 "gmpc-metaimage.c"
#line 36 "gmpc-metaimage.gob"
	self->_priv->popup_w = 0;
#line 373 "gmpc-metaimage.c"
#line 37 "gmpc-metaimage.gob"
	self->_priv->popup_h = 0;
#line 376 "gmpc-metaimage.c"
#line 40 "gmpc-metaimage.gob"
	self->size = 64;
#line 379 "gmpc-metaimage.c"
#line 41 "gmpc-metaimage.gob"
	self->image_type = META_ALBUM_ART;
#line 382 "gmpc-metaimage.c"
#line 42 "gmpc-metaimage.gob"
	self->connection = NULL;
#line 385 "gmpc-metaimage.c"
#line 43 "gmpc-metaimage.gob"
	self->hide_on_na = FALSE;
#line 388 "gmpc-metaimage.c"
#line 44 "gmpc-metaimage.gob"
	self->draw_border = TRUE;
#line 391 "gmpc-metaimage.c"
#line 45 "gmpc-metaimage.gob"
	self->draw_shadow = FALSE;
#line 394 "gmpc-metaimage.c"
#line 46 "gmpc-metaimage.gob"
	self->squared = TRUE;
#line 397 "gmpc-metaimage.c"
#line 47 "gmpc-metaimage.gob"
	self->no_cover_icon = g_strdup("gmpc-no-cover");
#line 400 "gmpc-metaimage.c"
#line 48 "gmpc-metaimage.gob"
	self->loading_cover_icon = g_strdup("gmpc-loading-cover");
#line 403 "gmpc-metaimage.c"
#line 53 "gmpc-metaimage.gob"
	self->is_visible = TRUE;
#line 406 "gmpc-metaimage.c"
#line 115 "gmpc-metaimage.gob"
	self->_priv->image =  gtk_image_new();
#line 409 "gmpc-metaimage.c"
 {
#line 117 "gmpc-metaimage.gob"

		gtk_event_box_set_visible_window(GTK_EVENT_BOX(self), FALSE);
		gtk_container_add(GTK_CONTAINER(self), self->_priv->image);		
		gtk_container_set_resize_mode(GTK_CONTAINER(self), GTK_RESIZE_IMMEDIATE);
		gtk_widget_show_all(GTK_WIDGET(self));
		self_set_cover_na(self);
		self->_priv->status_signal = g_signal_connect_swapped(G_OBJECT(gmpcconn), "status_changed",	G_CALLBACK(self_update_cover), G_OBJECT(self));
		self->_priv->connect_signal = g_signal_connect_swapped(G_OBJECT(gmpcconn), "connection_changed", G_CALLBACK(self_connection_changed), G_OBJECT(self));                            		


		g_signal_connect(G_OBJECT(self), "leave-notify-event" , G_CALLBACK(self_leave_notify_event), NULL);
		g_signal_connect(G_OBJECT(self), "enter-notify-event" , G_CALLBACK(self_enter_notify_event), NULL);
		g_signal_connect(G_OBJECT(self), "button-press-event", G_CALLBACK(self_menu_populate_callback), NULL);
		g_signal_connect(G_OBJECT(self), "motion-notify-event" , G_CALLBACK(self_motion_notify_event), NULL);

		self->_priv->meta_id = g_signal_connect(G_OBJECT(gmw), "data-changed", G_CALLBACK(self_meta_callback), self);
		gtk_widget_add_events(GTK_WIDGET(self), GDK_POINTER_MOTION_MASK);
		gtk_widget_set_no_show_all(GTK_WIDGET(self),TRUE);
	
#line 431 "gmpc-metaimage.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_property"
{
	GmpcMetaImage *self G_GNUC_UNUSED;

	self = GMPC_METAIMAGE (object);

	switch (property_id) {
	case PROP_LOADING_COVER_ICON:
		{
#line 55 "gmpc-metaimage.gob"
{ char *old = self->loading_cover_icon; self->loading_cover_icon = g_value_dup_string (VAL); g_free (old); }
#line 452 "gmpc-metaimage.c"
		}
		break;
	case PROP_NO_COVER_ICON:
		{
#line 64 "gmpc-metaimage.gob"
{ char *old = self->no_cover_icon; self->no_cover_icon = g_value_dup_string (VAL); g_free (old); }
#line 459 "gmpc-metaimage.c"
		}
		break;
	case PROP_IMAGE_TYPE:
		{
#line 70 "gmpc-metaimage.gob"
self->image_type = g_value_get_int (VAL);
#line 466 "gmpc-metaimage.c"
		}
		break;
	case PROP_SIZE:
		{
#line 77 "gmpc-metaimage.gob"
self->size = g_value_get_int (VAL);
#line 473 "gmpc-metaimage.c"
		}
		break;
	case PROP_HIDE_ON_NA:
		{
#line 84 "gmpc-metaimage.gob"
self->hide_on_na = g_value_get_boolean (VAL);
#line 480 "gmpc-metaimage.c"
		}
		break;
	case PROP_CONNECTION:
		{
#line 90 "gmpc-metaimage.gob"
self->connection = g_value_get_pointer (VAL);
#line 487 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_BORDER:
		{
#line 96 "gmpc-metaimage.gob"
self->draw_border = g_value_get_boolean (VAL);
#line 494 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_SHADOW:
		{
#line 102 "gmpc-metaimage.gob"
self->draw_shadow = g_value_get_boolean (VAL);
#line 501 "gmpc-metaimage.c"
		}
		break;
	case PROP_SQUARED:
		{
#line 108 "gmpc-metaimage.gob"
self->squared = g_value_get_boolean (VAL);
#line 508 "gmpc-metaimage.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_property"
{
	GmpcMetaImage *self G_GNUC_UNUSED;

	self = GMPC_METAIMAGE (object);

	switch (property_id) {
	case PROP_LOADING_COVER_ICON:
		{
#line 55 "gmpc-metaimage.gob"
g_value_set_string (VAL, self->loading_cover_icon);
#line 539 "gmpc-metaimage.c"
		}
		break;
	case PROP_NO_COVER_ICON:
		{
#line 64 "gmpc-metaimage.gob"
g_value_set_string (VAL, self->no_cover_icon);
#line 546 "gmpc-metaimage.c"
		}
		break;
	case PROP_IMAGE_TYPE:
		{
#line 70 "gmpc-metaimage.gob"
g_value_set_int (VAL, self->image_type);
#line 553 "gmpc-metaimage.c"
		}
		break;
	case PROP_SIZE:
		{
#line 77 "gmpc-metaimage.gob"
g_value_set_int (VAL, self->size);
#line 560 "gmpc-metaimage.c"
		}
		break;
	case PROP_HIDE_ON_NA:
		{
#line 84 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->hide_on_na);
#line 567 "gmpc-metaimage.c"
		}
		break;
	case PROP_CONNECTION:
		{
#line 90 "gmpc-metaimage.gob"
g_value_set_pointer (VAL, self->connection);
#line 574 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_BORDER:
		{
#line 96 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->draw_border);
#line 581 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_SHADOW:
		{
#line 102 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->draw_shadow);
#line 588 "gmpc-metaimage.c"
		}
		break;
	case PROP_SQUARED:
		{
#line 108 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->squared);
#line 595 "gmpc-metaimage.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 55 "gmpc-metaimage.gob"
gchar * 
gmpc_metaimage_get_loading_cover_icon (GmpcMetaImage * self)
#line 614 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_loading_cover_icon"
{
#line 55 "gmpc-metaimage.gob"
		gchar* val; g_object_get (G_OBJECT (self), "loading_cover_icon", &val, NULL); return val;
}}
#line 621 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 55 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_loading_cover_icon (GmpcMetaImage * self, gchar * val)
#line 627 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_loading_cover_icon"
{
#line 55 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "loading_cover_icon", val, NULL);
}}
#line 634 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 64 "gmpc-metaimage.gob"
gchar * 
gmpc_metaimage_get_no_cover_icon (GmpcMetaImage * self)
#line 640 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_no_cover_icon"
{
#line 64 "gmpc-metaimage.gob"
		gchar* val; g_object_get (G_OBJECT (self), "no_cover_icon", &val, NULL); return val;
}}
#line 647 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 64 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_no_cover_icon (GmpcMetaImage * self, gchar * val)
#line 653 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_no_cover_icon"
{
#line 64 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "no_cover_icon", val, NULL);
}}
#line 660 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 70 "gmpc-metaimage.gob"
gint 
gmpc_metaimage_get_image_type (GmpcMetaImage * self)
#line 666 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_image_type"
{
#line 70 "gmpc-metaimage.gob"
		gint val; g_object_get (G_OBJECT (self), "image_type", &val, NULL); return val;
}}
#line 673 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 70 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_image_type (GmpcMetaImage * self, gint val)
#line 679 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_image_type"
{
#line 70 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "image_type", val, NULL);
}}
#line 686 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 77 "gmpc-metaimage.gob"
gint 
gmpc_metaimage_get_size (GmpcMetaImage * self)
#line 692 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_size"
{
#line 77 "gmpc-metaimage.gob"
		gint val; g_object_get (G_OBJECT (self), "size", &val, NULL); return val;
}}
#line 699 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 77 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_size (GmpcMetaImage * self, gint val)
#line 705 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_size"
{
#line 77 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "size", val, NULL);
}}
#line 712 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 84 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_hide_on_na (GmpcMetaImage * self)
#line 718 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_hide_on_na"
{
#line 84 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "hide_on_na", &val, NULL); return val;
}}
#line 725 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 84 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_hide_on_na (GmpcMetaImage * self, gboolean val)
#line 731 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_hide_on_na"
{
#line 84 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "hide_on_na", val, NULL);
}}
#line 738 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 90 "gmpc-metaimage.gob"
gpointer 
gmpc_metaimage_get_connection (GmpcMetaImage * self)
#line 744 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_connection"
{
#line 90 "gmpc-metaimage.gob"
		gpointer val; g_object_get (G_OBJECT (self), "connection", &val, NULL); return val;
}}
#line 751 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 90 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_connection (GmpcMetaImage * self, gpointer val)
#line 757 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_connection"
{
#line 90 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "connection", val, NULL);
}}
#line 764 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 96 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_draw_border (GmpcMetaImage * self)
#line 770 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_draw_border"
{
#line 96 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "draw_border", &val, NULL); return val;
}}
#line 777 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 96 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_draw_border (GmpcMetaImage * self, gboolean val)
#line 783 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_draw_border"
{
#line 96 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "draw_border", val, NULL);
}}
#line 790 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 102 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_draw_shadow (GmpcMetaImage * self)
#line 796 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_draw_shadow"
{
#line 102 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "draw_shadow", &val, NULL); return val;
}}
#line 803 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 102 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_draw_shadow (GmpcMetaImage * self, gboolean val)
#line 809 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_draw_shadow"
{
#line 102 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "draw_shadow", val, NULL);
}}
#line 816 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 108 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_squared (GmpcMetaImage * self)
#line 822 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_squared"
{
#line 108 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "squared", &val, NULL); return val;
}}
#line 829 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 108 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_squared (GmpcMetaImage * self, gboolean val)
#line 835 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_squared"
{
#line 108 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "squared", val, NULL);
}}
#line 842 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__


#line 137 "gmpc-metaimage.gob"
static void 
gmpc_metaimage_popup_destroy (GmpcMetaImage * self)
#line 849 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::popup_destroy"
#line 137 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 137 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 856 "gmpc-metaimage.c"
{
#line 140 "gmpc-metaimage.gob"
	
		if(self->_priv->popup_win)
		{
			gtk_widget_destroy(self->_priv->popup_win);
			self->_priv->popup_win = NULL;
		}
	}}
#line 866 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 148 "gmpc-metaimage.gob"
static void 
gmpc_metaimage_popup_position (GmpcMetaImage * self)
#line 872 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::popup_position"
#line 148 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 148 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 879 "gmpc-metaimage.c"
{
#line 151 "gmpc-metaimage.gob"
	
		int x,y,xm,ym;
		GdkRectangle rect;
		int monitor;
		gdk_window_get_position(gtk_widget_get_toplevel(GTK_WIDGET(self))->window, &x,&y);
		gdk_window_get_pointer(gtk_widget_get_toplevel(GTK_WIDGET(self))->window, &xm,&ym,NULL);
		monitor = gdk_screen_get_monitor_at_point(gtk_window_get_screen(GTK_WINDOW(self->_priv->popup_win)),x+xm,y+ym);
		gdk_screen_get_monitor_geometry(gtk_window_get_screen(GTK_WINDOW(self->_priv->popup_win)),monitor, &rect);
		/* if it falls of the monitor, reposition */
		if((rect.y +y+ym+self->_priv->popup_h+MOUSE_DISTANCE) > (rect.height+rect.y))	{
			y-= self->_priv->popup_h+2*MOUSE_DISTANCE;
		}
		if((x+xm+self->_priv->popup_w+MOUSE_DISTANCE) > (rect.width+rect.x)) {
			x-= self->_priv->popup_w+2*MOUSE_DISTANCE;
		}
		gtk_window_move(GTK_WINDOW(self->_priv->popup_win),x+xm+MOUSE_DISTANCE,y+ym+MOUSE_DISTANCE);



	}}
#line 902 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 171 "gmpc-metaimage.gob"
static gboolean 
gmpc_metaimage_popup_event (GmpcMetaImage * self)
#line 908 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::popup_event"
#line 171 "gmpc-metaimage.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 171 "gmpc-metaimage.gob"
	g_return_val_if_fail (GMPC_IS_METAIMAGE (self), (gboolean )0);
#line 915 "gmpc-metaimage.c"
{
#line 174 "gmpc-metaimage.gob"
	
		self->_priv->popup_timer_id = 0;
		if(self->_priv->image_url && self->size < 250 )
		{
			self->_priv->popup_win = gtk_window_new(GTK_WINDOW_POPUP);
			GtkWidget *image = gtk_image_new();
			GdkPixbuf *pb = gdk_pixbuf_new_from_file_at_scale(self->_priv->image_url, 250,250, TRUE, NULL);
			self->_priv->popup_h = gdk_pixbuf_get_height(pb);
			self->_priv->popup_w = gdk_pixbuf_get_width(pb);
			if(self->draw_border)
				screenshot_add_border(&pb);	
			gtk_container_add(GTK_CONTAINER(self->_priv->popup_win), image);
			gtk_image_set_from_pixbuf(GTK_IMAGE(image), pb);
			/* position the thing */
			self_popup_position(self);
			gtk_widget_show_all(self->_priv->popup_win);
			g_object_unref(pb);
		}
		return FALSE;
	}}
#line 938 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 195 "gmpc-metaimage.gob"
static gboolean 
gmpc_metaimage_motion_notify_event (GmpcMetaImage * self, GdkEventMotion * event, gpointer data)
#line 944 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::motion_notify_event"
#line 195 "gmpc-metaimage.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 195 "gmpc-metaimage.gob"
	g_return_val_if_fail (GMPC_IS_METAIMAGE (self), (gboolean )0);
#line 951 "gmpc-metaimage.c"
{
#line 198 "gmpc-metaimage.gob"
	
		if(self->_priv->popup_win)
		{
			self_popup_position(self);
		}

		return TRUE;
	}}
#line 962 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 207 "gmpc-metaimage.gob"
static gboolean 
gmpc_metaimage_leave_notify_event (GmpcMetaImage * self, GdkEventCrossing * event, gpointer data)
#line 968 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::leave_notify_event"
#line 207 "gmpc-metaimage.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 207 "gmpc-metaimage.gob"
	g_return_val_if_fail (GMPC_IS_METAIMAGE (self), (gboolean )0);
#line 975 "gmpc-metaimage.c"
{
#line 211 "gmpc-metaimage.gob"
	
			if(self->_priv->popup_timer_id)
				g_source_remove(self->_priv->popup_timer_id);
			self->_priv->popup_timer_id = 0;
			self_popup_destroy(self);
			return FALSE;
		}}
#line 985 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 219 "gmpc-metaimage.gob"
static gboolean 
gmpc_metaimage_enter_notify_event (GmpcMetaImage * self, GdkEventCrossing * event, gpointer data)
#line 991 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::enter_notify_event"
#line 219 "gmpc-metaimage.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 219 "gmpc-metaimage.gob"
	g_return_val_if_fail (GMPC_IS_METAIMAGE (self), (gboolean )0);
#line 998 "gmpc-metaimage.c"
{
#line 222 "gmpc-metaimage.gob"
	
			if(self->_priv->popup_timer_id == 0)
			{
				self->_priv->popup_timer_id = g_timeout_add(1000, (GSourceFunc) self_popup_event, self);
			}
			return FALSE;
		}}
#line 1008 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 230 "gmpc-metaimage.gob"
static void 
___1a_gmpc_metaimage_finalize (GObject * obj G_GNUC_UNUSED)
#line 1014 "gmpc-metaimage.c"
#define PARENT_HANDLER(___obj) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___obj); }
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::finalize"
{
#line 233 "gmpc-metaimage.gob"
	
		PARENT_HANDLER(obj);
	}}
#line 1025 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 237 "gmpc-metaimage.gob"
static void 
___1b_gmpc_metaimage_dispose (GObject * obj G_GNUC_UNUSED)
#line 1032 "gmpc-metaimage.c"
#define PARENT_HANDLER(___obj) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___obj); }
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::dispose"
{
#line 240 "gmpc-metaimage.gob"
	
			Self *self = GMPC_METAIMAGE(obj); 
			if(self->_priv->meta_id)
			{
				g_signal_handler_disconnect(G_OBJECT(gmw),self->_priv->meta_id);
				self->_priv->meta_id =  0;
			}
			if(self->_priv->popup_timer_id)
			{
				g_source_remove(self->_priv->popup_timer_id);
				self->_priv->popup_timer_id=0;
			}
			if(self->_priv->image_url) {
				q_free(self->_priv->image_url);
			}
			self_popup_destroy(self);
			if(self->_priv->status_signal){
				g_signal_handler_disconnect(G_OBJECT(gmpcconn), self->_priv->status_signal);
				self->_priv->status_signal =0;
			}
			if(self->_priv->connect_signal){
				g_signal_handler_disconnect(G_OBJECT(gmpcconn), self->_priv->connect_signal);
				self->_priv->connect_signal=0;
			}
			PARENT_HANDLER(obj);
		}}
#line 1066 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 267 "gmpc-metaimage.gob"
GtkWidget * 
gmpc_metaimage_new (int type)
#line 1073 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::new"
{
#line 269 "gmpc-metaimage.gob"
	
			Self *gmi =  GET_NEW;
			gmi->image_type = type;
			return (GtkWidget *)gmi;
		}}
#line 1083 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 275 "gmpc-metaimage.gob"
void 
gmpc_metaimage_update_cover (GmpcMetaImage * self, MpdObj * mi, ChangedStatusType what, GmpcConnection * gmpcconn)
#line 1089 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::update_cover"
#line 275 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 275 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1096 "gmpc-metaimage.c"
{
#line 278 "gmpc-metaimage.gob"
	
			if(self->connection && what&(MPD_CST_STATE) && self->is_visible)
			{
				int state = mpd_player_get_state(mi);
				if(state == MPD_PLAYER_STOP || state == MPD_PLAYER_UNKNOWN)
				{
					self_set_cover_na(self);
				}
				else {
					mpd_Song *song = mpd_playlist_get_current_song(mi);
					if(song)
					{
						self_update_cover_from_song(self, song);
					}
					else
					{
						self_set_cover_na(self);
					}
				}

			}
			else if(self->connection && what&(MPD_CST_SONGID|MPD_CST_SONGPOS|MPD_CST_PLAYLIST) && self->is_visible)
			{
				mpd_Song *song = mpd_playlist_get_current_song(mi);
				if(!song)
				{
					self_set_cover_na(self);
				}
				else
				{
					self_update_cover_from_song(self, song);
				}
			}

		}}
#line 1134 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 313 "gmpc-metaimage.gob"
void 
gmpc_metaimage_connection_changed (GmpcMetaImage * self, MpdObj * mi, int connect, GmpcConnection * gmpconn)
#line 1140 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::connection_changed"
#line 313 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 313 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1147 "gmpc-metaimage.c"
{
#line 316 "gmpc-metaimage.gob"
	
			if(!connect)
			{
				self_set_cover_na(self);
			}

		}}
#line 1157 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 324 "gmpc-metaimage.gob"
void 
gmpc_metaimage_update_cover_from_song (GmpcMetaImage * self, mpd_Song * song)
#line 1163 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::update_cover_from_song"
#line 324 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 324 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1170 "gmpc-metaimage.c"
{
#line 327 "gmpc-metaimage.gob"
	
			gchar *path=  NULL;
			MetaDataResult ret;


			if(self->_priv->song)
				mpd_freeSong(self->_priv->song);

			if(!song)
			{
				self_set_cover_na(self);
				return;
			}
			if(self->_priv->status_signal)
				self->_priv->song = mpd_songDup(song);

			ret = gmpc_meta_watcher_get_meta_path(gmw,song, self->image_type, &path);
			if(ret == META_DATA_FETCHING)
			{
				self_set_cover_fetching(self);
			}else if (ret == META_DATA_AVAILABLE) {
					self_set_cover_from_path(self,path); 
			} else {
				self_set_cover_na(self);
			}
			if(path)
			{
				q_free(path);
			}
		}}
#line 1203 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 358 "gmpc-metaimage.gob"
static void 
gmpc_metaimage_meta_callback (GmpcMetaWatcher * gmv, mpd_Song * song, MetaDataType type, MetaDataResult ret, char * path, gpointer data)
#line 1209 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::meta_callback"
{
#line 361 "gmpc-metaimage.gob"
	
			Self *self = data;
			if(!song || !self || !self->_priv || !self->_priv->song)
				return;

			
			/**
			 * Check for fields
			 */
			if(self->image_type != type)
				return;

			if(!gmpc_meta_watcher_match_data(self->image_type, self->_priv->song, song))
			{
				return;
			}

			/**
			 * If mpd is stopped before the result is back, set the cover to na, and ignore the result
			 */
			if(self->connection && mpd_player_get_state(self->connection) == MPD_PLAYER_STOP)
			{
				self_set_cover_na(self);
			}
			else
			{
				if(ret == META_DATA_AVAILABLE) {
					self_set_cover_from_path(self,path); 
				} else if (ret == META_DATA_FETCHING) {
					self_set_cover_fetching(self);
				} else {
					self_set_cover_na(self);
				}
			}
		}}
#line 1249 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 398 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_cover_na (GmpcMetaImage * self)
#line 1255 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_cover_na"
#line 398 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 398 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1262 "gmpc-metaimage.c"
{
#line 401 "gmpc-metaimage.gob"
	
			GdkPixbuf *pb2; 
			if(self->_priv->image_url)
			{
				q_free(self->_priv->image_url);
				self->_priv->image_url = NULL;
			}
			self_popup_destroy(self);
			if(self->hide_on_na)
			{		
				gtk_widget_hide(GTK_WIDGET(self));
				return;
			}
        GError *err = NULL;
			  pb2 = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), self->no_cover_icon, self->size, 0,&err);
			  if(!pb2)
				  printf("uh owh %s\n", err->message);
			  gtk_image_set_from_pixbuf(GTK_IMAGE(self->_priv->image), pb2);
			  gtk_widget_set_size_request(GTK_WIDGET(self), self->size, self->size);
			  g_object_unref(pb2);
			  self_image_changed(self,META_DATA_UNAVAILABLE);
		}}
#line 1287 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 423 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_cover_fetching (GmpcMetaImage * self)
#line 1293 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_cover_fetching"
#line 423 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 423 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1300 "gmpc-metaimage.c"
{
#line 426 "gmpc-metaimage.gob"
	
			GdkPixbuf *pb2; 
			if(self->_priv->image_url)
			{
				q_free(self->_priv->image_url);
				self->_priv->image_url = NULL;
			}
			self_popup_destroy(self);
			if(self->hide_on_na)
			{		
				gtk_widget_hide(GTK_WIDGET(self));
			}
			  pb2 = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), self->loading_cover_icon, self->size, 0,NULL);
        
			gtk_image_set_from_pixbuf(GTK_IMAGE(self->_priv->image), pb2);
			if(self->squared)
				gtk_widget_set_size_request(GTK_WIDGET(self), self->size, self->size);
			g_object_unref(pb2);
			self_image_changed(self,META_DATA_FETCHING);
		}}
#line 1323 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 447 "gmpc-metaimage.gob"
void 
gmpc_metaimage_image_changed (GmpcMetaImage * self, int type)
#line 1329 "gmpc-metaimage.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 447 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 447 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1341 "gmpc-metaimage.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_INT);
	g_value_set_int (&___param_values[1], (gint ) type);

	g_signal_emitv (___param_values,
		object_signals[IMAGE_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 447 "gmpc-metaimage.gob"
static void 
___real_gmpc_metaimage_image_changed (GmpcMetaImage * self G_GNUC_UNUSED, int type)
#line 1362 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::image_changed"
{
#line 450 "gmpc-metaimage.gob"
	
			/* do nothing */
		}}
#line 1370 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 454 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_cover_from_path (GmpcMetaImage * self, gchar * path)
#line 1376 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_cover_from_path"
#line 454 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 454 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1383 "gmpc-metaimage.c"
{
#line 457 "gmpc-metaimage.gob"
	
			GdkPixbuf *pb = NULL;
			pb = gdk_pixbuf_new_from_file_at_scale(path,self->size-self->draw_shadow*10-2,self->size-self->draw_shadow*10-2,TRUE,NULL);
			if(self->_priv->image_url)
			{
				q_free(self->_priv->image_url);
				self->_priv->image_url = NULL;
			}
			self_popup_destroy(self);

			if(pb)
			{
				int width = 0; 
				int height = 0;
				/* save url */
				self->_priv->image_url = g_strdup(path); 

				if(self->draw_border)
					screenshot_add_border(&pb);	
				if(self->draw_shadow)
					screenshot_add_shadow(&pb);
				/** 
				 * Need to get pixbuf height/width before adding to image
				 * if added to image, somehow the returned values don't match anymore
				 */
				width = gdk_pixbuf_get_width(pb);			
				height = gdk_pixbuf_get_height(pb);
				gtk_image_set_from_pixbuf(GTK_IMAGE(self->_priv->image),pb);
				/**
				 * Set sizing, also set size on non-squared, so the widget resizes propperly
				 */
				if(self->squared)
				{
					gtk_widget_set_size_request(GTK_WIDGET(self), self->size, self->size);
				}
				else
				{
					gtk_widget_set_size_request(GTK_WIDGET(self), width+2, height+2);
				}
				g_object_unref(pb);
			}
			if(self->is_visible)
			{
				gtk_widget_show(GTK_WIDGET(self));
			}
			self_image_changed(self,META_DATA_AVAILABLE);
		}}
#line 1433 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 505 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_is_visible (GmpcMetaImage * self, gboolean is_visible)
#line 1439 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_is_visible"
#line 505 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 505 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1446 "gmpc-metaimage.c"
{
#line 508 "gmpc-metaimage.gob"
	
			self->is_visible = is_visible;
			if(self->is_visible)
			{
				if(self->connection)
				{
					self_update_cover(self,self->connection, MPD_CST_STATE, NULL);
				}

			} 
			else
			{
				gtk_widget_hide(GTK_WIDGET(self));
			}
		}}
#line 1464 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 523 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_is_visible (GmpcMetaImage * self)
#line 1470 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_is_visible"
#line 523 "gmpc-metaimage.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 523 "gmpc-metaimage.gob"
	g_return_val_if_fail (GMPC_IS_METAIMAGE (self), (gboolean )0);
#line 1477 "gmpc-metaimage.c"
{
#line 525 "gmpc-metaimage.gob"
	
			return self->is_visible;
		}}
#line 1483 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 528 "gmpc-metaimage.gob"
void 
gmpc_metaimage_query_refetch (GmpcMetaImage * self)
#line 1489 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::query_refetch"
#line 528 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 528 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1496 "gmpc-metaimage.c"
{
#line 531 "gmpc-metaimage.gob"
	
		if(self->_priv->song)
		{
			gchar *path = NULL;
			MetaDataResult ret;

			ret = gmpc_meta_watcher_get_meta_path(gmw,self->_priv->song, self->image_type|META_QUERY_NO_CACHE, &path);
			if(ret == META_DATA_FETCHING)
			{
				self_set_cover_fetching(self);
			}else if (ret == META_DATA_AVAILABLE) {
					self_set_cover_from_path(self,path); 
			} else {
				self_set_cover_na(self);
			}
			if(path)
			{
				q_free(path);
			}
		}
	}}
#line 1520 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 554 "gmpc-metaimage.gob"
static gboolean 
gmpc_metaimage_menu_populate_callback (GmpcMetaImage * self, GdkEventButton * event, gpointer data)
#line 1526 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::menu_populate_callback"
#line 554 "gmpc-metaimage.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 554 "gmpc-metaimage.gob"
	g_return_val_if_fail (GMPC_IS_METAIMAGE (self), (gboolean )0);
#line 1533 "gmpc-metaimage.c"
{
#line 557 "gmpc-metaimage.gob"
	
		if(self->_priv->song && event->button == 3)
		{
			GtkWidget *menu = gtk_menu_new();
			GtkWidget *item = NULL; 

			item = gtk_image_menu_item_new_with_label(_("Refetch"));
			gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item), gtk_image_new_from_stock(GTK_STOCK_REFRESH, GTK_ICON_SIZE_MENU));
			g_signal_connect_swapped(G_OBJECT(item), "activate", G_CALLBACK(self_query_refetch),self);
			gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);

			item = gtk_image_menu_item_new_with_label(_("Select file"));
			gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item), gtk_image_new_from_stock(GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU));
			g_signal_connect_swapped(G_OBJECT(item), "activate", G_CALLBACK(self_select_file),self);
			gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);

			item = gtk_image_menu_item_new_from_stock(GTK_STOCK_CLEAR, NULL);
			g_signal_connect_swapped(G_OBJECT(item), "activate", G_CALLBACK(self_clear_entry),self);
			gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);

			gtk_widget_show_all(menu);
			gtk_menu_popup(GTK_MENU(menu), NULL, NULL,NULL, NULL, event->button, event->time);
			return TRUE;
		}
		return FALSE;
	}}
#line 1562 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 585 "gmpc-metaimage.gob"
void 
gmpc_metaimage_clear_entry (GmpcMetaImage * self)
#line 1568 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::clear_entry"
#line 585 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 585 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1575 "gmpc-metaimage.c"
{
#line 588 "gmpc-metaimage.gob"
	
		meta_data_set_cache(self->_priv->song,self->image_type, META_DATA_UNAVAILABLE, NULL); 
		gmpc_meta_watcher_data_changed(gmw, self->_priv->song, self->image_type, META_DATA_UNAVAILABLE, NULL);
	}}
#line 1582 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 592 "gmpc-metaimage.gob"
void 
gmpc_metaimage_select_file (GmpcMetaImage * self)
#line 1588 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::select_file"
#line 592 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 592 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1595 "gmpc-metaimage.c"
{
#line 595 "gmpc-metaimage.gob"
	
		mpd_Song *song = mpd_songDup(self->_priv->song);
		MetaDataType type = self->image_type;
		GtkFileFilter *gff = gtk_file_filter_new();
		GtkWidget *fcd = gtk_file_chooser_dialog_new(_("Select File"),NULL,
					 GTK_FILE_CHOOSER_ACTION_OPEN,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);
		gtk_file_filter_set_name(gff, _("Images"));
		gtk_file_filter_add_pixbuf_formats(gff);
		gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(fcd), gff);   

		gff = gtk_file_filter_new();
		gtk_file_filter_set_name(gff, _("All"));
		gtk_file_filter_add_pattern(gff, "*");
		gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(fcd), gff);   

		gtk_widget_show_all(fcd);
		switch(gtk_dialog_run(GTK_DIALOG(fcd)))
		{
			case GTK_RESPONSE_ACCEPT:
				{	
		
					gchar *filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fcd));

					meta_data_set_cache(song,type, META_DATA_AVAILABLE, filename); 
					gmpc_meta_watcher_data_changed(gmw, song, type, META_DATA_AVAILABLE, filename);

					g_free(filename);
				}
			default:
				break;
		} 
		gtk_widget_destroy(fcd);
		mpd_freeSong(song);
	}}
#line 1635 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__
