/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "config.h"
#include "dtriggers.h"
#include "window.h"
#include "settings.h"
#include "gtkgmotriggers.h"

#ifdef __TRIGGERS__

GList *triggers = NULL;

/* from the dtriggersiface.c */
extern GtkWidget *tnotebook;
extern GtkWidget *tmatchtype;
extern GtkWidget *tmatchtype_menu;
extern GtkWidget *tmatchpattern;
extern GtkWidget *tmatchcase;
extern GtkObject *tmatchchance_adj;
extern GtkWidget *tmatchchance;
extern GtkWidget *tmatchmovedown;
extern GtkWidget *tnormfgcol;
extern GtkWidget *tnormfgcol_menu;
extern GtkWidget *tnormfgcols;
extern GtkWidget *tnormbgcols;
extern GtkWidget *tnormbarcols;
extern GtkWidget *tnormbar;
extern GtkWidget *tnormbg;
extern GtkWidget *tnormfg;
extern GtkWidget *tnormbold;
extern GtkWidget *tnormunderline;
extern GtkWidget *tnormbgcol;
extern GtkWidget *tnormbgcol_menu;
extern GtkWidget *tclist;
extern GtkWidget *table7;
extern GtkWidget *tup;
extern GtkWidget *tadd;
extern GtkWidget *trem;
extern GtkWidget *tdown;
extern GtkWidget *tname;
extern GtkWidget *tenabled;
extern GtkWidget *tnormbarcol;
extern GtkWidget *tnormbarcol_menu;
extern GtkWidget *table6;
extern GtkWidget *thoovfgcols;
extern GtkWidget *thoovbgcols;
extern GtkWidget *thoovbg;
extern GtkWidget *thoovfg;
extern GtkWidget *thoovbold;
extern GtkWidget *thoovunderline;
extern GtkWidget *thoovfgcol;
extern GtkWidget *thoovfgcol_menu;
extern GtkWidget *thoovbgcol;
extern GtkWidget *thoovbgcol_menu;
extern GtkWidget *thoovscrolled;
extern GtkWidget *thoovertable;
extern GtkWidget *thoovmore;
extern GtkWidget *thoovless;
extern GtkWidget *ttriggertext;
extern GtkWidget *ttriggertexttext;
extern GtkWidget *ttriggerscript;
extern GtkWidget *ttriggerscript_script;
extern GtkWidget *table5;
extern GtkWidget *tsoundplayfile;
extern GtkWidget *tsoundbeep;
extern GtkWidget *tsoundplaybrowse;
extern GtkWidget *tsoundplay;
extern GtkWidget *texample;
extern GtkWidget *tok;
extern GtkWidget *tapply;
extern GtkWidget *tclose;
extern GtkWidget *thelp;

extern GtkWidget* create_triggers_dialog();

GtkWidget *dtriggers = NULL;
int    selected_row = -1;
GList *trigger_datas;
GList *deleted_triggers;	// glist of 1 refcount GtkGmoTrigger stuff

/* values content desc:
 * old && new -> changed
 * old &&!new -> same
 *!old && new -> new trigger added
 *!old &&!new -> I screwed up :(
 */
typedef struct _trigger_data trigger_data;
struct _trigger_data {
    GtkGmoTrigger *old;
    GtkGmoTrigger *new;
};

void set_values_from_trigger(GtkGmoTrigger *t);
void free_trigger_data_old(trigger_data *td);
void free_trigger_data_new(trigger_data *td);
    
GtkGmoTrigger *get_current_trigger(int n) {
    GList *l = g_list_nth(trigger_datas, n);
    trigger_data *td;
    if(!l || !l->data)
	printf("MAJOR ERROR: Tried to access nonexistent trigger %d\n", n);
    td = l->data;
    return td->new ? td->new : td->old;
}

void t_changed() {
    gtk_widget_set_sensitive(tok, TRUE);
    gtk_widget_set_sensitive(tapply, TRUE);
}

void t_add() {
    trigger_data *td = g_malloc(sizeof(trigger_data));
    char *text[1];
    int row;
    
    printf("Adding new trigger\n");
    td->old = NULL;
    td->new = gtk_gmo_trigger_new();
    trigger_datas = g_list_append(trigger_datas, td);
    gtk_gmo_trigger_ref(td->new);
    text[0] = td->new->name;
    row = gtk_clist_append(GTK_CLIST(tclist), text);
    gtk_clist_set_row_data(GTK_CLIST(tclist), row, td);
    gtk_clist_select_row(GTK_CLIST(tclist), row, 0);
    t_changed();
}

void t_remove() {
#warning jaja, this code sigseves - cause prob somewhere else
    trigger_data *td;
    printf("removeing current row (%d)\n", selected_row);
    if(selected_row < 0)
	return;
    td = ((GtkCListRow *)g_list_nth(GTK_CLIST(tclist)->row_list, selected_row))->data;
    trigger_datas = g_list_remove(trigger_datas, td);
    if(td->old) {
	deleted_triggers = g_list_append(deleted_triggers, td->old);
	gtk_gmo_trigger_unref(td->old);
    }
    if(td->new) {
	gtk_gmo_trigger_unref(td->new);
	gtk_gmo_trigger_unref(td->new);
    }
    g_free(td);
    t_changed();
}

void t_up() {
    trigger_data *td;
    int row = selected_row; /* selected row might change ... */
    printf("Moveing trigger up\n");
    td = g_list_nth_data(trigger_datas, row);
    trigger_datas = g_list_remove(trigger_datas, td);
    trigger_datas = g_list_insert(trigger_datas, td, row-1);
    gtk_clist_swap_rows(GTK_CLIST(tclist), row, row-1);
    gtk_clist_select_row(GTK_CLIST(tclist), row-1, 0);
    t_changed();
}
void t_down() {
    trigger_data *td;
    int row = selected_row; /* selected row might change ... */
    printf("Moveing trigger down\n");
    td = g_list_nth_data(trigger_datas, row);
    trigger_datas = g_list_remove(trigger_datas, td);
    trigger_datas = g_list_insert(trigger_datas, td, row+1);
    gtk_clist_swap_rows(GTK_CLIST(tclist), row, row+1);
    gtk_clist_select_row(GTK_CLIST(tclist), row+1, 0);
    t_changed();
}

void t_apply() {
    GList *l;
    trigger_data *td;
    GtkGmoTrigger *t;

    g_list_free(triggers);
    triggers = NULL; /* release current list */

    /* Detect changes */
    for(l = trigger_datas; l; l = g_list_next(l)) {
	td = l->data;
	if(td->new) {
	    if(td->old) { /* It changed */
		gtk_gmo_trigger_emit_change(td->old, td->new);
		gtk_gmo_trigger_unref(td->old);
		deleted_triggers = g_list_append(deleted_triggers, td->old);
	    } else {
		printf("TODO: Find a way to emit _new_ events\n");
	    }
	    td->old = td->new;
	    td->new = NULL;
	}
	triggers = g_list_append(triggers, td->old);
    }
    /* Notify deletes */
    for(l = deleted_triggers; l; l = g_list_next(l)) {
	t = l->data;
	gtk_gmo_trigger_emit_delete(t);
	gtk_gmo_trigger_unref(t);
    }
    g_list_free(deleted_triggers);
    deleted_triggers = NULL;

    /* And update the inteface ... */
    gtk_widget_set_sensitive(tok, FALSE);
    gtk_widget_set_sensitive(tapply, FALSE);
}

void t_close() {
    gtk_widget_destroy(dtriggers);
}
void t_ok() {
    t_apply();
    t_close();
}


void t_trigger_selected(GtkCList *clist, int row, int column, GdkEvent *event) {
    GtkGmoTrigger *t = get_current_trigger(row);
    selected_row = row;

    printf("Selected trigger %d: %s\n", row, t->name);
    set_values_from_trigger(t);

    gtk_widget_set_sensitive(tname, TRUE);
    gtk_widget_set_sensitive(tenabled, TRUE);
    gtk_widget_set_sensitive(tnotebook, GTK_TOGGLE_BUTTON(tenabled)->active);

    gtk_widget_set_sensitive(trem, TRUE);
    gtk_widget_set_sensitive(tup, row);
    gtk_widget_set_sensitive(tdown, row != clist->rows-1);
}
void t_trigger_unselected(GtkCList *clist, int row, int column, GdkEvent *event) {
    GtkGmoTrigger *t = get_current_trigger(row);
    selected_row = -1;

    printf("Unselected trigger %d: %s\n", row, t->name);
    
    gtk_widget_set_sensitive(tname, FALSE);
    gtk_widget_set_sensitive(tenabled, FALSE);
    gtk_widget_set_sensitive(tnotebook, FALSE);
    
    gtk_widget_set_sensitive(trem, FALSE);
    gtk_widget_set_sensitive(tup, FALSE);
    gtk_widget_set_sensitive(tdown, FALSE);
}


void load_triggers_in_trigger_datas() {
    GList *l;
    trigger_data *td;
    char *text[1];
    int row;
    for(l = triggers; l; l = g_list_next(l)) {
	td = g_malloc(sizeof(trigger_data));
	td->old = (GtkGmoTrigger *)l->data;
	td->new = NULL;
//	gtk_gmo_trigger_ref(td->old);
	trigger_datas = g_list_append(trigger_datas, td);

	/* and add to the clist */
	text[0] = td->old->name;
	row = gtk_clist_append(GTK_CLIST(tclist), text);
	gtk_clist_set_row_data(GTK_CLIST(tclist), row, td);
	if(debug) printf("Loaded trigger \"%s\" to dialog\n", td->old->name);
    }
}

void free_trigger_data_old(trigger_data *td) {
    if(td->old)
	gtk_gmo_trigger_unref(td->old);
    g_free(td);
}
void free_trigger_data_new(trigger_data *td) {
    if(td->new)
	gtk_gmo_trigger_unref(td->new);
    g_free(td);
}

void t_window_destroyed() {
    GList *l;
    GtkGmoTrigger *t;
    trigger_data *td;
    
    if(debug) printf("Triggers dialog has been destroyed\n");
    dtriggers = NULL;
    
    for(l = deleted_triggers; l; l = g_list_next(l)) {
	td = l->data;
	if(td->new)
	    gtk_gmo_trigger_unref(td->new);
	g_free(td);
    }
    g_list_free(trigger_datas);
    trigger_datas = NULL;

    for(l = deleted_triggers; l; l = g_list_next(l)) {
	t = l->data;
	gtk_gmo_trigger_emit_delete(t);
	gtk_gmo_trigger_unref(t);
    }
    g_list_free(deleted_triggers);
    deleted_triggers = NULL;

    selected_row = -1;
}

void set_custom_color_value(GtkWidget *button, gushort *values) {
    char s[10];
    snprintf(s, 9, "#%02x%02x%02x", values[0], values[1], values[2]);
    gtk_label_set_text(GTK_LABEL(GTK_BIN(button)->child), s);
}

void add_hoover_to_table(GtkGmoTriggerHoover *h, GtkTable *table) {
    printf("TODO: add_hoover_to_table()\n");
}

#define on_active_set_sensitive(but, wid) gtk_signal_connect(GTK_OBJECT(but), "toggled", GTK_SIGNAL_FUNC(do_on_active_set_sensitive), wid)
void do_on_active_set_sensitive(GtkToggleButton *b, GtkWidget *w) {
    gtk_widget_set_sensitive(w, b->active);
}
	
void set_values_from_trigger(GtkGmoTrigger *t) {
    /* General */
    gtk_entry_set_text(GTK_ENTRY(tname), t->name);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tenabled), !t->disabled);

    /* Matching */
    gtk_option_menu_set_history(GTK_OPTION_MENU(tmatchtype), t->type);
    gtk_entry_set_text(GTK_ENTRY(tmatchpattern), t->pattern);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmatchcase), t->case_sensitive);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(tmatchchance), t->chance);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmatchmovedown), t->more_matches);

    /* Normal color */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tnormfg), t->n_color_fg);
    gtk_option_menu_set_history(GTK_OPTION_MENU(tnormfgcol), t->n_fgcolor);
    set_custom_color_value(tnormfgcols, t->n_fgcolors);
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tnormbg), t->n_color_bg);
    gtk_option_menu_set_history(GTK_OPTION_MENU(tnormbgcol), t->n_bgcolor);
    set_custom_color_value(tnormbgcols, t->n_bgcolors);
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tnormbar), t->n_color_bar);
    gtk_option_menu_set_history(GTK_OPTION_MENU(tnormbarcol), t->n_barcolor);
    set_custom_color_value(tnormbarcols, t->n_barcolors);
    
    /* Hoover color */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(thoovfg), t->h_color_fg);
    gtk_option_menu_set_history(GTK_OPTION_MENU(thoovfgcol), t->h_fgcolor);
    set_custom_color_value(thoovfgcols, t->h_fgcolors);
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(thoovbg), t->h_color_bg);
    gtk_option_menu_set_history(GTK_OPTION_MENU(thoovbgcol), t->h_bgcolor);
    set_custom_color_value(thoovbgcols, t->h_bgcolors);
    
    /* Hoover actions */
    g_list_foreach(t->hoover_actions, (GFunc)add_hoover_to_table, thoovertable);

    /* trigger actions */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ttriggertext), t->send_text);
    gtk_text_insert(GTK_TEXT(ttriggertexttext), NULL, NULL, NULL, t->send_text_text, -1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ttriggerscript), t->run_script);
    gtk_entry_set_text(GTK_ENTRY(ttriggerscript_script), t->run_script_function);

    /* Sound */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tsoundbeep), t->beep);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tsoundplay), t->play_file);
    gtk_entry_set_text(GTK_ENTRY(tsoundplayfile), t->play_file_name);
}

void gm_dialog_triggers_open() {
    if(dtriggers)
	return;
	
    dtriggers = create_triggers_dialog();
    gtk_window_set_transient_for(GTK_WINDOW(dtriggers),
				 GTK_WINDOW(gm_window_get_window()));
    gtk_signal_connect_object(GTK_OBJECT(dtriggers), "delete_event",
			      GTK_SIGNAL_FUNC(gtk_widget_destroy),
			      GTK_OBJECT(dtriggers));
    gtk_signal_connect(GTK_OBJECT(dtriggers), "destroy",
		       GTK_SIGNAL_FUNC(t_window_destroyed), NULL);

    load_triggers_in_trigger_datas();
    
    gtk_signal_connect(GTK_OBJECT(tadd), "clicked", GTK_SIGNAL_FUNC(t_add), NULL);
    gtk_signal_connect(GTK_OBJECT(trem), "clicked", GTK_SIGNAL_FUNC(t_remove), NULL);
    gtk_signal_connect(GTK_OBJECT(tup), "clicked", GTK_SIGNAL_FUNC(t_up), NULL);
    gtk_signal_connect(GTK_OBJECT(tdown), "clicked", GTK_SIGNAL_FUNC(t_down), NULL);

    gtk_signal_connect(GTK_OBJECT(tok), "clicked", GTK_SIGNAL_FUNC(t_ok), NULL);
    gtk_signal_connect(GTK_OBJECT(tapply), "clicked", GTK_SIGNAL_FUNC(t_apply), NULL);
    gtk_signal_connect(GTK_OBJECT(tclose), "clicked", GTK_SIGNAL_FUNC(t_close), NULL);

    gtk_signal_connect(GTK_OBJECT(tclist), "select_row", GTK_SIGNAL_FUNC(t_trigger_selected), NULL);
    gtk_signal_connect(GTK_OBJECT(tclist), "unselect_row", GTK_SIGNAL_FUNC(t_trigger_unselected), NULL);

    on_active_set_sensitive(tenabled, tnotebook);

    if(trigger_datas)
	gtk_clist_select_row(GTK_CLIST(tclist), 0, 0);

    gtk_widget_show(dtriggers);
}

void gm_triggers_init() {
    FILE *f = fopen(gm_settings_get_trigger_file(), "r");
    GtkGmoTrigger *t;
    if(debug)
	printf("TRIGGERS: Opening %s\n", gm_settings_get_trigger_file());
    if(f) {
	while((t = gtk_gmo_trigger_load(f)))
	    triggers = g_list_append(triggers, t);
	fclose(f);
    }
}

void gm_triggers_store() {
    FILE *f = fopen(gm_settings_get_trigger_file(), "w");
    if(f) {
	g_list_foreach(triggers, (GFunc) gtk_gmo_trigger_save, f);
	fclose(f);
    } else if(debug) 
	printf("ERROR: Couldn't open trigger file: %s\n",
	       gm_settings_get_trigger_file());
}

#endif
