#include "support.h"
#include "wf.h"
#include "fft.h"
#include "scope.h"

static struct fft *wffft;
static gfloat wfwindow[WF_BLOCKLEN];
static gfloat wfbuffer[WF_BLOCKLEN];
static gint wfpointer = 0;

static inline double hamming(double x)
{
	return 0.54 - 0.46 * cos(2 * M_PI * x);
}

static inline float clamp(float val, float min, float max)
{
	return (val < min) ? min : ((val > max) ? max : val);
}

void wf_setdata(gfloat *samples, gint len)
{
	gint i;

	for (i = 0; i < len; i++) {
		wfbuffer[wfpointer] = samples[i];
		wfpointer = (wfpointer + 1) % WF_BLOCKLEN;
	}
}

void wf_run(void)
{
	complex in[WF_FFTLEN], out[WF_FFTLEN];
	unsigned char data[WATERFALL_WIDTH];
	Waterfall *wfall;
	Scope *scope;
	float f;
	int i, j;

        memset(in, 0, sizeof(in));

	for (i = 0; i < WF_BLOCKLEN; i++) {
		j = (i + wfpointer) % WF_BLOCKLEN;
		in[i].re = wfbuffer[j] * wfwindow[i];
		in[i].im = 0.0;
	}

	fft(wffft, in, out);

	for (i = 0; i < WATERFALL_WIDTH; i++) {
		f = cmod(out[i + WF_START]);
		f = -10.0 * log10(f) * 256.0 / WF_DBSPAN;
		data[i] = (unsigned char) clamp(f, 0.0, 255.0);
	}

	wfall = WATERFALL(lookup_widget(appwindow, "waterfall"));
	waterfall_setdata(wfall, data);

	scope = SCOPE(lookup_widget(appwindow, "scope"));
	scope_setdata(scope, wfbuffer);

	return;
}

void init_wf(void)
{
	float f;
	int i;

	wffft = init_fft(WF_FFTLEN);

	for (i = 0; i < WF_BLOCKLEN; i++) {
		f = i / (WF_BLOCKLEN - 1.0);
		wfwindow[i] = hamming(f) / WF_FFTLEN;
	}
}

