#include <gnome.h>

#include "mfsk.h"
#include "qsodata.h"

struct qsodata {
	char call[64];
	char band[64];
	char txrst[64];
	char rxrst[64];
	char name[64];
	char qth[64];
	char notes[256];

	time_t time;
};

static struct qsodata qso;

/* ---------------------------------------------------------------------- */

void clear_qsodata(void)
{
	set_qsocall("");
	set_qsoband("");
	set_qsotxrst("");
	set_qsorxrst("");
	set_qsoname("");
	set_qsoqth("");
	set_qsonotes("");

	memset(&qso, 0, sizeof(struct qsodata));
}

void log_qsodata(void)
{
	get_qsocall();
	get_qsoband();
	get_qsotxrst();
	get_qsorxrst();
	get_qsoname();
	get_qsoqth();
	get_qsonotes();

	g_print("time: %s", ctime(&qso.time));
	g_print("callsign: %s\n", qso.call);
	g_print("band: %s\n", qso.band);
	g_print("sent rst: %s\n", qso.txrst);
	g_print("received rst: %s\n", qso.rxrst);
	g_print("name: %s\n", qso.name);
	g_print("qth: %s\n", qso.qth);
	g_print("notes: %s\n\n", qso.notes);

	clear_qsodata();
}

/* ---------------------------------------------------------------------- */

void set_qsotime(void)
{
	if (qso.time == 0) {
		time(&qso.time);
	}
}

/* ---------------------------------------------------------------------- */

static void set_entry(const gchar *name, gchar *str)
{
	gpointer p;

	p = gtk_object_get_data(GTK_OBJECT(appwindow), name);
	gtk_entry_set_text(GTK_ENTRY(p), str);	
}

void set_qsocall(char *str)
{
	set_entry("qsocallentry", str);
}

void set_qsoband(char *str)
{
	set_entry("qsobandentry", str);
}

void set_qsotxrst(char *str)
{
	set_entry("qsotxrstentry", str);
}

void set_qsorxrst(char *str)
{
	set_entry("qsorxrstentry", str);
}

void set_qsoname(char *str)
{
	set_entry("qsonameentry", str);
}

void set_qsoqth(char *str)
{
	set_entry("qsoqthentry", str);
}

void set_qsonotes(char *str)
{
	set_entry("qsonotesentry", str);
}

/* ---------------------------------------------------------------------- */

static gchar *get_entry(const gchar *name)
{
	gpointer p;

	p = gtk_object_get_data(GTK_OBJECT(appwindow), name);
	return gtk_entry_get_text(GTK_ENTRY(p));
}

#define safecopy(d,s)	{ strncpy((d),(s),sizeof(d)); (d)[sizeof(d)-1]=0; }

char *get_qsocall(void)
{
	gchar *p;

	p = get_entry("qsocallentry");
	safecopy(qso.call, p);
	return qso.call;
}

char *get_qsoband(void)
{
	gchar *p;

	p = get_entry("qsobandentry");
	safecopy(qso.band, p);
	return qso.band;
}

char *get_qsotxrst(void)
{
	gchar *p;

	p = get_entry("qsotxrstentry");
	safecopy(qso.txrst, p);
	return qso.txrst;
}

char *get_qsorxrst(void)
{
	gchar *p;

	p = get_entry("qsorxrstentry");
	safecopy(qso.rxrst, p);
	return qso.rxrst;
}

char *get_qsoname(void)
{
	gchar *p;

	p = get_entry("qsonameentry");
	safecopy(qso.name, p);
	return qso.name;
}

char *get_qsoqth(void)
{
	gchar *p;

	p = get_entry("qsoqthentry");
	safecopy(qso.qth, p);
	return qso.qth;
}

char *get_qsonotes(void)
{
	gchar *p;

	p = get_entry("qsonotesentry");
	safecopy(qso.notes, p);
	return qso.notes;
}

/* ---------------------------------------------------------------------- */

