
/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 *
 * DO NOT EDIT: this file has been generated automatically by MetaDOM
 */

#include <gdome.h>


#include "GdomeSmartDOMBasic.hh"
#include "GdomeSmartDOMDOMImplementation.hh"
#include "GdomeSmartDOMCore.hh"


namespace GdomeSmartDOM {

Element::Element(GdomeElement* obj)

  : Node((GdomeNode*) obj) { }
  Element::Element(const Element& obj)
  
  : Node(obj)
      
{
  
}

  Element::Element(const Node& obj)
  
  : Node((GdomeNode*) gdome_cast_el(obj.gdome_object()))
      
{
  
}

  Element& Element::operator=(const Element& obj)
{
  if (this == &obj) return *this;

  GdomeException exc_ = 0;

  if (gdome_obj != 0) {

    gdome_el_unref((GdomeElement*) gdome_obj, &exc_);
  

    gdome_obj = 0;
  }
  
  if (exc_ == 0) {
    gdome_obj = obj.gdome_obj;

    if (gdome_obj != 0) gdome_el_ref((GdomeElement*) gdome_obj, &exc_);
  
  }
  
  if (exc_ != 0) throw DOMException(exc_, "Element::operator=");

  return *this;
}

bool Element::operator==(const Element& obj) const
{
  return gdome_obj == obj.gdome_obj;
}

Element::~Element()
{
  
}

DOMString Element::get_tagName() const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_el_tagName((GdomeElement*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Element::get_tagName");
  return DOMString_of_GdomeDOMString(res_);
}

DOMString Element::getAttribute(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeDOMString* res_ = gdome_el_getAttribute((GdomeElement*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::getAttribute");
  return DOMString_of_GdomeDOMString(res_);
}

void Element::setAttribute(const DOMString& name, const DOMString& value) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeDOMString* value_ = GdomeDOMString_of_DOMString(value);
  gdome_el_setAttribute((GdomeElement*) gdome_obj, name_, value_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (value_ != 0) gdome_str_unref(value_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::setAttribute");
  
}

void Element::removeAttribute(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  gdome_el_removeAttribute((GdomeElement*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::removeAttribute");
  
}

Attr Element::getAttributeNode(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeAttr* res_ = gdome_el_getAttributeNode((GdomeElement*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::getAttributeNode");
  return Attr(res_);
}

Attr Element::setAttributeNode(const Attr& newAttr) const
{
  GdomeException exc_;
  GdomeAttr* res_ = gdome_el_setAttributeNode((GdomeElement*) gdome_obj, (GdomeAttr*) newAttr.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::setAttributeNode");
  return Attr(res_);
}

Attr Element::removeAttributeNode(const Attr& oldAttr) const
{
  GdomeException exc_;
  GdomeAttr* res_ = gdome_el_removeAttributeNode((GdomeElement*) gdome_obj, (GdomeAttr*) oldAttr.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::removeAttributeNode");
  return Attr(res_);
}

NodeList Element::getElementsByTagName(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeNodeList* res_ = gdome_el_getElementsByTagName((GdomeElement*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::getElementsByTagName");
  return NodeList(res_);
}

DOMString Element::getAttributeNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  GdomeDOMString* res_ = gdome_el_getAttributeNS((GdomeElement*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::getAttributeNS");
  return DOMString_of_GdomeDOMString(res_);
}

void Element::setAttributeNS(const DOMString& namespaceURI, const DOMString& qualifiedName, const DOMString& value) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* qualifiedName_ = GdomeDOMString_of_DOMString(qualifiedName);
  GdomeDOMString* value_ = GdomeDOMString_of_DOMString(value);
  gdome_el_setAttributeNS((GdomeElement*) gdome_obj, namespaceURI_, qualifiedName_, value_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (qualifiedName_ != 0) gdome_str_unref(qualifiedName_);
  
  if (value_ != 0) gdome_str_unref(value_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::setAttributeNS");
  
}

void Element::removeAttributeNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  gdome_el_removeAttributeNS((GdomeElement*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::removeAttributeNS");
  
}

Attr Element::getAttributeNodeNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  GdomeAttr* res_ = gdome_el_getAttributeNodeNS((GdomeElement*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::getAttributeNodeNS");
  return Attr(res_);
}

Attr Element::setAttributeNodeNS(const Attr& newAttr) const
{
  GdomeException exc_;
  GdomeAttr* res_ = gdome_el_setAttributeNodeNS((GdomeElement*) gdome_obj, (GdomeAttr*) newAttr.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::setAttributeNodeNS");
  return Attr(res_);
}

NodeList Element::getElementsByTagNameNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  GdomeNodeList* res_ = gdome_el_getElementsByTagNameNS((GdomeElement*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::getElementsByTagNameNS");
  return NodeList(res_);
}

bool Element::hasAttribute(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeBoolean res_ = gdome_el_hasAttribute((GdomeElement*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::hasAttribute");
  return res_;
}

bool Element::hasAttributeNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  GdomeBoolean res_ = gdome_el_hasAttributeNS((GdomeElement*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Element::hasAttributeNS");
  return res_;
}



}

