/*
 * Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 * 
 * This file is part of GtkMathView, a Gtk widget for MathML.
 * 
 * GtkMathView is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * GtkMathView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GtkMathView; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, see the GtkMathView World-Wide-Web page,
 * http://cs.unibo.it/~lpadovan/mml-widget, or send a mail to
 * <luca.padovani@cs.unibo.it>
 */

#ifndef config_h
#define config_h

@TOP@

/* If defined the library will perform a huge amount
 * of validity checks while running
 */
#undef ENABLE_DEBUG

#ifdef ENABLE_DEBUG
#define DEBUG
#else
#define NDEBUG
#define G_DISABLE_ASSERT
#define G_DISABLE_CHECKS
#endif

/* If defined the library will collect some information
 * for profiling purposes
 */
#undef ENABLE_PROFILE

/* Define if iconv has a const second argument */
#undef ICONV_CONST

/* Define if the type fmtflags is defined inside ios.
 * Otherwise it is assumed to be defined in ios_base
 */
#undef HAVE_IOS_CLASS

/* Define if you have getopt_long */
#undef HAVE_GETOPT_LONG

/* Define if glib in installed in your system */
#undef HAVE_GLIB

@BOTTOM@

#endif /* config_h */

