/* $Id: terminal.h 222803 2020-06-03 21:58:05Z twu $ */
#ifndef TERMINAL_INCLUDED
#define TERMINAL_INCLUDED

#include "bool.h"
#include "list.h"
#include "compress.h"
#include "genome.h"
#include "iit-read-univ.h"
#include "listpool.h"
#include "hitlistpool.h"

extern void
Terminal_solve_plus (int *found_score_overall, int *found_score_within_trims,
		     List_T *sense_hits_plus, List_T *antisense_hits_plus, 
		     List_T queryfwd_plus_set, List_T queryrev_plus_set,

		     int *mismatch_positions_alloc,
		     Compress_T query_compress_fwd, int querylength, 
		     int genestrand, Listpool_T listpool,
		     Hitlistpool_T hitlistpool, int level);

extern void
Terminal_solve_minus (int *found_score_overall, int *found_score_within_trims,
		      List_T *sense_hits_minus, List_T *antisense_hits_minus, 
		      List_T queryfwd_minus_set, List_T queryrev_minus_set,

		      int *mismatch_positions_alloc,
		      Compress_T query_compress_rev, int querylength, 
		      int genestrand, Listpool_T listpool,
		      Hitlistpool_T hitlistpool, int level);

extern void
Terminal_setup (Univ_IIT_T chromosome_iit_in, Univcoord_T genomelength_in, int circular_typeint_in,
		Genome_T genomebits_in, Genome_T genomebits_alt_in,
		bool splicingp_in, int index1part_in, int index1interval_in,
		int subopt_levels_in);

#endif

