struct conf_t {
    gchar *server_host;
    gint  server_port;
    gchar *server_pass;
    gboolean autoconnect;
    gboolean playlist_vis_on_start;
    gboolean time_display_left;
    long refresh_rate;

    gboolean vis_filename;
    gboolean vis_artist;
    gboolean vis_title;
    gboolean vis_album;
    gboolean vis_track;
    gboolean vis_name;
    gboolean vis_pos;
    gboolean vis_id;
};

typedef struct conf_t GlurpConfig;

struct song_t {
    gchar *file;
    gchar *artist;
    gchar *title;
    gchar *album;
    gchar *track;
    gchar *name;
    gint time;
    gint pos;
    gint id;
    struct song_t *next;
};

typedef struct song_t GlurpSong;

struct pl_t {
    gchar *name;
    struct pl_t *next;
};

typedef struct pl_t GlurpPl;

struct stream_t {
    gchar *url;
    struct stream_t *next;
};

typedef struct stream_t GlurpStream;

struct glurp_t {
    GlurpConfig *config;
    mpd_Connection *conn;
    GlurpSong *playlist;
    GlurpSong *current_song;
    GtkListStore *gui_playlist;
    GtkListStore *gui_playlist_list;
    GtkListStore *gui_stream_list;
    GtkTreeStore *gui_addtree;
    gboolean progress_dragging;
    gint refresh_rate_status;
    long long playlist_version;
    GlurpPl *playlists;
    gint statusbar_status;
    gint conn_state;
    gint play_state;
    gint prev_song_num;
    gint scroll;
    gint num_add_dirs;
    gboolean updating_db;
    GlurpStream *stream_history;
};

typedef struct glurp_t GlurpState;
