/* glpduff.h */

/*----------------------------------------------------------------------
-- Copyright (C) 2000, 2001, 2002 Andrew Makhorin <mao@mai2.rcnet.ru>,
--               Department for Applied Informatics, Moscow Aviation
--               Institute, Moscow, Russia. All rights reserved.
--
-- This file is a part of GLPK (GNU Linear Programming Kit).
--
-- GLPK is free software; you can redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2, or (at your option)
-- any later version.
--
-- GLPK is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
-- License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with GLPK; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
-- 02111-1307, USA.
----------------------------------------------------------------------*/

#ifndef _GLPDUFF_H
#define _GLPDUFF_H

#define create_duff           _glp_create_duff
#define include_obj           _glp_include_obj
#define exclude_obj           _glp_exclude_obj
#define reset_duff            _glp_reset_duff
#define delete_duff           _glp_delete_duff

typedef struct DUFF DUFF;

struct DUFF
{     /* Duff's scheme (it is a set of n objects, where each object has
         a length from 0 to maxlen; if some object is not in the scheme,
         its length formally is -1) */
      int n;
      /* total number of objects */
      int maxlen;
      /* maximal length of each object */
      int *len; /* int len[1:n]; */
      /* len[k] is length of k-th object (1 <= k <= n); if k-th object
         is not in the scheme then len[k] is -1 */
      int *head; /* int head[0:maxlen]; */
      /* head[len] is the number of the first object length of which is
         len (0 <= len <= maxlen) */
      int *prev; /* int prev[1:n]; */
      /* prev[k] is the number of the preceding object that has the same
         length as k-th object (0 means the end of the list) */
      int *next; /* int next[1:n]; */
      /* next[k] is the number of the following object that has the same
         length as k-th object (0 means the end of the list) */
};

extern DUFF *create_duff(int n, int maxlen);
/* create Duff's scheme */

extern void include_obj(DUFF *duff, int k, int len);
/* include object to Duff's scheme */

extern void exclude_obj(DUFF *duff, int k);
/* exclude object from Duff's scheme */

extern void reset_duff(DUFF *duff);
/* clear Duff's scheme */

extern void delete_duff(DUFF *duff);
/* delete Duff's scheme */

#endif

/* eof */
