/*  Glimmer - session.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _SESSION_H_
#define _SESSION_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "widgets/gnome-file-selector.h"

guint get_last_session(void);
void save_session_cb(GtkWidget *widget, gpointer data);
void open_session_cb(GtkWidget *widget, gpointer data);
void open_session_continue(GtkWidget *widget, GnomeFileSelector *file_list);
void save_session_as_cb(GtkWidget *widget, gpointer data);
void save_session_as_continue(GtkWidget *widget, GnomeFileSelector *file_list);
void save_session_as_error_continue(GtkWidget *widget, gchar *filename);
gboolean save_session_to_file(gchar *filename);
guint open_session_from_file(gchar *filename);
void save_session_directory_history(void);
void load_session_directory_history(void);

extern gchar *session_file;

#ifdef __cplusplus
}
#endif

#endif
