/* Glimmer - print.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 *(at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *   Chema Celorio <chema@celorio.com>
 *   Chris Phelps <chicane@reninet.com>
 */ 

#ifndef _GLIMMER_PRINT_H_
#define _GLIMMER_PRINT_H_

#include <gdsfile.h>
#include <main.h>
#include <settings.h>

typedef enum {
    PRINT_ORIENT_LANDSCAPE,
    PRINT_ORIENT_PORTRAIT
} GlimmerPrintOrientation;

#include <libgnomeprint/gnome-printer.h>
#include <libgnomeprint/gnome-printer-dialog.h>
#include <libgnomeprint/gnome-print-master.h>
#include <libgnomeprint/gnome-print-master-preview.h>
#include <libgnomeprint/gnome-print-preview.h>

typedef struct _PrintJobInfo {
    /* gnome print stuff */
    GnomePrintMaster *master;
    GnomePrintContext *pc;
    GnomePrinter *printer;
    const GnomePaper *paper;

    /* document stuff */
    GdsFile *file;
    gchar *buffer;
    guint buffer_size;
    gchar *filename;
    gboolean print_header;
    gint print_line_numbers;
    
    /* Font stuff */ 
    float   font_char_width;
    float   font_char_height;
    GnomeFont *font_body;
    GnomeFont *font_header;
    GnomeFont *font_numbers;

    /* Page stuff */ 
    guint   pages;
    float   page_width, page_height;
    float   margin_top, margin_bottom, margin_left, margin_right, margin_numbers;
    float   printable_width, printable_height;
    float   header_height;
    guint   total_lines;
    guint   total_lines_real;
    guint   lines_per_page;
    guint   chars_per_line;
    guchar* temp;
    GlimmerPrintOrientation orientation;

    /* Range stuff */
    gint range;
    gint page_first;
    gint page_last;
    gboolean print_this_page;
    gboolean preview;
    
    gint copies;
    gint collate;
    
    /* buffer stuff */
    gint file_offset;
    gint current_line;

    /* Text Wrapping */
    gboolean wrapping;
    gint tab_size;

    /* Progress */
    GtkWidget   *progress_bar;
    GnomeDialog *progress_dialog;
    gboolean canceled;
} PrintJobInfo;


void glimmer_print_cb (GtkWidget *widget, gpointer notused);
void glimmer_print_preview_cb (GtkWidget *widget, gpointer notused);
 
#endif /* __GLIMMER_PRINT_H__ */
