/*  Glimmer - gnomegotoline.h
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef GNOME_GOTO_LINE_DIALOG_H__
#define GNOME_GOTO_LINE_DIALOG_H__
#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_GOTO_LINE_DIALOG (gnome_goto_line_dialog_get_type())
#define GNOME_GOTO_LINE_DIALOG(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_GOTO_LINE_DIALOG, GnomeGotoLineDialog))
#define GNOME_GOTO_LINE_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_GOTO_LINE_DIALOG, GnomeGotoLineDialogClass))
#define GNOME_IS_GOTO_LINE_DIALOG(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_GOTO_LINE_DIALOG))
#define GNOME_IS_GOTO_LINE_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_GOTO_LINE_DIALOG))

typedef struct _GnomeGotoLineDialog GnomeGotoLineDialog;
typedef struct _GnomeGotoLineDialogClass GnomeGotoLineDialogClass;

struct _GnomeGotoLineDialog {
   GtkWindow window;
   GtkWidget *combo;
   GtkWidget *line_entry; /* Lets have both, even tho they are the same widget */
   GtkWidget *check_stay_open;
   GtkWidget *goto_button;
   GtkWidget *cancel_button;
   GList *history;
};

struct _GnomeGotoLineDialogClass {
   GtkWindowClass parent_class;
};

GtkType gnome_goto_line_dialog_get_type(void);

GtkWidget *gnome_goto_line_dialog_new(void);
gint gnome_goto_line_dialog_get_line(GnomeGotoLineDialog *gtl);
void gnome_goto_line_dialog_set_history(GnomeGotoLineDialog *gtl, GList *history);
gboolean gnome_goto_line_dialog_add_search_string(GnomeGotoLineDialog *gtl, gchar *string);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
