/*  Glimmer - build.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _BUILD_H_
#define _BUILD_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "widgets/gdsfile.h"

void set_build_sensitivity(void);
void compile_file_cb(GtkWidget *widget, gpointer data);
void compile_file_full(GtkWidget *widget, GdsFile *file);
void kill_compile_cb(GtkWidget *widget, gpointer data);
void debug_file_cb(GtkWidget *widget, gpointer data);
void debug_file_full(GtkWidget *widget, GdsFile *file);
void kill_debug_cb(GtkWidget *widget, gpointer data);
void execute_file_cb(GtkWidget *widget, gpointer data);
void execute_file_full(GtkWidget *widget, GdsFile *file);
void kill_execute_cb(GtkWidget *widget, gpointer data);

#ifdef __cplusplus
}
#endif

#endif
