// $Id: toolbar.cc,v 1.74 2003/11/03 07:39:00 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"
#include "button.hh"
#include <typeinfo>

class Gtk_Toolbar : public Gtk_Container
{
public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Toolbar();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
//	virtual bool CantMemberConstruct(const Widget &w) const
//	{  return true; }
	virtual void AdditionalMemberVars(const Widget &w,CxxFile &f,bool container=false) const;
	virtual void CreatePointer_Toplevel(const Widget &w,CxxFile &f) const;
	virtual void DestroyPointer_Toplevel(const Widget &w,CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const;
	virtual Subwidget IsSubwidget(const Widget &w,const Widget &ch) const;
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual const std::string Instance(const Widget &parent,const Widget &w2,Subwidget sw=SW_Unknown) const;
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;
	
	// new style API
	void CreatePointer_depending(const Widget &w,CxxFile &f) const;
	void PushToolBarElem(const Widget &w,CxxFile &f, const std::string &instance, const Widget &tb) const;
};

static Gtk_Toolbar Gtk_Toolbar;

const std::string Gtk_Toolbar::TypeName(const Widget &w) const
{  return GtkPrefix()+"Toolbar";
}

const std::string Gtk_Toolbar::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"toolbar.h";
}

Gtk_Toolbar::Gtk_Toolbar()
{  Writer["GtkToolbar"]=this;
}

void Gtk_Toolbar::ConstructionArgs(const Widget &w, CxxFile &f) const
{  
  if (GTKMM1)
  {
   std::string orientation=w.getProperty("orientation","GTK_ORIENTATION_HORIZONTAL");
   std::string style=w.getProperty("type","GTK_TOOLBAR_BOTH");

   f.FunctionArg() << orientation;
   f.FunctionArg() << style;
  }
  else f.FunctionArg();
}

 // toolbar.tools.push_back(WidgetElem(widget[,tooltip_text,private_text]));
void Gtk_Toolbar::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  // CreatePointer_depending does the work
}

void Gtk_Toolbar::CreatePointer_Toplevel(const Widget &w,CxxFile &f) const
{  Parent::CreatePointer_Toplevel(w,f);
}

Subwidget Gtk_Toolbar::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (ch.ChildName()=="Toolbar:button" || ch.Class()=="button"
	|| ch.Class()=="togglebutton" || ch.Class()=="radiobutton" 
	|| ch.Class()=="toggle" || ch.Class()=="radio") 
   {  if (ch.begin()!=ch.end()) return not_Subwidget; // constructs itself
      return is_Subwidget_all;
   }
   return not_Subwidget;
}

void Gtk_Toolbar::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   if (GTKMM1) WriteIntProperty(w,f,instance, "space_size");
   WriteBoolProperty(w,f,instance, "tooltips");

   const std::string relief(w.getProperty("relief","GTK_RELIEF_NORMAL"));
   if (relief!="GTK_RELIEF_NORMAL")
      f.Statement() << instance << "set_button_relief(" << Gtkmm2Namespace(relief) << ')';

  if (GTKMM1)
  {  WriteEnumPropertyNS(w,f,instance, "space_style");
  }
  else
  {  WriteEnumPropertyNS(w,f,instance, "toolbar_style");
     WriteEnumPropertyNS(w,f,instance, "orientation");
     WriteEnumPropertyNS(w,f,instance, "icon_size");
  }
}

void Gtk_Toolbar::AdditionalMemberVars(const Widget &w,CxxFile &f,bool container) const
{  Parent::AdditionalMemberVars(w,f,container);
                     
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && IsSubwidget(w,*i)!=not_Subwidget)
      {  const Widget w2(*i);
         LookupWriter(w2).GHDeclaration(w2,f);
      }
   }
}

void Gtk_Toolbar::DestroyPointer_Toplevel(const Widget &w,CxxFile &f) const
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && IsSubwidget(w,*i)!=not_Subwidget)
      {  const Widget w2(*i);
         LookupWriter(w2).DestroyPointer(w2,f);
      }
   }
   Parent::DestroyPointer_Toplevel(w,f);
}

void Gtk_Toolbar::ApplyPreferences(Tag &t) const
{  Parent::ApplyPreferences(t);
   Widget w(&t);
   for (Widget::iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && IsSubwidget(w,*i)!=not_Subwidget)
      {  if (GTKMM1 && !Configuration.gnome_support && (*i).hasProperty("stock_pixmap"))
         {  Configuration.gnome_support=true;
            std::cerr << "Stock Pixmaps need gnome_support, please turn it on\n";
         }
      }
   }
}

void Gtk_Toolbar::GCInclude(const Widget &w, CxxFile &f) const
{  // look for .xpm items in the buttons to include
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && IsSubwidget(w,*i)!=not_Subwidget)
      {const Widget w2(*i);
       if (w2.hasProperty("stock_pixmap"))
       {  if (GTKMM1 && Configuration.gnome_support)
             f.Include("libgnomeui/gnome-stock.h");
          else if (GTKMM2)
          {  f.Include(Configuration.GtkmmIncludePath()+"image.h");
             f.Include(Configuration.GtkmmIncludePath()+"stockid.h");
          }
       }
       if (GTKMM1 && w2.hasProperty("icon"))
       {  const std::string icon(w2.getProperty("icon"));
          if (!icon.empty() && !xpmname(icon).empty())
          {  f.Include(Configuration.GtkmmIncludePath()+"pixmap.h");
             f.Include(Configuration.CString(Configuration.pixmap_dir_relative_to_src+"/"+icon),true);
          }
       }
       else if (GTKMM2 && w2.hasProperty("icon"))
       {  const Widget image=static_cast<const Gtk_Button*>(Writer["GtkButton"])
		->get_image(w2);
          const WriterBase &wr=LookupWriter(image);
	  wr.GHInclude(image,f);
	  wr.GCInclude(image,f);
       }
      }
   }
   Parent::GCInclude(w,f);
}

const std::string Gtk_Toolbar::Instance(const Widget &parent,const Widget &w2, Subwidget sw) const
{  if (w2.Class()=="Placeholder") return "";
   return Configuration.InstanceName(w2.Name())+"->";
}

bool Gtk_Toolbar::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char prefix[]="gtk_toolbar_";
   const int plen(sizeof(prefix)-1);
   if (method.substr(0,plen)==prefix) method=method.substr(plen);
// not in 1.2   if (((method=="append_space" ||method=="prepend_space") && args.empty())
   if (((method=="set_tooltips") && matches("bool\\ \\_",args))
	|| ((method=="set_space_size") 
		&& (matches("gint\\ \\_",args)||matches("int\\ \\_",args))))
   {  scope=Gtk_Toolbar::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

void Gtk_Toolbar::PushToolBarElem(const Widget &w,CxxFile &f, 
			const std::string &instance,const Widget &tb) const
{ const ChildParamList ch=w.get_Child_params();
  if (ch.getBoolProperty("new_group"))
  {  f.Statement() << instance << "tools().push_back(" 
  	<< Gtk_Button::ToolBarElemPrefix() << "Space())";
  }
  if (IsSubwidget(tb,w)==not_Subwidget)
  {  f.Statement() << instance << "tools().push_back(" 
  	<< Gtk_Button::ToolBarElemPrefix() << "Element("
        << Reference(w) 
        // tooltip_text, tooltip_private_text
        << "))";
  }
  else try
  { const Gtk_Button &wr=dynamic_cast<const Gtk_Button &>(LookupWriter(w));
    std::string childInstance=Configuration.InstanceName(w.Name()) + "->";

    if (GTKMM2 && w.hasProperty("icon"))
    {  const Widget image=wr.get_image(w);
       LookupWriter(image).CreatePointer(image,f);
    }
    wr.ToolBar_vars(w,f); // radio groups etc.
    
    f.Declaration();		// *** Necessary to get state right.
    f.FunctionName() << instance << "tools().push_back";
    f.FunctionArg();
    wr.ToolBarElemCreation(w,f);
    w.markManaged();

    if (w.getProperty("cxx_visibility","private")=="private" && CanBeManaged(w)) 
       f.Declaration() << wr.TypeName(w) << " *";
    else f.Statement();
    f << Configuration.InstanceName(w.Name());
    f.Assignment() << "static_cast<" << wr.TypeName(w) << " *>(";
//    if (Configuration.gtkmm_version>=Pkg_Version(1,3,17)) f << '&';
    f << instance << "tools().back()"<<(GTKMM1 ? "->" : ".")<<"get_widget())";
  }
  catch (std::bad_cast &e) 
  {  assert(!"Internal toolbar children need to derive from Button\n"); }
}


void Gtk_Toolbar::CreatePointer_depending(const Widget &w,CxxFile &f) const
{  
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
         PushToolBarElem(*i, f, Configuration.InstanceName(w.Name())+"->", w);
   }
   Parent::CreatePointer_depending(w,f);
}

