// $Id: widget.cc,v 1.37 2001/12/12 14:13:26 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.hh"

const std::string Gtk_Widget::TypeName(const Widget &w) const
{  return GtkPrefix()+"Widget";
}

const std::string Gtk_Widget::IncludeName(const Widget &w) const
{  return "gtk--/widget.h";
}

const std::string Gtk_Widget::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const
{  if (signal=="draw") return "GdkRectangle *rect";
   if (signal=="size_request") return "GtkRequisition *req";
   if (signal=="size_allocate") return "GtkAllocation *all";
   if (signal=="state_changed") return "unsigned int state";
   if (signal=="event") { rettype="gint"; return "GdkEvent *ev"; }
   if (signal=="button_press_event" || signal=="button_release_event")
   { rettype="gint"; return "GdkEventButton *ev"; }
   if (signal=="motion_notify_event") { rettype="gint"; return "GdkEventMotion *ev"; }
   if (signal=="delete_event" || signal=="map_event" || signal=="unmap_event") 
   { rettype="gint"; return "GdkEventAny *ev"; }
   if (signal=="expose_event") { rettype="gint"; return "GdkEventExpose *ev"; }
   if (signal=="key_press_event" || signal=="key_release_event")
   { rettype="gint"; return "GdkEventKey *ev"; }
   if (signal=="enter_notify_event" || signal=="leave_notify_event")
   { rettype="gint"; return "GdkEventCrossing *ev"; }
   if (signal=="configure_event") { rettype="gint"; return "GdkEventConfigure *ev"; }
   if (signal=="focus_in_event" || signal=="focus_out_event")
   { rettype="gint"; return "GdkEventFocus *ev"; }
   if (signal=="property_notify_event") { rettype="gint"; return "GdkEventProperty *ev"; }
   if (signal=="selection_clear_event" || signal=="selection_request_event" || signal=="selection_notify_event") 
   { rettype="gint"; return "GdkEventSelection *ev"; }
   if (signal=="proximity_in_event" || signal=="proximity_out_event")
   { rettype="gint"; return "GdkEventProximity *ev"; }
   if (signal=="drag_begin_event") { rettype="gint"; return "GdkEventDragBegin *ev"; }
   if (signal=="drag_request_event") { rettype="gint"; return "GdkEventDragRequest *ev"; }
   if (signal=="drop_enter_event") { rettype="gint"; return "GdkEventDropEnter *ev"; }
   if (signal=="drop_leave_event") { rettype="gint"; return "GdkEventDropLeave *ev"; }
   if (signal=="drop_data_available_event") { rettype="gint"; return "GdkEventDropDataAvailable *ev"; }
   if (signal=="other_event") { rettype="gint"; return "GdkEventOther *ev"; }
   if (signal=="selection_received") return "GtkSelectionData *data";
   if (signal=="client_event") { rettype="gint"; return "GdkEventClient *ev"; }
   if (signal=="no_expose_event") { rettype="gint"; return "GdkEventAny *ev"; }
   return "";
}

// define this to allow widgets of this type
//static Gtk_Widget Gtk_Widget;

void Gtk_Widget::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{ 
  /* Note: Below code causes trouble for menu items, as objects are created
          _after_ this method is called. Also, most of it doesn't apply anyway;
	  the bits that do have been copied to appropriate locations. */
  if(TypeName(w).find("MenuItem")!=std::string::npos)
    return;
  
  int width=w.getInt("width",-1);
  int height=w.getInt("height",-1);
   if (width!=-1 || height!=-1)
   {  f.Statement() << instance << "set_usize(" << width << ", " << height << ')';
   }
   
   // uposition

   const std::string events(w.getString("events",""));
   if (events.size())
   {  f.Statement() << instance << "set_events(" << events << ")";
   }

   // style

   std::string name(w.getString("name",""));
   if (name.size() && Configuration.widget_names)
   {  f.Statement() << instance << "set_name(" << Configuration.CString_WithQuotes(name) << ')';
   }
   if (!w.getBool("sensitive",true))
   {  f.Statement() << instance << "set_sensitive(false)";
   }
   // this should vary according to widget's standard behaviour
   if (!w.getBool("can_focus",default_can_focus()))
   {  if (default_can_focus())
         f.Statement() << instance << "unset_flags(GTK_CAN_FOCUS)";
   }
   else
   {  if (!default_can_focus())
         f.Statement() << instance << "set_flags(GTK_CAN_FOCUS)";
   }
   if (w.getBool("has_focus",false))
   {  f.Statement() << instance << "grab_focus()";
   }
   
   if (w.hasTag("tooltip") && (!w.isSeperateClass() || !instance.size()))
   {  std::string tooltip(w.getString("tooltip",""));
      f.Statement() << "_tooltips.set_tip(" << Reference(instance)
            << ", " << Configuration.Translatable(tooltip) << ", \"\")";
   }
#warning this will fail for internal widgets !!
   if (Configuration.has_accelerators && w.hasTag("accelerator"))
   { for (Widget::const_iterator i=w.get_Accels();i!=w.end();++i)
      {  const std::string modifiers(i->getString("modifiers"));
         const std::string key(i->getString("key"));
         const std::string signal(i->getString("signal"));
         
         if (!modifiers.size() || !key.size() || !signal.size())
            std::cerr << w.Name() << ": accel is missing param (" 
            	<< modifiers << ',' << key << ',' << signal << ")\n";
	 else // gtkmm 1.1
	 { 
	   f.Statement() << instance
			 << "add_accelerator(" 
			 << Configuration.CString_WithQuotes(signal)
			 << ", *_data->getAccelGroup(), " << key
			 << ", (GdkModifierType )" << modifiers 
			 << ", GTK_ACCEL_VISIBLE)";
 	 }
      }
   }
}

void Gtk_Widget::Configure_show(const Widget &w, CxxFile &f,const std::string &instance) const
{  if (w.getBool("visible",true))
   {  f.Statement() << instance << "show()";
   }
}

void Gtk_Widget::ApplyPreferences(Tag &t) const
{  if (!Configuration.has_accelerators && t.hasTag("accelerator"))
	Configuration.has_accelerators=true;
   Parent::ApplyPreferences(t);
}

bool Gtk_Widget::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char *prefix("gtk_widget_");
   const int plen(sizeof(prefix)-1);
   if (!strncmp(prefix,method.c_str(),plen))
      method=std::string(method.c_str()+plen);
   if ((method=="grab_focus" && !args.size())
	|| (method=="show" && !args.size())
	|| (method=="hide" && !args.size())
	|| (method=="destroy" && !args.size()))
   {  scope=Gtk_Widget::TypeName(w);
      is_signal=true;
      return true;
   }
   if ((method=="grab_default" && !args.size())
	|| (method=="set_usize" && matches("gint\\ \\_,gint\\ \\_",args))
	|| ((method=="set_flags" || method=="unset_flags") 
		&& (matches("gint\\ \\_",args)||matches("int\\ \\_",args))))
   {  scope=Gtk_Widget::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

