// $Id: searchcombo.cc,v 1.24 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

class Gtk_SearchCombo : public Gtk_HBox
{public:
	typedef Gtk_HBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_SearchCombo();
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const;
};

static Gtk_SearchCombo Gtk_SearchCombo;

const std::string Gtk_SearchCombo::TypeName(const Widget &w) const
{  return GtkPrefix()+"SearchCombo";
}

const std::string Gtk_SearchCombo::IncludeName(const Widget &w) const
{  return "SearchCombo.h";
}

Gtk_SearchCombo::Gtk_SearchCombo()
{  Writer["SearchComboBox"]=this; // old glade name
   Writer["Gtk_SearchCombo"]=this; // nonsense
   Writer["GtkSearchCombo"]=this;
}

void Gtk_SearchCombo::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg() << PRINT_BOOL(w.getBool("alwaysfill",true));
   f.FunctionArg() << PRINT_BOOL(w.getBool("autoexpand",true));
}

void Gtk_SearchCombo::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   // work around gtk bug (see gbwidget.c:3584)
   // "GTK BUG WORKAROUND - a combo should manage the size of its entry."
   int width=w.getInt("width",-1);
   int height=w.getInt("height",-1);
   if (width!=-1 || height!=-1)
   {  f.Statement() << instance << "get_entry()->"
        << "set_usize(" << (width>16?width-16:-1) << ", " << height << ')';
   }
   bool case_sensitive=w.getBool("case_sensitive",true);
   if (case_sensitive)
      f.Statement() << instance << "set_case_sensitive(" << PRINT_BOOL(case_sensitive)
        << ')';
   bool editable=w.getBool("editable",true);
   if (!editable)
      f.Statement() << instance << "set_editable(" << PRINT_BOOL(editable) << ')';
}

const std::string Gtk_SearchCombo::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const
{  if (signal=="search") return "gboolean *_continue, gboolean newsearch";
   else if (signal=="selected") return "";
   return Parent::SignalHandlerArgs(w,signal,rettype);
}
