// $Id: radiomenuitem.cc,v 1.22 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "checkmenuitem.hh"
#include <Cxx_Fileset.hh>

class Gtk_RadioMenuItem : public Gtk_CheckMenuItem
{public:
	typedef Gtk_CheckMenuItem Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_RadioMenuItem();
	virtual bool CantMemberConstruct(const Widget &w) const
	{  return true; }
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void CreatePointer(const Widget &w,CxxFile &f) const;
};

static Gtk_RadioMenuItem Gtk_RadioMenuItem;

const std::string Gtk_RadioMenuItem::TypeName(const Widget &w) const
{  return GtkPrefix()+"RadioMenuItem";
}

const std::string Gtk_RadioMenuItem::IncludeName(const Widget &w) const
{  return "gtk--/radiomenuitem.h";
}

Gtk_RadioMenuItem::Gtk_RadioMenuItem()
{  Writer["GtkRadioMenuItem"]=this;
}

void Gtk_RadioMenuItem::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
   f << "_RadioMIGroup_" << Configuration.InstanceName(w.getString("group",""));
   f.FunctionArg() << Configuration.Translatable(w.getString("label"));
}

void Gtk_RadioMenuItem::CreatePointer(const Widget &w,CxxFile &f) const
{  if (Cxx_Fileset::NeedToDeclareRadioGroup("MI:"+w.getString("group","")))
      f.Declaration() << "Gtk::RadioMenuItem::Group _RadioMIGroup_" 
		<< Configuration.InstanceName(w.getString("group",""));
  Parent::CreatePointer(w,f);
}
