// $Id: paned.cc,v 1.24 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Paned : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Paned();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	void Gtk_Paned::AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gtk_Paned Gtk_Paned;

const std::string Gtk_Paned::TypeName(const Widget &w) const
{  return GtkPrefix()+(w.Class()[3]=='H' ?"HPaned":"VPaned");
}

const std::string Gtk_Paned::IncludeName(const Widget &w) const
{  return "gtk--/paned.h";
}

Gtk_Paned::Gtk_Paned()
{  Writer["GtkHPaned"]=this;
   Writer["GtkVPaned"]=this;
}

void Gtk_Paned::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int handle_size(w.getInt("handle_size",10));
   int gutter_size(w.getInt("gutter_size",6));
   f.Statement() << instance << "set_handle_size(" << handle_size << ')';
   f.Statement() << instance << "set_gutter_size(" << gutter_size << ')';
   int position(w.getInt("position"));
   f.Statement() << instance << "set_position(" << position << ')';
}

void Gtk_Paned::AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const
{  Widget::const_iterator i=w.begin();
   if (i!=w.end() && (*i).Class()!="Placeholder")
   {  const ChildParamList ch((*i).get_Child_params());
      bool resize(ch.getBool("resize",false));
      bool shrink(ch.getBool("shrink",true));
      f.Statement() << instance << "pack1(" << Reference(*i) << ", " 
      		<< PRINT_BOOL(resize) << ", " << PRINT_BOOL(shrink) << ')';
   }
   ++i;
   if (i!=w.end() && (*i).Class()!="Placeholder")
   {  const ChildParamList ch((*i).get_Child_params());
      bool resize(ch.getBool("resize",true));
      bool shrink(ch.getBool("shrink",true));
      f.Statement() << instance << "pack2(" << Reference(*i) << ", " 
      		<< PRINT_BOOL(resize) << ", " << PRINT_BOOL(shrink) << ')';
   }
   ++i;
   if (i!=w.end()) 
      std::cerr << "Paned Window " << w.Name() << " has more than 2 children\n";
}
