// $Id: packer.cc,v 1.9 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Packer : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Packer();
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_Packer Gtk_Packer;

const std::string Gtk_Packer::TypeName(const Widget &w) const
{  return GtkPrefix()+"Packer";
}

const std::string Gtk_Packer::IncludeName(const Widget &w) const
{  return "gtk--/packer.h";
}

Gtk_Packer::Gtk_Packer()
{  Writer["GtkPacker"]=this;
}

void Gtk_Packer::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

#define PACKER_DEFAULT (~((unsigned int)0))

void Gtk_Packer::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  const ChildParamList ch=w.get_Child_params();
   unsigned int border_width=ch.getInt("border_width",PACKER_DEFAULT);
   unsigned int pad_x=ch.getInt("xpad",PACKER_DEFAULT);
   unsigned int pad_y=ch.getInt("ypad",PACKER_DEFAULT);
   unsigned int i_pad_x=ch.getInt("xipad",PACKER_DEFAULT);
   unsigned int i_pad_y=ch.getInt("yipad",PACKER_DEFAULT);
   std::string side(ch.getString("side","GTK_SIDE_TOP"));
   std::string anchor(ch.getString("anchor","GTK_ANCHOR_CENTER"));

   std::string options("0");
   if (ch.getBool("expand",false)) options+="|GTK_EXPAND";
   if (ch.getBool("xfill",false)) options+="|GTK_FILL_X";
   if (ch.getBool("yfill",false)) options+="|GTK_FILL_Y";
   // strip leading '0|'
   if (options.size()>1) options=std::string(options.begin()+2,options.end());
   
   bool use_default(ch.getBool("use_default",true)); // ???
   if (!use_default)
   {  f.Statement() << instance << "add(" 
        << Reference(w) << ", " << side << ", " << anchor 
        << ", " << options << ", " << border_width << ", " 
        << pad_x << ", " << pad_y << ", " << i_pad_x << ", " << i_pad_y << ')';
   }
   else // just a guess
   {  f.Statement() << instance << "add(" 
        << Reference(w) << ", " << side << ", " << anchor  
        << ", " << options << ')';
   }
}

void Gtk_Packer::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   int default_border_width(w.getInt("default_border_width",0));
   if (default_border_width)
      f.Statement() << instance << "set_default_border_width(" << default_border_width << ')';
   int default_pad_x(w.getInt("default_pad_x",0));
   int default_pad_y(w.getInt("default_pad_y",0));
   if (default_pad_x || default_pad_y)
      f.Statement() << instance << "set_default_pad(" << default_pad_x << ", "
      		<< default_pad_y << ')';
   int default_ipad_x(w.getInt("default_ipad_x",0));
   int default_ipad_y(w.getInt("default_ipad_y",0));
   if (default_ipad_x || default_ipad_y)
      f.Statement() << instance << "set_default_ipad(" << default_ipad_x << ", "
      		<< default_ipad_y << ')';
}

