// $Id: checkmenuitem.cc,v 1.24 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "checkmenuitem.hh"

static Gtk_CheckMenuItem Gtk_CheckMenuItem(false);

const std::string Gtk_CheckMenuItem::TypeName(const Widget &w) const
{  return GtkPrefix()+"CheckMenuItem";
}

const std::string Gtk_CheckMenuItem::IncludeName(const Widget &w) const
{  return "gtk--/checkmenuitem.h";
}

Gtk_CheckMenuItem::Gtk_CheckMenuItem(bool base_class_init)
{  if (!base_class_init) Writer["GtkCheckMenuItem"]=this;
}

bool Gtk_CheckMenuItem::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char *prefix("gtk_check_menu_item_");
   const int plen(sizeof(prefix)-1);
   if (!strncmp(prefix,method.c_str(),plen))
      method=std::string(method.c_str()+plen);
   if ((method=="set_show_toggle" && matches("bool\\ \\_",args))
        || (method=="set_active" && matches("bool\\ \\_",args)))
// not in 1.2!       || (method=="set_state" && matches("bool\\ \\_",args)))
   {  scope=Gtk_CheckMenuItem::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

