// $Id: WriterBase.hh,v 1.43 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef WRITER_BASE_HH
#define WRITER_BASE_HH
#include <safemap.hh>
#include <string>
#include "../Enums.hh"
// these are not necessary for all widgets, 
// but it's convenient to have them defined
#include "../Widget.hh"
#include "../SourceWriter/CxxFile.hh"
#include "../Configuration.hh"

class WriterBase
{public:
	//----------------- foo_glade.hh -----------------------
	virtual void GHInclude(const Widget &w, CxxFile &f) const;
		// "#include ..."
	// test if necessary, then call !!!
	virtual void GHDeclaration(const Widget &w, CxxFile &f) const;
		// "Foo foo;"
	// declare additional needed members (e.g. Widgets)
	virtual void AdditionalMemberVars(const Widget &w, CxxFile &f,bool container=false) const;
	virtual void Derivation(const Widget &w, CxxFile &f) const;
		// ": Gtk_Box"
	// not used, yet
	virtual bool NeedDtor(const Widget &w) const
	{  return false; }
	
	//----------------- foo_glade.cc ------------------------
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual void GCDefinition(const Widget &w, CxxFile &f) const {}
		// usually empty, own classes, own functions
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }	// usually true
	virtual void ParentConstruction(const Widget &w, CxxFile &f) const;
		// u.h.b.G., usually Foo() or empty
	virtual void MemberConstruction(const Widget &w, CxxFile &f) const;
		// u.h.b.G., "foo(2)"
//	virtual void Constructor(const Widget &w, CxxFile &f,const std::string &instance) const
//	{}	// e.g. create children goes to create pointer
	virtual void Configure(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void Configure_show(const Widget &w,CxxFile &f,const std::string &instance) const
	{}
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const
	{}
	virtual void ClassConstructor(const Widget &w, CxxFile &f) const;
		// initialization of variables (only called for toplevel widget)
	virtual void Destructor(const Widget &w, CxxFile &f) const;
		// usually some "delete foo_help;"
	virtual void ClassDestructor(const Widget &w, CxxFile &f) const
	{}	// destruction of variables (only called for toplevel widget)
	virtual void CreatePointer(const Widget &w,CxxFile &f) const;
	virtual void CreatePointer_Toplevel(const Widget &w,CxxFile &f) const
	{}
	virtual void DestroyPointer(const Widget &w,CxxFile &f) const;
	virtual void DestroyPointer_Toplevel(const Widget &w,CxxFile &f) const
	{}
	// don't forget to configure internal widgets!
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
		
	//----------------- foo.hh (user classes) ----------------
	virtual void HInclude(const Widget &w, CxxFile &f) const {}
	virtual void HDeclaration(const Widget &w, CxxFile &f) const {}
	virtual void UserMember(const Widget &w, CxxFile &f) const {}
		// i.e. signals go here, sample code
	virtual void UserCtorArgs(const Widget &w, CxxFile &f) const {}
	virtual bool needUserDtor(const Widget &w) const 
	{ return false; }
	
	//---------------- foo.cc ---------------------------------
	/// include files for user's file
	virtual void CInclude(const Widget &w, CxxFile &f) const {}
	virtual void CDefinition(const Widget &w, CxxFile &f) const {}
	virtual void UserParentConstruction(const Widget &w, CxxFile &f) const {}
	virtual void UserMemberConstruction(const Widget &w, CxxFile &f) const {}
	virtual void UserConstructor(const Widget &w, CxxFile &f,const std::string &instance) const {}
	virtual void UserDestructor(const Widget &w, CxxFile &f,const std::string &instance) const {}
	
	//----------------- misc internal -------------------------
	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const
	{  return no_Subwidgets; }
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const
	{  return ""; }
	/// whether this Method is already defined (e.g. Gtk_Widget::show())
	// this function will modify method if applicable (Gtk'ish-name)
	// 	e.g. gtk_widget_show
	// this function will modify scope if an internal method is found
	//	e.g. Gtk_Entry => Gtk_Widget
	// this is needed for gtkmm-1.0's connect_to_method
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
	{  return false; }
	bool isInternalMethod(const std::string &prefix, const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;
#ifdef NEED_CONSTRUCT_ARGS	
	// Arguments to constructor
	virtual void ConstructorArgs(const Widget &w, CxxFile &f) const {}
#endif	
	virtual bool needDataArg(const Widget &w) const
	{  return true; }
	virtual const std::string Instance(const Widget &parent,const Widget &w2,Subwidget sw=SW_Unknown) const;
	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const
	{  return ""; }
	virtual bool CanBeManaged(const Widget &w) const
	{  return true; }
	
	//----------------- changing widget's tags ----------------------
	/// this indicates that this widget has to be contructed via
	// CreatePointer 
	virtual bool CantMemberConstruct(const Widget &w) const
	{  return false; }
	/// modify Preferences and widget tags for consistency
	virtual void ApplyPreferences(Tag &t) const;
	
	//----------------- used by various internal routines -------------
	// e.g. Gtk_Widget
	virtual const std::string TypeName(const Widget &w) const	= 0;
	// e.g. GtkWidget
	virtual const std::string GtkName(const Widget &w) const;
	// e.g. GTK_WIDGET
	virtual const std::string GtkCast(const Widget &w) const;
	// e.g. gtk--/widget.h
	virtual const std::string IncludeName(const Widget &w) const	= 0;
	
	//----------- convenience functions ---------------------
	static const std::string Pointer(const Widget &w)
	{  return Configuration.InstanceName(w.Name());
	}
	
	static const std::string Reference(const std::string &instance);
	// old function, use by above one if possible
	static const std::string Reference(const Widget &w)
	{  return "*"+Pointer(w);
	}
	
	static const std::string GtkPrefix()
	{  if (Configuration.gtkmm_version<Gtkmm_Version(1,1,5))
	      return "Gtk_";
	   return "Gtk::";
	}
	static const std::string GnomePrefix()
	{  if (Configuration.gtkmm_version<Gtkmm_Version(1,1,5))
	      return "Gnome_";
	   return "Gnome::";
	}
	
	// strange things ... do we really need these any longer ?
	static const std::string instance(const Widget &w)
	{  // if (w.getBool(CXX_SEPERATE_CLASS)) return ""; /* this->"; */
	   return Configuration.InstanceName(w.Name())+"->";
	}
	static const std::string instance_pointer(const Widget &w)
	{  // if (w.getBool(CXX_SEPERATE_CLASS)) return "this";
	   return Pointer(w);
	}
	static const std::string instance_reference(const Widget &w)
	{  // if (w.getBool(CXX_SEPERATE_CLASS)) return "(*this)";
	   return Reference(w);
	}
	
	static bool matches(const std::string &pattern, const std::string &s);
private:
	void GHDeclaration(const Widget &w, CxxFile &f,bool pointer) const;
};

#define PRINT_BOOL(b) ((b)?"true":"false")

extern safemap<std::string,const WriterBase *> Writer;

// containing will give you 'Class' instead of 'GtkXyz' if appropriate
const WriterBase &LookupWriter(const Widget &w,bool containing=false);
// seperate_entity selects 'Class'
const WriterBase &LookupWriter(const std::string &type,bool seperate_entity=false);
#endif
