// $Id: Widget.hh,v 1.35 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef WIDGET_HH
#define WIDGET_HH
#include <config.h>
#include "Enums.hh"
#include "Tag.hh"
#include <iterator>
#include <list>
#include "Widget_type.hh"
#include "ChildParamList.hh"

// Widget is a Tag handle class with convenience additions for widget
// handling. Constructing a Widget from an Tag is very fast, so remembering
// only Tag* has no penalty (up to now).

// Due to C++'s limits we can't include a widget in one of its iterators ...
// so we use Tag*                       [or Tag& - do we?]

// we might protect tag against modification if passed by a const
// constructor.

// WARNING: Tag's lifetime must exceed its derived Widget's !!!!
// and of course a containers lifetime should exceed it's iterators' lifetime
// WARNING2: since we use 'ti=Widget(parent).begin();' 
//  Widget's iterators must not rely on Widget's existance
// => Tags must live longer than Widget's iterators 

// I hate this nonsense, perhaps another reorganization should address this

class Widget
{  	Tag *tag;
	mutable std::string name;
	bool is_const;
	
	void test4validity()
	{  
	   assert(tag->Type()=="widget" /* && tag->Value()==""*/);
	}
	void obselete(const char *x)
	{
	   std::cout << "Widget: obselete member function "<<x<<" called\n";
	}
public:
	// internal use
	Widget(Tag *t) throw() : tag(t), name(""), is_const(false)
	{ test4validity(); }
	// obselete
	Widget(const Tag *t) throw() : tag((Tag*)t), name(""), is_const(true)
	{ test4validity(); obselete(__FUNCTION__); }
	// recommended, be careful to not pass a temporary
	Widget(const Tag &t) throw() : tag((Tag*)&t), name(""), is_const(true)
	{ test4validity(); }
	// obselete
	Widget(const Tag *t,const std::string &_name) throw() 
		: tag((Tag*)t), name(_name), is_const(true)
	{ test4validity(); obselete(__FUNCTION__); }
	// recommended, be careful to not pass a temporary
	Widget(const Tag &t,const std::string &_name) throw() 
		: tag((Tag*)&t), name(_name), is_const(true)
	{ test4validity(); }
	Widget(const Widget &w,const std::string &_name) throw() 
		: tag(w.tag), name(_name), is_const(w.is_const)
	{ test4validity(); }

	const Tag *getTagPtr() const { return tag; }
	const Tag &getTag() const { return *tag; }
	bool operator==(const Widget &w) const { return tag==w.tag; }
	const std::string Class() const throw()
	{  return tag->getString("class",""); }
	const std::string ChildName() const throw()
	{  return tag->getString("child_name",""); }
	// const is not always true
	const std::string Name() const throw(); 
	Subwidget subwidgettype(const Widget &w) const throw();
	
	std::vector<std::string> Dependancies() const throw();
	bool hasTag(const std::string &t) const throw()
	{  return tag->hasTag(t); }
	bool hasChildren() const throw()
	{  return tag->hasTag("widget"); }
	void debug() const throw()
	{  tag->debug(); }
	
	void mark(const std::string &tg) throw()
	{  assert(!is_const);
	   tag->mark(tg,"true"); }
	void mark(const std::string &tg,const std::string &value) throw()
	{  assert(!is_const);
	   tag->mark(tg,value); }
	   
	bool isSeperateClass() const throw()
	{  return tag->getBool(CXX_SEPERATE_CLASS); }
	bool wasWrapped() const throw()
	{  return tag->getBool(CXX_IS_MANAGED,false); }
	void markManaged() const throw() 
		// this is not const ... but I don't want to rewrite the
		// writers yet
	{  const_cast<Tag*>(tag)->mark(CXX_IS_MANAGED,"true"); }
	
	const ChildParamList get_Child_params() const throw();
	
	const std::string getString(const std::string &t,const std::string &def="") const throw()
	{  return tag->getString(t,def); }
	bool getBool(const std::string &t,const bool def=false) const throw()
	{  return tag->getBool(t,def); } 
	int getInt(const std::string &t,const int def=-1) const throw()
	{  return tag->getInt(t,def); }
	float getFloat(const std::string &t,const float def=0) const throw()
	{  return tag->getFloat(t,def); }
	
	// new functions:
	// - find internal subwidget by name

        // to get this class more compact
#include "Widget_iterators.hh"

	const_iterator begin() const 
	{  return const_iterator(find(tag->begin(),tag->end(),"widget"),tag->end());
	}
	const_iterator end() const
	{  return const_iterator(tag->end(),tag->end()); }
	iterator begin()
	{  assert(!is_const); // too hard?
	   return iterator(find(tag->begin(),tag->end(),"widget"),tag->end());
	}
	iterator end()
	{  assert(!is_const); // too hard?
	   return iterator(tag->end(),tag->end()); }

	const_iterator get_Signals() const throw()
	{  
#if 0 // compatibility with some ancient (pre 0.5?) glade
	   if (hasTag("Signal"))
	      return const_iterator(find(tag->begin(),tag->end(),"Signal"),tag->end(),"Signal");
#endif	      
	   return const_iterator(find(tag->begin(),tag->end(),"signal"),tag->end(),"signal");
	}
	
	const_iterator get_Accels() const throw()
	{  return const_iterator(find(tag->begin(),tag->end(),"accelerator"),tag->end(),"accelerator");
	}
	
	const_contained_iterator begin_contained(InternalSelection _internal=NoInternal,bool debug=false) const
	{  const_contained_iterator it(find(tag->begin(),tag->end(),"widget"),tag,_internal,debug);
	   return it;
	}
	const_contained_iterator end_contained() const
	{  return const_contained_iterator(tag->end(),tag,NoInternal);
	}
};

#endif
