/*
 * if_freebsd.c
 *
 * GKrellM LongRun Plugin
 * Copyright (c) 2001 Masaharu FUJITA
 *
 * Initial work by: (c) 2001 Nozomi Sato (nozomi@palette.plala.or.jp)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * You may contact the author by:
 *	e-mail: m@fjts.org
 *	url: http://fjts.org/~m/Soft/GKrelLongRun/ (in Japanese)
 *	     http://fjts.org/~m/Soft/GKrelLongRun/index_e.html (in English)
 *
 */

#include <gkrellm/gkrellm.h>
#include <sys/sysctl.h>

#include "interface.h"

#define SETMODECMD "/usr/X11R6/libexec/gkrellm/gkrellongrunctl "

#define LONGRUN_MODE_MINFREQUENCY	0x00
#define LONGRUN_MODE_ECONOMY		0x01
#define LONGRUN_MODE_PERFORMANCE	0x02
#define LONGRUN_MODE_MAXFREQUENCY	0x03
#define LONGRUN_MODE_UNKNOWN		0x04
#define LONGRUN_MODE_MAX		0x04

gchar *longrun_mode_label[] = { "Min.", "Eco.", "Per.", "Max." };

static int	oid[CTL_MAXNAME + 2][4];
static size_t	oid_len[] = { CTL_MAXNAME + 2, CTL_MAXNAME + 2,
			      CTL_MAXNAME + 2, CTL_MAXNAME + 2 };

#ifndef HAVE_SYSCTLNAMETOMIB
static int
sysctlnametomib(const char *name, int *mibp, size_t *sizep)
{
	static int oid[2] = { 0, 3 };
	int error;

	*sizep *= sizeof(int);
	error = sysctl(oid, 2, mibp, sizep, name, strlen(name));
	*sizep /= sizeof(int);
	if (error < 0) 
		return (error);
	return (0);
}
#endif

int
check_cpu()
{
	gint i;
	static char *name[] = {
		"hw.crusoe.longrun",
		"hw.crusoe.frequency",
		"hw.crusoe.voltage",
		"hw.crusoe.percentage"
	};

	/* Check Longrun. And set oid and oid_len (for sysctl()). */
	for (i = 0; i < LongRunDataTypeNum ; ++i) {
		if (sysctlnametomib((void *)name[i],
				    oid[i], &oid_len[i]) < 0)
			return -1;
	}

	return 0;
}

void
read_longrun_data()
{
	size_t size;
	gint i;

	for (i = 0; i < LongRunDataTypeNum ; ++i) {
		size = sizeof(longrun.data[i]);
		if (sysctl(oid[i], oid_len[i], &longrun.data[i], &size,
				NULL, 0) < 0)
			return;
	}

	set_longrun_label();
}

static void
set_longrun_mode(GtkWidget *widget, gpointer data)
{
	gchar *cmd;

	cmd = g_strdup_printf("%s %d", SETMODECMD, GPOINTER_TO_INT(data));
	system(cmd);

	g_free(cmd);
}

GtkItemFactoryEntry gkrellongrun_factory_entry[] =
{
	{"/-", NULL, NULL, 0,"<Separator>"},
	{"/Mini-frequency", NULL, set_longrun_mode,
		LONGRUN_MODE_MINFREQUENCY, "<Item>"},
	{"/Economy", NULL, set_longrun_mode,
		LONGRUN_MODE_ECONOMY, "<Item>"},
	{"/Performance", NULL, set_longrun_mode,
		LONGRUN_MODE_PERFORMANCE, "<Item>"},
	{"/Max-frequency", NULL, set_longrun_mode,
		LONGRUN_MODE_MAXFREQUENCY, "<Item>"},
	{"/-", NULL, NULL, 0,"<Separator>"},
};

/*
 * get_gkrellongrun_itemfactory_size
 */
int
get_gkrellongrun_itemfactory_size()
{
	return sizeof(gkrellongrun_factory_entry)/sizeof(GtkItemFactoryEntry);
}
