/* GKrellM Sound Scope
|  Copyright (C) 2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gkrellm/gkrellm.h>

#include <esd.h>

#if  !defined(GKRELLM_VERSION_MAJOR) \
	|| (GKRELLM_VERSION_MAJOR==1 && GKRELLM_VERSION_MINOR==0) \
	|| (GKRELLM_VERSION_MAJOR==1 && GKRELLM_VERSION_MINOR==2 \
		&& GKRELLM_VERSION_REV<2)
#error This GKrellMSS plugin requires GKrellM version >= 1.2.2
#endif


#define	GKRELLMSS_VERSION_MAJOR	0
#define	GKRELLMSS_VERSION_MINOR	3


#define	SAMPLE_RATE	44100
#define	N_SAMPLES	2048

#define	HORIZONTAL_DIVS	5
#define	VERTICAL_DIVS	4

#define	CHANNEL_L	0
#define	CHANNEL_R	1
#define	CHANNEL_LR	2


typedef enum
	{
	Error,
	Standby,
	AutoStandby,
	Running,
	Unavailable
	}
	SoundStatus;

typedef struct
	{
	short		left,
				right;
	}
SoundSample;

typedef struct
	{
	Krell		*krell_left_peak,
				*krell_right_peak,
				*krell_left,
				*krell_right,
				*krell_sensitivity;

	gint
				left_value,
				right_value,
				left_peak_value,
				right_peak_value;

	gint		vu_x0,
				x_sensitivity_raw,
				krell_sensitivity_y,
				krell_sensitivity_y_target,
				krell_sensitivity_y_up,
				krell_sensitivity_y_dn;

	gchar		*host;
	gint		fd;
	gint		input_id;
	gboolean	streaming;
	SoundStatus	status;

	gint		buf_count;
	gint		buf_len;
	gint		buf_index;
	SoundSample *buffer;
	}
SoundMonitor;

extern SoundMonitor	*sound;


typedef struct
	{
	gint		usec_per_div,
				vert_max,
				dx_per_point;
	gboolean	dirty;
	gfloat		vert_sensitivity;
	gfloat		vert_trigger;
	gfloat		t_sample,
				t_trace,
				samples_per_point;
	gint		x_append,
				y_append;
	GdkGC		*gc;
	}
Oscope;

extern Chart	*chart;
extern Oscope	*oscope;

extern SoundStatus	sound_status(gchar *);
extern void			sound_open_stream(gchar *);
extern void			sound_close_stream(void);
extern void			oscope_trace(gint);
