#ifndef _DEFINES_
#define _DEFINES_

#include "../config.h"

/* Gettext */
#include <libintl.h>
#define _(String) gettext (String)
#define gettext_noop(String) (String)
#ifndef HAVE_GNOME
#define N_(String) gettext_noop (String)
#endif
/* Gettext */

#define OPTIONS_DIR "/etc/ppp/peers/"
#define CHAT_DIR "/etc/chatscripts/"
#define PAP_SECRETS "/etc/ppp/pap-secrets"
#define CHAP_SECRETS "/etc/ppp/chap-secrets"

#define UPCMD "/usr/sbin/pppd call "
#define DOWNCMD "/usr/bin/killall pppd"
#define PEERS_DIR "/etc/ppp/peers"

#define LOCK_DEFAULT "/var/run/ppp0.pid"

/* Connection status */
#define CONNECTED 1
#define DISCONNECTED 2
#define CONNECTING 3
#define DISCONNECTING 4

/* for use with handling the pixmap */
#define PIX_ON 1
#define PIX_WAITING 2
#define PIX_OFF 3

#define MODEM_DEFAULT "/dev/modem"

/* timeouts for the gtk_timeouts set */
#define CHK_TIMEOUT 1000 /* check_connection */
#define CNT_TIMEOUT 47000 /* connecting_check */

#endif
