#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <gtk/gtk.h>

#include "defines.h"
#include "actions.h"
#include "add.h"
#include "gui.h"

#define WRITE_CONF_ERROR \
_("Error opening file...\n"\
"Are you root?\n"\
"Only root is supposed to add new peers... ")

void write_callback (GtkWidget *widget, gpointer main_combo)
{
  struct peer connect_to; /* Struct to a configured conection */
    
  connect_to.name = gtk_entry_get_text (GTK_ENTRY(text_entry_name));
  connect_to.phone = gtk_entry_get_text (GTK_ENTRY(text_entry_phone));
  connect_to.username = gtk_entry_get_text (GTK_ENTRY(text_entry_username));
  connect_to.password = gtk_entry_get_text (GTK_ENTRY(text_entry_password));
  connect_to.connection_type = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(combo_conf)->entry));

  write_conf (connect_to);

  combo_insert_options (main_combo); /* Insert options to the combo box */
}

/*
  Writes configuration to add new connection
*/
int write_conf (struct peer connect_to)
{
  FILE *options;
  FILE *chat_script;
  FILE *secrets;

  char options_name[100] = OPTIONS_DIR;
  char chat_script_name[100] = CHAT_DIR;
  char secrets_file[100];

  strcat(options_name, connect_to.name);
  strcat(chat_script_name, connect_to.name);

  options = fopen(options_name, "w");
  if (options == NULL)
    {    
      gk_diag (WRITE_CONF_ERROR);
      return 1; 
    }
  /* First we write the common things...*/
  fprintf (options, 
	   "noauth\n"
	   "connect \"/usr/sbin/chat -v -f /etc/chatscripts/%s\"\n"
	   "%s\n"
	   "115200\n"
	   "defaultroute\n"
	   "noipdefault\n"
	   "user %s\n"
	   "usepeerdns\n",
	   connect_to.name, modem_tty, connect_to.username);
  fclose(options);

  chat_script = fopen(chat_script_name, "w");
  if (chat_script == NULL)
    {  
            gk_diag (WRITE_CONF_ERROR);
	    return 1;
    }
  fprintf (chat_script, 
	   "ABORT RING\n"
	   "ABORT BUSY\n"
	   "ABORT \"NO CARRIER\"\n"
	   "ABORT VOICE\n"
	   "ABORT \"NO DIALTONE\"\n"
	   "ABORT \"NO ANSWER\"\n"
	   "\"\" ATZ\n"
	   "OK ATDT%s\n"
	   "CONNECT \\d\\c\n",
	   connect_to.phone);

  if (connect_to.connection_type[0] == 'C' && \
	   connect_to.connection_type[3] == 'T')
    { /* CHAT */
      fprintf (chat_script,
	       "ogin: %s\n"\
	       "ssword: \\q%s\n",
	       connect_to.username, connect_to.password);
    }
  else
    {
      if (connect_to.connection_type[0] == 'P')
	strncpy (secrets_file, PAP_SECRETS, 100); /* PAP */

      else if (connect_to.connection_type[0] == 'C' && \
	       connect_to.connection_type[3] == 'P')
	strncpy (secrets_file, CHAP_SECRETS, 100); /* CHAP */
      else
	return 1;

      secrets = fopen(secrets_file, "a+");
      if (secrets == NULL)
	{  
	  gk_diag (WRITE_CONF_ERROR);
	  return 1; 
	}
      
      /* Makes sure that we don't get a line
	 included just after another without 
	 a newline
      */
      {
	char c;
	long pos;

	pos = ftell (secrets);
	fseek (secrets, pos-1, SEEK_SET);
	c = fgetc(secrets);
	fseek (secrets, pos, SEEK_SET);

	printf ("c: %c\n", c);

	if ( c != '\n')
	  fprintf (secrets, "\n");
      }
      fprintf (secrets,
	       "%s * %s *  ## GKDIAL: %s ## ",
	       connect_to.username, connect_to.password, connect_to.name);
      fprintf (secrets,  _("Do not remove/edit this comment\n")); // to allow i18n
      fclose (secrets);
    }

  fclose(chat_script);

  return 0;
}
