// Code generated by protoc-gen-go. DO NOT EDIT.
// source: operations.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type UserCommitFilesActionHeader_ActionType int32

const (
	UserCommitFilesActionHeader_CREATE     UserCommitFilesActionHeader_ActionType = 0
	UserCommitFilesActionHeader_CREATE_DIR UserCommitFilesActionHeader_ActionType = 1
	UserCommitFilesActionHeader_UPDATE     UserCommitFilesActionHeader_ActionType = 2
	UserCommitFilesActionHeader_MOVE       UserCommitFilesActionHeader_ActionType = 3
	UserCommitFilesActionHeader_DELETE     UserCommitFilesActionHeader_ActionType = 4
)

var UserCommitFilesActionHeader_ActionType_name = map[int32]string{
	0: "CREATE",
	1: "CREATE_DIR",
	2: "UPDATE",
	3: "MOVE",
	4: "DELETE",
}
var UserCommitFilesActionHeader_ActionType_value = map[string]int32{
	"CREATE":     0,
	"CREATE_DIR": 1,
	"UPDATE":     2,
	"MOVE":       3,
	"DELETE":     4,
}

func (x UserCommitFilesActionHeader_ActionType) String() string {
	return proto.EnumName(UserCommitFilesActionHeader_ActionType_name, int32(x))
}
func (UserCommitFilesActionHeader_ActionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor7, []int{19, 0}
}

type UserCreateBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	BranchName []byte      `protobuf:"bytes,2,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	User       *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	StartPoint []byte      `protobuf:"bytes,4,opt,name=start_point,json=startPoint,proto3" json:"start_point,omitempty"`
}

func (m *UserCreateBranchRequest) Reset()                    { *m = UserCreateBranchRequest{} }
func (m *UserCreateBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCreateBranchRequest) ProtoMessage()               {}
func (*UserCreateBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

func (m *UserCreateBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCreateBranchRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserCreateBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCreateBranchRequest) GetStartPoint() []byte {
	if m != nil {
		return m.StartPoint
	}
	return nil
}

type UserCreateBranchResponse struct {
	Branch *Branch `protobuf:"bytes,1,opt,name=branch" json:"branch,omitempty"`
	// Error returned by the pre-receive hook. If no error was thrown,
	// it's the empty string ("")
	PreReceiveError string `protobuf:"bytes,2,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCreateBranchResponse) Reset()                    { *m = UserCreateBranchResponse{} }
func (m *UserCreateBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCreateBranchResponse) ProtoMessage()               {}
func (*UserCreateBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{1} }

func (m *UserCreateBranchResponse) GetBranch() *Branch {
	if m != nil {
		return m.Branch
	}
	return nil
}

func (m *UserCreateBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserUpdateBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	BranchName []byte      `protobuf:"bytes,2,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	User       *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Newrev     []byte      `protobuf:"bytes,4,opt,name=newrev,proto3" json:"newrev,omitempty"`
	Oldrev     []byte      `protobuf:"bytes,5,opt,name=oldrev,proto3" json:"oldrev,omitempty"`
}

func (m *UserUpdateBranchRequest) Reset()                    { *m = UserUpdateBranchRequest{} }
func (m *UserUpdateBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserUpdateBranchRequest) ProtoMessage()               {}
func (*UserUpdateBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{2} }

func (m *UserUpdateBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserUpdateBranchRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserUpdateBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserUpdateBranchRequest) GetNewrev() []byte {
	if m != nil {
		return m.Newrev
	}
	return nil
}

func (m *UserUpdateBranchRequest) GetOldrev() []byte {
	if m != nil {
		return m.Oldrev
	}
	return nil
}

type UserUpdateBranchResponse struct {
	PreReceiveError string `protobuf:"bytes,1,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserUpdateBranchResponse) Reset()                    { *m = UserUpdateBranchResponse{} }
func (m *UserUpdateBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserUpdateBranchResponse) ProtoMessage()               {}
func (*UserUpdateBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{3} }

func (m *UserUpdateBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserDeleteBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	BranchName []byte      `protobuf:"bytes,2,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	User       *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
}

func (m *UserDeleteBranchRequest) Reset()                    { *m = UserDeleteBranchRequest{} }
func (m *UserDeleteBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteBranchRequest) ProtoMessage()               {}
func (*UserDeleteBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{4} }

func (m *UserDeleteBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserDeleteBranchRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserDeleteBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type UserDeleteBranchResponse struct {
	PreReceiveError string `protobuf:"bytes,1,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserDeleteBranchResponse) Reset()                    { *m = UserDeleteBranchResponse{} }
func (m *UserDeleteBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteBranchResponse) ProtoMessage()               {}
func (*UserDeleteBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{5} }

func (m *UserDeleteBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserDeleteTagRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	TagName    []byte      `protobuf:"bytes,2,opt,name=tag_name,json=tagName,proto3" json:"tag_name,omitempty"`
	User       *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
}

func (m *UserDeleteTagRequest) Reset()                    { *m = UserDeleteTagRequest{} }
func (m *UserDeleteTagRequest) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteTagRequest) ProtoMessage()               {}
func (*UserDeleteTagRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{6} }

func (m *UserDeleteTagRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserDeleteTagRequest) GetTagName() []byte {
	if m != nil {
		return m.TagName
	}
	return nil
}

func (m *UserDeleteTagRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type UserDeleteTagResponse struct {
	PreReceiveError string `protobuf:"bytes,1,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserDeleteTagResponse) Reset()                    { *m = UserDeleteTagResponse{} }
func (m *UserDeleteTagResponse) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteTagResponse) ProtoMessage()               {}
func (*UserDeleteTagResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{7} }

func (m *UserDeleteTagResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserCreateTagRequest struct {
	Repository     *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	TagName        []byte      `protobuf:"bytes,2,opt,name=tag_name,json=tagName,proto3" json:"tag_name,omitempty"`
	User           *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	TargetRevision []byte      `protobuf:"bytes,4,opt,name=target_revision,json=targetRevision,proto3" json:"target_revision,omitempty"`
	Message        []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *UserCreateTagRequest) Reset()                    { *m = UserCreateTagRequest{} }
func (m *UserCreateTagRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCreateTagRequest) ProtoMessage()               {}
func (*UserCreateTagRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{8} }

func (m *UserCreateTagRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCreateTagRequest) GetTagName() []byte {
	if m != nil {
		return m.TagName
	}
	return nil
}

func (m *UserCreateTagRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCreateTagRequest) GetTargetRevision() []byte {
	if m != nil {
		return m.TargetRevision
	}
	return nil
}

func (m *UserCreateTagRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

type UserCreateTagResponse struct {
	Tag             *Tag   `protobuf:"bytes,1,opt,name=tag" json:"tag,omitempty"`
	Exists          bool   `protobuf:"varint,2,opt,name=exists" json:"exists,omitempty"`
	PreReceiveError string `protobuf:"bytes,3,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCreateTagResponse) Reset()                    { *m = UserCreateTagResponse{} }
func (m *UserCreateTagResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCreateTagResponse) ProtoMessage()               {}
func (*UserCreateTagResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{9} }

func (m *UserCreateTagResponse) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *UserCreateTagResponse) GetExists() bool {
	if m != nil {
		return m.Exists
	}
	return false
}

func (m *UserCreateTagResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserMergeBranchRequest struct {
	// First message
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User       *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	CommitId   string      `protobuf:"bytes,3,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	Branch     []byte      `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
	Message    []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// Second message
	// Tell the server to apply the merge to the branch
	Apply bool `protobuf:"varint,6,opt,name=apply" json:"apply,omitempty"`
}

func (m *UserMergeBranchRequest) Reset()                    { *m = UserMergeBranchRequest{} }
func (m *UserMergeBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserMergeBranchRequest) ProtoMessage()               {}
func (*UserMergeBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{10} }

func (m *UserMergeBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserMergeBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserMergeBranchRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *UserMergeBranchRequest) GetBranch() []byte {
	if m != nil {
		return m.Branch
	}
	return nil
}

func (m *UserMergeBranchRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *UserMergeBranchRequest) GetApply() bool {
	if m != nil {
		return m.Apply
	}
	return false
}

type UserMergeBranchResponse struct {
	// First message
	// The merge commit the branch will be updated to. The caller can still abort the merge.
	CommitId string `protobuf:"bytes,1,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Second message
	// If set, the merge has been applied to the branch.
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,3,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,4,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserMergeBranchResponse) Reset()                    { *m = UserMergeBranchResponse{} }
func (m *UserMergeBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserMergeBranchResponse) ProtoMessage()               {}
func (*UserMergeBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{11} }

func (m *UserMergeBranchResponse) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *UserMergeBranchResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserMergeBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type OperationBranchUpdate struct {
	// If this string is non-empty the branch has been updated.
	CommitId string `protobuf:"bytes,1,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Used for cache invalidation in GitLab
	RepoCreated bool `protobuf:"varint,2,opt,name=repo_created,json=repoCreated" json:"repo_created,omitempty"`
	// Used for cache invalidation in GitLab
	BranchCreated bool `protobuf:"varint,3,opt,name=branch_created,json=branchCreated" json:"branch_created,omitempty"`
}

func (m *OperationBranchUpdate) Reset()                    { *m = OperationBranchUpdate{} }
func (m *OperationBranchUpdate) String() string            { return proto.CompactTextString(m) }
func (*OperationBranchUpdate) ProtoMessage()               {}
func (*OperationBranchUpdate) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{12} }

func (m *OperationBranchUpdate) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *OperationBranchUpdate) GetRepoCreated() bool {
	if m != nil {
		return m.RepoCreated
	}
	return false
}

func (m *OperationBranchUpdate) GetBranchCreated() bool {
	if m != nil {
		return m.BranchCreated
	}
	return false
}

type UserFFBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User       *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	CommitId   string      `protobuf:"bytes,3,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	Branch     []byte      `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
}

func (m *UserFFBranchRequest) Reset()                    { *m = UserFFBranchRequest{} }
func (m *UserFFBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserFFBranchRequest) ProtoMessage()               {}
func (*UserFFBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{13} }

func (m *UserFFBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserFFBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserFFBranchRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *UserFFBranchRequest) GetBranch() []byte {
	if m != nil {
		return m.Branch
	}
	return nil
}

type UserFFBranchResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,2,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserFFBranchResponse) Reset()                    { *m = UserFFBranchResponse{} }
func (m *UserFFBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserFFBranchResponse) ProtoMessage()               {}
func (*UserFFBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{14} }

func (m *UserFFBranchResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserFFBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserCherryPickRequest struct {
	Repository      *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User            *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	Commit          *GitCommit  `protobuf:"bytes,3,opt,name=commit" json:"commit,omitempty"`
	BranchName      []byte      `protobuf:"bytes,4,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	Message         []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	StartBranchName []byte      `protobuf:"bytes,6,opt,name=start_branch_name,json=startBranchName,proto3" json:"start_branch_name,omitempty"`
	StartRepository *Repository `protobuf:"bytes,7,opt,name=start_repository,json=startRepository" json:"start_repository,omitempty"`
}

func (m *UserCherryPickRequest) Reset()                    { *m = UserCherryPickRequest{} }
func (m *UserCherryPickRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCherryPickRequest) ProtoMessage()               {}
func (*UserCherryPickRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{15} }

func (m *UserCherryPickRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCherryPickRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCherryPickRequest) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func (m *UserCherryPickRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserCherryPickRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *UserCherryPickRequest) GetStartBranchName() []byte {
	if m != nil {
		return m.StartBranchName
	}
	return nil
}

func (m *UserCherryPickRequest) GetStartRepository() *Repository {
	if m != nil {
		return m.StartRepository
	}
	return nil
}

type UserCherryPickResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	CreateTreeError string                 `protobuf:"bytes,2,opt,name=create_tree_error,json=createTreeError" json:"create_tree_error,omitempty"`
	CommitError     string                 `protobuf:"bytes,3,opt,name=commit_error,json=commitError" json:"commit_error,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,4,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCherryPickResponse) Reset()                    { *m = UserCherryPickResponse{} }
func (m *UserCherryPickResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCherryPickResponse) ProtoMessage()               {}
func (*UserCherryPickResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{16} }

func (m *UserCherryPickResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserCherryPickResponse) GetCreateTreeError() string {
	if m != nil {
		return m.CreateTreeError
	}
	return ""
}

func (m *UserCherryPickResponse) GetCommitError() string {
	if m != nil {
		return m.CommitError
	}
	return ""
}

func (m *UserCherryPickResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserRevertRequest struct {
	Repository      *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User            *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	Commit          *GitCommit  `protobuf:"bytes,3,opt,name=commit" json:"commit,omitempty"`
	BranchName      []byte      `protobuf:"bytes,4,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	Message         []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	StartBranchName []byte      `protobuf:"bytes,6,opt,name=start_branch_name,json=startBranchName,proto3" json:"start_branch_name,omitempty"`
	StartRepository *Repository `protobuf:"bytes,7,opt,name=start_repository,json=startRepository" json:"start_repository,omitempty"`
}

func (m *UserRevertRequest) Reset()                    { *m = UserRevertRequest{} }
func (m *UserRevertRequest) String() string            { return proto.CompactTextString(m) }
func (*UserRevertRequest) ProtoMessage()               {}
func (*UserRevertRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{17} }

func (m *UserRevertRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserRevertRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserRevertRequest) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func (m *UserRevertRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserRevertRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *UserRevertRequest) GetStartBranchName() []byte {
	if m != nil {
		return m.StartBranchName
	}
	return nil
}

func (m *UserRevertRequest) GetStartRepository() *Repository {
	if m != nil {
		return m.StartRepository
	}
	return nil
}

type UserRevertResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	CreateTreeError string                 `protobuf:"bytes,2,opt,name=create_tree_error,json=createTreeError" json:"create_tree_error,omitempty"`
	CommitError     string                 `protobuf:"bytes,3,opt,name=commit_error,json=commitError" json:"commit_error,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,4,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserRevertResponse) Reset()                    { *m = UserRevertResponse{} }
func (m *UserRevertResponse) String() string            { return proto.CompactTextString(m) }
func (*UserRevertResponse) ProtoMessage()               {}
func (*UserRevertResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{18} }

func (m *UserRevertResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserRevertResponse) GetCreateTreeError() string {
	if m != nil {
		return m.CreateTreeError
	}
	return ""
}

func (m *UserRevertResponse) GetCommitError() string {
	if m != nil {
		return m.CommitError
	}
	return ""
}

func (m *UserRevertResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserCommitFilesActionHeader struct {
	Action        UserCommitFilesActionHeader_ActionType `protobuf:"varint,1,opt,name=action,enum=gitaly.UserCommitFilesActionHeader_ActionType" json:"action,omitempty"`
	FilePath      []byte                                 `protobuf:"bytes,2,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	PreviousPath  []byte                                 `protobuf:"bytes,3,opt,name=previous_path,json=previousPath,proto3" json:"previous_path,omitempty"`
	Base64Content bool                                   `protobuf:"varint,4,opt,name=base64_content,json=base64Content" json:"base64_content,omitempty"`
}

func (m *UserCommitFilesActionHeader) Reset()                    { *m = UserCommitFilesActionHeader{} }
func (m *UserCommitFilesActionHeader) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesActionHeader) ProtoMessage()               {}
func (*UserCommitFilesActionHeader) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{19} }

func (m *UserCommitFilesActionHeader) GetAction() UserCommitFilesActionHeader_ActionType {
	if m != nil {
		return m.Action
	}
	return UserCommitFilesActionHeader_CREATE
}

func (m *UserCommitFilesActionHeader) GetFilePath() []byte {
	if m != nil {
		return m.FilePath
	}
	return nil
}

func (m *UserCommitFilesActionHeader) GetPreviousPath() []byte {
	if m != nil {
		return m.PreviousPath
	}
	return nil
}

func (m *UserCommitFilesActionHeader) GetBase64Content() bool {
	if m != nil {
		return m.Base64Content
	}
	return false
}

type UserCommitFilesAction struct {
	// Types that are valid to be assigned to UserCommitFilesActionPayload:
	//	*UserCommitFilesAction_Header
	//	*UserCommitFilesAction_Content
	UserCommitFilesActionPayload isUserCommitFilesAction_UserCommitFilesActionPayload `protobuf_oneof:"user_commit_files_action_payload"`
}

func (m *UserCommitFilesAction) Reset()                    { *m = UserCommitFilesAction{} }
func (m *UserCommitFilesAction) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesAction) ProtoMessage()               {}
func (*UserCommitFilesAction) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{20} }

type isUserCommitFilesAction_UserCommitFilesActionPayload interface{ isUserCommitFilesAction_UserCommitFilesActionPayload() }

type UserCommitFilesAction_Header struct {
	Header *UserCommitFilesActionHeader `protobuf:"bytes,1,opt,name=header,oneof"`
}
type UserCommitFilesAction_Content struct {
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*UserCommitFilesAction_Header) isUserCommitFilesAction_UserCommitFilesActionPayload()  {}
func (*UserCommitFilesAction_Content) isUserCommitFilesAction_UserCommitFilesActionPayload() {}

func (m *UserCommitFilesAction) GetUserCommitFilesActionPayload() isUserCommitFilesAction_UserCommitFilesActionPayload {
	if m != nil {
		return m.UserCommitFilesActionPayload
	}
	return nil
}

func (m *UserCommitFilesAction) GetHeader() *UserCommitFilesActionHeader {
	if x, ok := m.GetUserCommitFilesActionPayload().(*UserCommitFilesAction_Header); ok {
		return x.Header
	}
	return nil
}

func (m *UserCommitFilesAction) GetContent() []byte {
	if x, ok := m.GetUserCommitFilesActionPayload().(*UserCommitFilesAction_Content); ok {
		return x.Content
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserCommitFilesAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserCommitFilesAction_OneofMarshaler, _UserCommitFilesAction_OneofUnmarshaler, _UserCommitFilesAction_OneofSizer, []interface{}{
		(*UserCommitFilesAction_Header)(nil),
		(*UserCommitFilesAction_Content)(nil),
	}
}

func _UserCommitFilesAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserCommitFilesAction)
	// user_commit_files_action_payload
	switch x := m.UserCommitFilesActionPayload.(type) {
	case *UserCommitFilesAction_Header:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *UserCommitFilesAction_Content:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Content)
	case nil:
	default:
		return fmt.Errorf("UserCommitFilesAction.UserCommitFilesActionPayload has unexpected type %T", x)
	}
	return nil
}

func _UserCommitFilesAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserCommitFilesAction)
	switch tag {
	case 1: // user_commit_files_action_payload.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserCommitFilesActionHeader)
		err := b.DecodeMessage(msg)
		m.UserCommitFilesActionPayload = &UserCommitFilesAction_Header{msg}
		return true, err
	case 2: // user_commit_files_action_payload.content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.UserCommitFilesActionPayload = &UserCommitFilesAction_Content{x}
		return true, err
	default:
		return false, nil
	}
}

func _UserCommitFilesAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserCommitFilesAction)
	// user_commit_files_action_payload
	switch x := m.UserCommitFilesActionPayload.(type) {
	case *UserCommitFilesAction_Header:
		s := proto.Size(x.Header)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserCommitFilesAction_Content:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Content)))
		n += len(x.Content)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type UserCommitFilesRequestHeader struct {
	Repository        *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User              *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	BranchName        []byte      `protobuf:"bytes,3,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	CommitMessage     []byte      `protobuf:"bytes,4,opt,name=commit_message,json=commitMessage,proto3" json:"commit_message,omitempty"`
	CommitAuthorName  []byte      `protobuf:"bytes,5,opt,name=commit_author_name,json=commitAuthorName,proto3" json:"commit_author_name,omitempty"`
	CommitAuthorEmail []byte      `protobuf:"bytes,6,opt,name=commit_author_email,json=commitAuthorEmail,proto3" json:"commit_author_email,omitempty"`
	StartBranchName   []byte      `protobuf:"bytes,7,opt,name=start_branch_name,json=startBranchName,proto3" json:"start_branch_name,omitempty"`
	StartRepository   *Repository `protobuf:"bytes,8,opt,name=start_repository,json=startRepository" json:"start_repository,omitempty"`
}

func (m *UserCommitFilesRequestHeader) Reset()                    { *m = UserCommitFilesRequestHeader{} }
func (m *UserCommitFilesRequestHeader) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesRequestHeader) ProtoMessage()               {}
func (*UserCommitFilesRequestHeader) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{21} }

func (m *UserCommitFilesRequestHeader) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetCommitMessage() []byte {
	if m != nil {
		return m.CommitMessage
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetCommitAuthorName() []byte {
	if m != nil {
		return m.CommitAuthorName
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetCommitAuthorEmail() []byte {
	if m != nil {
		return m.CommitAuthorEmail
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetStartBranchName() []byte {
	if m != nil {
		return m.StartBranchName
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetStartRepository() *Repository {
	if m != nil {
		return m.StartRepository
	}
	return nil
}

type UserCommitFilesRequest struct {
	// Types that are valid to be assigned to UserCommitFilesRequestPayload:
	//	*UserCommitFilesRequest_Header
	//	*UserCommitFilesRequest_Action
	UserCommitFilesRequestPayload isUserCommitFilesRequest_UserCommitFilesRequestPayload `protobuf_oneof:"user_commit_files_request_payload"`
}

func (m *UserCommitFilesRequest) Reset()                    { *m = UserCommitFilesRequest{} }
func (m *UserCommitFilesRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesRequest) ProtoMessage()               {}
func (*UserCommitFilesRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{22} }

type isUserCommitFilesRequest_UserCommitFilesRequestPayload interface{ isUserCommitFilesRequest_UserCommitFilesRequestPayload() }

type UserCommitFilesRequest_Header struct {
	Header *UserCommitFilesRequestHeader `protobuf:"bytes,1,opt,name=header,oneof"`
}
type UserCommitFilesRequest_Action struct {
	Action *UserCommitFilesAction `protobuf:"bytes,2,opt,name=action,oneof"`
}

func (*UserCommitFilesRequest_Header) isUserCommitFilesRequest_UserCommitFilesRequestPayload() {}
func (*UserCommitFilesRequest_Action) isUserCommitFilesRequest_UserCommitFilesRequestPayload() {}

func (m *UserCommitFilesRequest) GetUserCommitFilesRequestPayload() isUserCommitFilesRequest_UserCommitFilesRequestPayload {
	if m != nil {
		return m.UserCommitFilesRequestPayload
	}
	return nil
}

func (m *UserCommitFilesRequest) GetHeader() *UserCommitFilesRequestHeader {
	if x, ok := m.GetUserCommitFilesRequestPayload().(*UserCommitFilesRequest_Header); ok {
		return x.Header
	}
	return nil
}

func (m *UserCommitFilesRequest) GetAction() *UserCommitFilesAction {
	if x, ok := m.GetUserCommitFilesRequestPayload().(*UserCommitFilesRequest_Action); ok {
		return x.Action
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserCommitFilesRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserCommitFilesRequest_OneofMarshaler, _UserCommitFilesRequest_OneofUnmarshaler, _UserCommitFilesRequest_OneofSizer, []interface{}{
		(*UserCommitFilesRequest_Header)(nil),
		(*UserCommitFilesRequest_Action)(nil),
	}
}

func _UserCommitFilesRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserCommitFilesRequest)
	// user_commit_files_request_payload
	switch x := m.UserCommitFilesRequestPayload.(type) {
	case *UserCommitFilesRequest_Header:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *UserCommitFilesRequest_Action:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Action); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UserCommitFilesRequest.UserCommitFilesRequestPayload has unexpected type %T", x)
	}
	return nil
}

func _UserCommitFilesRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserCommitFilesRequest)
	switch tag {
	case 1: // user_commit_files_request_payload.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserCommitFilesRequestHeader)
		err := b.DecodeMessage(msg)
		m.UserCommitFilesRequestPayload = &UserCommitFilesRequest_Header{msg}
		return true, err
	case 2: // user_commit_files_request_payload.action
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserCommitFilesAction)
		err := b.DecodeMessage(msg)
		m.UserCommitFilesRequestPayload = &UserCommitFilesRequest_Action{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UserCommitFilesRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserCommitFilesRequest)
	// user_commit_files_request_payload
	switch x := m.UserCommitFilesRequestPayload.(type) {
	case *UserCommitFilesRequest_Header:
		s := proto.Size(x.Header)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserCommitFilesRequest_Action:
		s := proto.Size(x.Action)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type UserCommitFilesResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	IndexError      string                 `protobuf:"bytes,2,opt,name=index_error,json=indexError" json:"index_error,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,3,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCommitFilesResponse) Reset()                    { *m = UserCommitFilesResponse{} }
func (m *UserCommitFilesResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesResponse) ProtoMessage()               {}
func (*UserCommitFilesResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{23} }

func (m *UserCommitFilesResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserCommitFilesResponse) GetIndexError() string {
	if m != nil {
		return m.IndexError
	}
	return ""
}

func (m *UserCommitFilesResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserRebaseRequest struct {
	Repository       *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User             *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	RebaseId         string      `protobuf:"bytes,3,opt,name=rebase_id,json=rebaseId" json:"rebase_id,omitempty"`
	Branch           []byte      `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
	BranchSha        string      `protobuf:"bytes,5,opt,name=branch_sha,json=branchSha" json:"branch_sha,omitempty"`
	RemoteRepository *Repository `protobuf:"bytes,6,opt,name=remote_repository,json=remoteRepository" json:"remote_repository,omitempty"`
	RemoteBranch     []byte      `protobuf:"bytes,7,opt,name=remote_branch,json=remoteBranch,proto3" json:"remote_branch,omitempty"`
}

func (m *UserRebaseRequest) Reset()                    { *m = UserRebaseRequest{} }
func (m *UserRebaseRequest) String() string            { return proto.CompactTextString(m) }
func (*UserRebaseRequest) ProtoMessage()               {}
func (*UserRebaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{24} }

func (m *UserRebaseRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserRebaseRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserRebaseRequest) GetRebaseId() string {
	if m != nil {
		return m.RebaseId
	}
	return ""
}

func (m *UserRebaseRequest) GetBranch() []byte {
	if m != nil {
		return m.Branch
	}
	return nil
}

func (m *UserRebaseRequest) GetBranchSha() string {
	if m != nil {
		return m.BranchSha
	}
	return ""
}

func (m *UserRebaseRequest) GetRemoteRepository() *Repository {
	if m != nil {
		return m.RemoteRepository
	}
	return nil
}

func (m *UserRebaseRequest) GetRemoteBranch() []byte {
	if m != nil {
		return m.RemoteBranch
	}
	return nil
}

type UserRebaseResponse struct {
	RebaseSha       string `protobuf:"bytes,1,opt,name=rebase_sha,json=rebaseSha" json:"rebase_sha,omitempty"`
	PreReceiveError string `protobuf:"bytes,2,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
	GitError        string `protobuf:"bytes,3,opt,name=git_error,json=gitError" json:"git_error,omitempty"`
}

func (m *UserRebaseResponse) Reset()                    { *m = UserRebaseResponse{} }
func (m *UserRebaseResponse) String() string            { return proto.CompactTextString(m) }
func (*UserRebaseResponse) ProtoMessage()               {}
func (*UserRebaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{25} }

func (m *UserRebaseResponse) GetRebaseSha() string {
	if m != nil {
		return m.RebaseSha
	}
	return ""
}

func (m *UserRebaseResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

func (m *UserRebaseResponse) GetGitError() string {
	if m != nil {
		return m.GitError
	}
	return ""
}

type UserSquashRequest struct {
	Repository    *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User          *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	SquashId      string      `protobuf:"bytes,3,opt,name=squash_id,json=squashId" json:"squash_id,omitempty"`
	Branch        []byte      `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
	StartSha      string      `protobuf:"bytes,5,opt,name=start_sha,json=startSha" json:"start_sha,omitempty"`
	EndSha        string      `protobuf:"bytes,6,opt,name=end_sha,json=endSha" json:"end_sha,omitempty"`
	Author        *User       `protobuf:"bytes,7,opt,name=author" json:"author,omitempty"`
	CommitMessage []byte      `protobuf:"bytes,8,opt,name=commit_message,json=commitMessage,proto3" json:"commit_message,omitempty"`
}

func (m *UserSquashRequest) Reset()                    { *m = UserSquashRequest{} }
func (m *UserSquashRequest) String() string            { return proto.CompactTextString(m) }
func (*UserSquashRequest) ProtoMessage()               {}
func (*UserSquashRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{26} }

func (m *UserSquashRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserSquashRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserSquashRequest) GetSquashId() string {
	if m != nil {
		return m.SquashId
	}
	return ""
}

func (m *UserSquashRequest) GetBranch() []byte {
	if m != nil {
		return m.Branch
	}
	return nil
}

func (m *UserSquashRequest) GetStartSha() string {
	if m != nil {
		return m.StartSha
	}
	return ""
}

func (m *UserSquashRequest) GetEndSha() string {
	if m != nil {
		return m.EndSha
	}
	return ""
}

func (m *UserSquashRequest) GetAuthor() *User {
	if m != nil {
		return m.Author
	}
	return nil
}

func (m *UserSquashRequest) GetCommitMessage() []byte {
	if m != nil {
		return m.CommitMessage
	}
	return nil
}

type UserSquashResponse struct {
	SquashSha string `protobuf:"bytes,1,opt,name=squash_sha,json=squashSha" json:"squash_sha,omitempty"`
	GitError  string `protobuf:"bytes,3,opt,name=git_error,json=gitError" json:"git_error,omitempty"`
}

func (m *UserSquashResponse) Reset()                    { *m = UserSquashResponse{} }
func (m *UserSquashResponse) String() string            { return proto.CompactTextString(m) }
func (*UserSquashResponse) ProtoMessage()               {}
func (*UserSquashResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{27} }

func (m *UserSquashResponse) GetSquashSha() string {
	if m != nil {
		return m.SquashSha
	}
	return ""
}

func (m *UserSquashResponse) GetGitError() string {
	if m != nil {
		return m.GitError
	}
	return ""
}

func init() {
	proto.RegisterType((*UserCreateBranchRequest)(nil), "gitaly.UserCreateBranchRequest")
	proto.RegisterType((*UserCreateBranchResponse)(nil), "gitaly.UserCreateBranchResponse")
	proto.RegisterType((*UserUpdateBranchRequest)(nil), "gitaly.UserUpdateBranchRequest")
	proto.RegisterType((*UserUpdateBranchResponse)(nil), "gitaly.UserUpdateBranchResponse")
	proto.RegisterType((*UserDeleteBranchRequest)(nil), "gitaly.UserDeleteBranchRequest")
	proto.RegisterType((*UserDeleteBranchResponse)(nil), "gitaly.UserDeleteBranchResponse")
	proto.RegisterType((*UserDeleteTagRequest)(nil), "gitaly.UserDeleteTagRequest")
	proto.RegisterType((*UserDeleteTagResponse)(nil), "gitaly.UserDeleteTagResponse")
	proto.RegisterType((*UserCreateTagRequest)(nil), "gitaly.UserCreateTagRequest")
	proto.RegisterType((*UserCreateTagResponse)(nil), "gitaly.UserCreateTagResponse")
	proto.RegisterType((*UserMergeBranchRequest)(nil), "gitaly.UserMergeBranchRequest")
	proto.RegisterType((*UserMergeBranchResponse)(nil), "gitaly.UserMergeBranchResponse")
	proto.RegisterType((*OperationBranchUpdate)(nil), "gitaly.OperationBranchUpdate")
	proto.RegisterType((*UserFFBranchRequest)(nil), "gitaly.UserFFBranchRequest")
	proto.RegisterType((*UserFFBranchResponse)(nil), "gitaly.UserFFBranchResponse")
	proto.RegisterType((*UserCherryPickRequest)(nil), "gitaly.UserCherryPickRequest")
	proto.RegisterType((*UserCherryPickResponse)(nil), "gitaly.UserCherryPickResponse")
	proto.RegisterType((*UserRevertRequest)(nil), "gitaly.UserRevertRequest")
	proto.RegisterType((*UserRevertResponse)(nil), "gitaly.UserRevertResponse")
	proto.RegisterType((*UserCommitFilesActionHeader)(nil), "gitaly.UserCommitFilesActionHeader")
	proto.RegisterType((*UserCommitFilesAction)(nil), "gitaly.UserCommitFilesAction")
	proto.RegisterType((*UserCommitFilesRequestHeader)(nil), "gitaly.UserCommitFilesRequestHeader")
	proto.RegisterType((*UserCommitFilesRequest)(nil), "gitaly.UserCommitFilesRequest")
	proto.RegisterType((*UserCommitFilesResponse)(nil), "gitaly.UserCommitFilesResponse")
	proto.RegisterType((*UserRebaseRequest)(nil), "gitaly.UserRebaseRequest")
	proto.RegisterType((*UserRebaseResponse)(nil), "gitaly.UserRebaseResponse")
	proto.RegisterType((*UserSquashRequest)(nil), "gitaly.UserSquashRequest")
	proto.RegisterType((*UserSquashResponse)(nil), "gitaly.UserSquashResponse")
	proto.RegisterEnum("gitaly.UserCommitFilesActionHeader_ActionType", UserCommitFilesActionHeader_ActionType_name, UserCommitFilesActionHeader_ActionType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for OperationService service

type OperationServiceClient interface {
	UserCreateBranch(ctx context.Context, in *UserCreateBranchRequest, opts ...grpc.CallOption) (*UserCreateBranchResponse, error)
	UserUpdateBranch(ctx context.Context, in *UserUpdateBranchRequest, opts ...grpc.CallOption) (*UserUpdateBranchResponse, error)
	UserDeleteBranch(ctx context.Context, in *UserDeleteBranchRequest, opts ...grpc.CallOption) (*UserDeleteBranchResponse, error)
	UserCreateTag(ctx context.Context, in *UserCreateTagRequest, opts ...grpc.CallOption) (*UserCreateTagResponse, error)
	UserDeleteTag(ctx context.Context, in *UserDeleteTagRequest, opts ...grpc.CallOption) (*UserDeleteTagResponse, error)
	UserMergeBranch(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserMergeBranchClient, error)
	UserFFBranch(ctx context.Context, in *UserFFBranchRequest, opts ...grpc.CallOption) (*UserFFBranchResponse, error)
	UserCherryPick(ctx context.Context, in *UserCherryPickRequest, opts ...grpc.CallOption) (*UserCherryPickResponse, error)
	UserRevert(ctx context.Context, in *UserRevertRequest, opts ...grpc.CallOption) (*UserRevertResponse, error)
	UserCommitFiles(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserCommitFilesClient, error)
	UserRebase(ctx context.Context, in *UserRebaseRequest, opts ...grpc.CallOption) (*UserRebaseResponse, error)
	UserSquash(ctx context.Context, in *UserSquashRequest, opts ...grpc.CallOption) (*UserSquashResponse, error)
}

type operationServiceClient struct {
	cc *grpc.ClientConn
}

func NewOperationServiceClient(cc *grpc.ClientConn) OperationServiceClient {
	return &operationServiceClient{cc}
}

func (c *operationServiceClient) UserCreateBranch(ctx context.Context, in *UserCreateBranchRequest, opts ...grpc.CallOption) (*UserCreateBranchResponse, error) {
	out := new(UserCreateBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserCreateBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserUpdateBranch(ctx context.Context, in *UserUpdateBranchRequest, opts ...grpc.CallOption) (*UserUpdateBranchResponse, error) {
	out := new(UserUpdateBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserUpdateBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserDeleteBranch(ctx context.Context, in *UserDeleteBranchRequest, opts ...grpc.CallOption) (*UserDeleteBranchResponse, error) {
	out := new(UserDeleteBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserDeleteBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCreateTag(ctx context.Context, in *UserCreateTagRequest, opts ...grpc.CallOption) (*UserCreateTagResponse, error) {
	out := new(UserCreateTagResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserCreateTag", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserDeleteTag(ctx context.Context, in *UserDeleteTagRequest, opts ...grpc.CallOption) (*UserDeleteTagResponse, error) {
	out := new(UserDeleteTagResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserDeleteTag", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserMergeBranch(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserMergeBranchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_OperationService_serviceDesc.Streams[0], c.cc, "/gitaly.OperationService/UserMergeBranch", opts...)
	if err != nil {
		return nil, err
	}
	x := &operationServiceUserMergeBranchClient{stream}
	return x, nil
}

type OperationService_UserMergeBranchClient interface {
	Send(*UserMergeBranchRequest) error
	Recv() (*UserMergeBranchResponse, error)
	grpc.ClientStream
}

type operationServiceUserMergeBranchClient struct {
	grpc.ClientStream
}

func (x *operationServiceUserMergeBranchClient) Send(m *UserMergeBranchRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *operationServiceUserMergeBranchClient) Recv() (*UserMergeBranchResponse, error) {
	m := new(UserMergeBranchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *operationServiceClient) UserFFBranch(ctx context.Context, in *UserFFBranchRequest, opts ...grpc.CallOption) (*UserFFBranchResponse, error) {
	out := new(UserFFBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserFFBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCherryPick(ctx context.Context, in *UserCherryPickRequest, opts ...grpc.CallOption) (*UserCherryPickResponse, error) {
	out := new(UserCherryPickResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserCherryPick", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserRevert(ctx context.Context, in *UserRevertRequest, opts ...grpc.CallOption) (*UserRevertResponse, error) {
	out := new(UserRevertResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserRevert", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCommitFiles(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserCommitFilesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_OperationService_serviceDesc.Streams[1], c.cc, "/gitaly.OperationService/UserCommitFiles", opts...)
	if err != nil {
		return nil, err
	}
	x := &operationServiceUserCommitFilesClient{stream}
	return x, nil
}

type OperationService_UserCommitFilesClient interface {
	Send(*UserCommitFilesRequest) error
	CloseAndRecv() (*UserCommitFilesResponse, error)
	grpc.ClientStream
}

type operationServiceUserCommitFilesClient struct {
	grpc.ClientStream
}

func (x *operationServiceUserCommitFilesClient) Send(m *UserCommitFilesRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *operationServiceUserCommitFilesClient) CloseAndRecv() (*UserCommitFilesResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(UserCommitFilesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *operationServiceClient) UserRebase(ctx context.Context, in *UserRebaseRequest, opts ...grpc.CallOption) (*UserRebaseResponse, error) {
	out := new(UserRebaseResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserRebase", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserSquash(ctx context.Context, in *UserSquashRequest, opts ...grpc.CallOption) (*UserSquashResponse, error) {
	out := new(UserSquashResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserSquash", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OperationService service

type OperationServiceServer interface {
	UserCreateBranch(context.Context, *UserCreateBranchRequest) (*UserCreateBranchResponse, error)
	UserUpdateBranch(context.Context, *UserUpdateBranchRequest) (*UserUpdateBranchResponse, error)
	UserDeleteBranch(context.Context, *UserDeleteBranchRequest) (*UserDeleteBranchResponse, error)
	UserCreateTag(context.Context, *UserCreateTagRequest) (*UserCreateTagResponse, error)
	UserDeleteTag(context.Context, *UserDeleteTagRequest) (*UserDeleteTagResponse, error)
	UserMergeBranch(OperationService_UserMergeBranchServer) error
	UserFFBranch(context.Context, *UserFFBranchRequest) (*UserFFBranchResponse, error)
	UserCherryPick(context.Context, *UserCherryPickRequest) (*UserCherryPickResponse, error)
	UserRevert(context.Context, *UserRevertRequest) (*UserRevertResponse, error)
	UserCommitFiles(OperationService_UserCommitFilesServer) error
	UserRebase(context.Context, *UserRebaseRequest) (*UserRebaseResponse, error)
	UserSquash(context.Context, *UserSquashRequest) (*UserSquashResponse, error)
}

func RegisterOperationServiceServer(s *grpc.Server, srv OperationServiceServer) {
	s.RegisterService(&_OperationService_serviceDesc, srv)
}

func _OperationService_UserCreateBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCreateBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCreateBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserCreateBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCreateBranch(ctx, req.(*UserCreateBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserUpdateBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserUpdateBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserUpdateBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserUpdateBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserUpdateBranch(ctx, req.(*UserUpdateBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserDeleteBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserDeleteBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserDeleteBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserDeleteBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserDeleteBranch(ctx, req.(*UserDeleteBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserCreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCreateTag(ctx, req.(*UserCreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserDeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserDeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserDeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserDeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserDeleteTag(ctx, req.(*UserDeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserMergeBranch_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserMergeBranch(&operationServiceUserMergeBranchServer{stream})
}

type OperationService_UserMergeBranchServer interface {
	Send(*UserMergeBranchResponse) error
	Recv() (*UserMergeBranchRequest, error)
	grpc.ServerStream
}

type operationServiceUserMergeBranchServer struct {
	grpc.ServerStream
}

func (x *operationServiceUserMergeBranchServer) Send(m *UserMergeBranchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *operationServiceUserMergeBranchServer) Recv() (*UserMergeBranchRequest, error) {
	m := new(UserMergeBranchRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _OperationService_UserFFBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserFFBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserFFBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserFFBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserFFBranch(ctx, req.(*UserFFBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCherryPick_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCherryPickRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCherryPick(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserCherryPick",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCherryPick(ctx, req.(*UserCherryPickRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserRevert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRevertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserRevert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserRevert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserRevert(ctx, req.(*UserRevertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCommitFiles_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserCommitFiles(&operationServiceUserCommitFilesServer{stream})
}

type OperationService_UserCommitFilesServer interface {
	SendAndClose(*UserCommitFilesResponse) error
	Recv() (*UserCommitFilesRequest, error)
	grpc.ServerStream
}

type operationServiceUserCommitFilesServer struct {
	grpc.ServerStream
}

func (x *operationServiceUserCommitFilesServer) SendAndClose(m *UserCommitFilesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *operationServiceUserCommitFilesServer) Recv() (*UserCommitFilesRequest, error) {
	m := new(UserCommitFilesRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _OperationService_UserRebase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRebaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserRebase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserRebase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserRebase(ctx, req.(*UserRebaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserSquash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserSquashRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserSquash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserSquash",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserSquash(ctx, req.(*UserSquashRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OperationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.OperationService",
	HandlerType: (*OperationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UserCreateBranch",
			Handler:    _OperationService_UserCreateBranch_Handler,
		},
		{
			MethodName: "UserUpdateBranch",
			Handler:    _OperationService_UserUpdateBranch_Handler,
		},
		{
			MethodName: "UserDeleteBranch",
			Handler:    _OperationService_UserDeleteBranch_Handler,
		},
		{
			MethodName: "UserCreateTag",
			Handler:    _OperationService_UserCreateTag_Handler,
		},
		{
			MethodName: "UserDeleteTag",
			Handler:    _OperationService_UserDeleteTag_Handler,
		},
		{
			MethodName: "UserFFBranch",
			Handler:    _OperationService_UserFFBranch_Handler,
		},
		{
			MethodName: "UserCherryPick",
			Handler:    _OperationService_UserCherryPick_Handler,
		},
		{
			MethodName: "UserRevert",
			Handler:    _OperationService_UserRevert_Handler,
		},
		{
			MethodName: "UserRebase",
			Handler:    _OperationService_UserRebase_Handler,
		},
		{
			MethodName: "UserSquash",
			Handler:    _OperationService_UserSquash_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "UserMergeBranch",
			Handler:       _OperationService_UserMergeBranch_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UserCommitFiles",
			Handler:       _OperationService_UserCommitFiles_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "operations.proto",
}

func init() { proto.RegisterFile("operations.proto", fileDescriptor7) }

var fileDescriptor7 = []byte{
	// 1510 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x59, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xf7, 0xda, 0xee, 0xda, 0x79, 0x71, 0x1c, 0x67, 0xfa, 0xcb, 0x75, 0x9b, 0x26, 0xdd, 0xb6,
	0xdf, 0x6f, 0xa9, 0x50, 0x84, 0x02, 0x82, 0x53, 0x41, 0x4d, 0xe2, 0xd0, 0x16, 0xda, 0x86, 0x6d,
	0x5a, 0xb8, 0xad, 0xa6, 0xf6, 0x60, 0xaf, 0xb0, 0xbd, 0xdb, 0xd9, 0x4d, 0x68, 0x10, 0xe2, 0x06,
	0x5c, 0x39, 0x71, 0xe0, 0x04, 0xe2, 0x86, 0xb8, 0x70, 0xe1, 0xc0, 0x01, 0x71, 0xe6, 0xda, 0x03,
	0xff, 0x00, 0x7f, 0x08, 0x9a, 0x79, 0x6f, 0xed, 0xdd, 0xf5, 0x6e, 0x94, 0x96, 0x44, 0x44, 0x88,
	0x9b, 0xf7, 0xbd, 0x37, 0x6f, 0xde, 0xfb, 0xbc, 0x1f, 0x33, 0xf3, 0x0c, 0x0d, 0xcf, 0x17, 0x92,
	0x87, 0xae, 0x37, 0x0a, 0x56, 0x7c, 0xe9, 0x85, 0x1e, 0x33, 0x7b, 0x6e, 0xc8, 0x07, 0x7b, 0xad,
	0x5a, 0xd0, 0xe7, 0x52, 0x74, 0x91, 0x6a, 0xfd, 0x64, 0xc0, 0xd9, 0x87, 0x81, 0x90, 0xeb, 0x52,
	0xf0, 0x50, 0xac, 0x49, 0x3e, 0xea, 0xf4, 0x6d, 0xf1, 0x64, 0x47, 0x04, 0x21, 0x5b, 0x05, 0x90,
	0xc2, 0xf7, 0x02, 0x37, 0xf4, 0xe4, 0x5e, 0xd3, 0x58, 0x36, 0xae, 0xcd, 0xae, 0xb2, 0x15, 0x54,
	0xb3, 0x62, 0x8f, 0x39, 0x76, 0x4c, 0x8a, 0x2d, 0xc1, 0xec, 0x63, 0xad, 0xc4, 0x19, 0xf1, 0xa1,
	0x68, 0x16, 0x97, 0x8d, 0x6b, 0x35, 0x1b, 0x90, 0x74, 0x8f, 0x0f, 0x05, 0x5b, 0x86, 0xf2, 0x4e,
	0x20, 0x64, 0xb3, 0xa4, 0xd5, 0xd5, 0x22, 0x75, 0xca, 0x06, 0x5b, 0x73, 0x94, 0x8a, 0x20, 0xe4,
	0x32, 0x74, 0x7c, 0xcf, 0x1d, 0x85, 0xcd, 0x32, 0xaa, 0xd0, 0xa4, 0x2d, 0x45, 0xb1, 0x46, 0xd0,
	0x9c, 0x36, 0x39, 0xf0, 0xbd, 0x51, 0x20, 0xd8, 0xff, 0xc0, 0xc4, 0xcd, 0xc8, 0xde, 0x7a, 0xb4,
	0x01, 0xc9, 0x11, 0x97, 0x5d, 0x87, 0x05, 0x5f, 0x0a, 0x47, 0x8a, 0x8e, 0x70, 0x77, 0x85, 0x23,
	0xa4, 0xf4, 0xa4, 0xb6, 0x76, 0xc6, 0x9e, 0xf7, 0xa5, 0xb0, 0x91, 0xde, 0x56, 0x64, 0xeb, 0x37,
	0xc2, 0xe8, 0xa1, 0xdf, 0x3d, 0x2e, 0x18, 0x9d, 0x01, 0x73, 0x24, 0x3e, 0x96, 0x62, 0x97, 0xe0,
	0xa1, 0x2f, 0x45, 0xf7, 0x06, 0x5d, 0x45, 0x3f, 0x81, 0x74, 0xfc, 0xb2, 0x36, 0x11, 0xb2, 0xa4,
	0x07, 0x04, 0x59, 0x26, 0x14, 0x46, 0x36, 0x14, 0x5f, 0x11, 0x14, 0x1b, 0x62, 0x20, 0x8e, 0x07,
	0x14, 0x91, 0x6b, 0x49, 0x8b, 0x5e, 0xc0, 0xb5, 0x2f, 0x0d, 0x38, 0x35, 0x51, 0xb4, 0xcd, 0x7b,
	0x7f, 0xc7, 0xaf, 0x73, 0x50, 0x0d, 0x79, 0x2f, 0xee, 0x54, 0x25, 0xe4, 0xbd, 0x03, 0x7a, 0xb4,
	0x0e, 0xa7, 0x53, 0x86, 0xbc, 0x80, 0x3b, 0xbf, 0x93, 0x3b, 0x58, 0x25, 0xff, 0xa0, 0x3b, 0xec,
	0xff, 0x30, 0x1f, 0x72, 0xd9, 0x13, 0xa1, 0x23, 0xc5, 0xae, 0x1b, 0xb8, 0xde, 0x88, 0x92, 0xb6,
	0x8e, 0x64, 0x9b, 0xa8, 0xac, 0x09, 0x95, 0xa1, 0x08, 0x02, 0xde, 0x13, 0x94, 0xbd, 0xd1, 0xa7,
	0xf5, 0x09, 0x22, 0x12, 0xf3, 0x85, 0x10, 0x59, 0x84, 0x52, 0xc8, 0x7b, 0xe4, 0xc5, 0x6c, 0xb4,
	0xb9, 0x92, 0x50, 0x74, 0x55, 0x0e, 0xe2, 0xa9, 0x1b, 0x84, 0x81, 0xb6, 0xba, 0x6a, 0xd3, 0x57,
	0x36, 0x90, 0xa5, 0x6c, 0x20, 0x9f, 0x19, 0x70, 0x46, 0x6d, 0x7e, 0x57, 0xc8, 0xde, 0x21, 0x64,
	0x7c, 0x84, 0x57, 0x31, 0x17, 0xaf, 0xf3, 0x30, 0xd3, 0xf1, 0x86, 0x43, 0x37, 0x74, 0xdc, 0x2e,
	0x19, 0x55, 0x45, 0xc2, 0xed, 0xae, 0xf2, 0x88, 0xfa, 0x1b, 0x15, 0x3e, 0xf5, 0xb3, 0x5c, 0xec,
	0xd8, 0x29, 0x38, 0xc1, 0x7d, 0x7f, 0xb0, 0xd7, 0x34, 0x35, 0x04, 0xf8, 0x61, 0xfd, 0x48, 0x85,
	0x9c, 0xf0, 0x8a, 0x40, 0x4d, 0x18, 0x60, 0xa4, 0x0c, 0x58, 0x83, 0x39, 0xaa, 0xd8, 0x1d, 0xdd,
	0x4c, 0x28, 0xf0, 0x8b, 0x91, 0x23, 0xf7, 0xa3, 0x73, 0x07, 0x95, 0x62, 0xc7, 0xb1, 0x6b, 0x8f,
	0x63, 0x5f, 0xd9, 0xf0, 0x97, 0x33, 0xe1, 0xbf, 0x53, 0xae, 0x16, 0x1b, 0x25, 0xeb, 0x33, 0x38,
	0x9d, 0xa9, 0x78, 0x7f, 0x5b, 0x2f, 0x41, 0x4d, 0x21, 0xef, 0x74, 0x74, 0xde, 0x74, 0x29, 0x09,
	0x66, 0x15, 0x0d, 0x53, 0xa9, 0xcb, 0xae, 0x42, 0x9d, 0xdc, 0x89, 0x84, 0x4a, 0x5a, 0x88, 0x9c,
	0x24, 0x31, 0xeb, 0x5b, 0x03, 0x4e, 0x2a, 0xb8, 0x36, 0x37, 0x8f, 0x6b, 0x06, 0x58, 0x5f, 0x50,
	0xc1, 0x4f, 0x4c, 0xa4, 0x70, 0x4e, 0x45, 0xcc, 0x38, 0xa4, 0x88, 0xe5, 0x1c, 0x97, 0xbf, 0x16,
	0xa9, 0x5a, 0xfb, 0x42, 0xca, 0xbd, 0x2d, 0xb7, 0xf3, 0xd1, 0xd1, 0xa2, 0xf5, 0x12, 0x98, 0x08,
	0x0e, 0xa5, 0xe2, 0x42, 0x24, 0xf3, 0xb6, 0x1b, 0xae, 0x6b, 0x86, 0x4d, 0x02, 0xe9, 0xe3, 0xa6,
	0x3c, 0x75, 0xdc, 0xe4, 0x97, 0xd1, 0x75, 0x58, 0xc0, 0x5b, 0x49, 0x5c, 0x81, 0xa9, 0x65, 0xe6,
	0x35, 0x63, 0x6d, 0xa2, 0xe5, 0x06, 0x34, 0x50, 0x36, 0xe6, 0x6d, 0x25, 0xd7, 0x5b, 0x5c, 0x3e,
	0x21, 0x58, 0x7f, 0x50, 0xc7, 0x89, 0x03, 0x78, 0xb8, 0xb1, 0xc4, 0x5c, 0x77, 0x42, 0x29, 0x52,
	0xb1, 0x44, 0xc6, 0xb6, 0x14, 0x18, 0x4b, 0x55, 0x41, 0x94, 0x89, 0xf1, 0x1e, 0x39, 0x8b, 0x34,
	0x14, 0x79, 0x8e, 0x62, 0xb6, 0x7e, 0x29, 0xc2, 0x82, 0x8e, 0x9c, 0xd8, 0x15, 0xca, 0xe5, 0xff,
	0xd2, 0xe2, 0x39, 0xd2, 0xe2, 0x99, 0x01, 0x2c, 0x0e, 0xde, 0xbf, 0x23, 0x25, 0xbe, 0x29, 0xc2,
	0x79, 0x9d, 0xec, 0x7a, 0xfd, 0xa6, 0x3b, 0x10, 0xc1, 0xcd, 0x8e, 0x32, 0xf7, 0x96, 0xe0, 0x5d,
	0x21, 0xd9, 0x26, 0x98, 0x5c, 0x7f, 0x6b, 0xbf, 0xea, 0xab, 0x2b, 0xf1, 0x50, 0xe7, 0x2c, 0x5a,
	0xc1, 0x8f, 0xed, 0x3d, 0x5f, 0xd8, 0xb4, 0x5a, 0xf5, 0xd4, 0x0f, 0xdd, 0x81, 0x70, 0x7c, 0x1e,
	0xf6, 0xe9, 0x0e, 0x53, 0x55, 0x84, 0x2d, 0x1e, 0xf6, 0xd9, 0x65, 0x98, 0xf3, 0xd5, 0xe5, 0xc4,
	0xdb, 0x09, 0x50, 0xa0, 0xa4, 0x05, 0x6a, 0x11, 0x51, 0x0b, 0xa9, 0xa3, 0x82, 0x07, 0xe2, 0xf5,
	0xd7, 0x9c, 0x8e, 0x37, 0x0a, 0x05, 0x3d, 0x4d, 0xd4, 0x51, 0xa1, 0xa9, 0xeb, 0x48, 0xb4, 0xee,
	0x00, 0x4c, 0xb6, 0x67, 0x00, 0xe6, 0xba, 0xdd, 0xbe, 0xb9, 0xdd, 0x6e, 0x14, 0x58, 0x1d, 0x00,
	0x7f, 0x3b, 0x1b, 0xb7, 0xed, 0x86, 0xa1, 0x78, 0x0f, 0xb7, 0x36, 0x14, 0xaf, 0xc8, 0xaa, 0x50,
	0xbe, 0x7b, 0xff, 0x51, 0xbb, 0x51, 0x52, 0xd4, 0x8d, 0xf6, 0xbb, 0xed, 0xed, 0x76, 0xa3, 0x6c,
	0x7d, 0x6d, 0x50, 0x2b, 0x4d, 0xfb, 0xc9, 0x6e, 0x80, 0xd9, 0xd7, 0xbe, 0x52, 0xb8, 0x2f, 0x1f,
	0x00, 0x96, 0x5b, 0x05, 0x9b, 0x16, 0xb1, 0x16, 0x54, 0x22, 0x27, 0x34, 0x16, 0xb7, 0x0a, 0x76,
	0x44, 0x58, 0xb3, 0x60, 0x59, 0x15, 0x90, 0x43, 0x51, 0x56, 0x20, 0x05, 0x0e, 0xa2, 0xe8, 0xf8,
	0x7c, 0x6f, 0xe0, 0xf1, 0xae, 0xf5, 0x79, 0x09, 0x2e, 0xa4, 0x76, 0xa2, 0x6a, 0xa6, 0xb0, 0x1d,
	0x4d, 0x4d, 0xa7, 0x0a, 0xb5, 0x34, 0x55, 0xa8, 0x57, 0xa1, 0x4e, 0x66, 0x47, 0xf5, 0x8a, 0xc5,
	0x3c, 0x87, 0xd4, 0xbb, 0x54, 0xb5, 0x2f, 0x03, 0x23, 0x31, 0xbe, 0x13, 0xf6, 0x3d, 0x89, 0xea,
	0xb0, 0xb4, 0x1b, 0xc8, 0xb9, 0xa9, 0x19, 0x5a, 0xe9, 0x0a, 0x9c, 0x4c, 0x4a, 0x8b, 0x21, 0x77,
	0x07, 0x54, 0xe5, 0x0b, 0x71, 0xf1, 0xb6, 0x62, 0x64, 0xf7, 0x84, 0xca, 0xc1, 0x7b, 0x42, 0xf5,
	0xe0, 0x3d, 0xe1, 0xe7, 0xe8, 0xa8, 0x98, 0x8a, 0x03, 0x7b, 0x33, 0x95, 0x21, 0x57, 0x72, 0x32,
	0x24, 0x11, 0xb7, 0x58, 0x8a, 0xbc, 0x31, 0x2e, 0xbc, 0x62, 0xb2, 0xa1, 0x64, 0x67, 0x58, 0x21,
	0xaa, 0xb4, 0xb5, 0xcb, 0x70, 0x69, 0x3a, 0x7f, 0x24, 0xee, 0x32, 0x4e, 0xa0, 0x1f, 0xa2, 0xb9,
	0x43, 0xdc, 0x90, 0x43, 0xec, 0x68, 0x4b, 0x30, 0xeb, 0x8e, 0xba, 0xe2, 0x69, 0xa2, 0x97, 0x81,
	0x26, 0xed, 0xd3, 0xa3, 0x72, 0x9e, 0x00, 0xdf, 0x8f, 0x8f, 0x2d, 0x55, 0xea, 0x47, 0x7e, 0xf7,
	0x93, 0x7a, 0x9b, 0xd8, 0xdd, 0x0f, 0x09, 0xfb, 0xdc, 0xfe, 0x17, 0x81, 0x8a, 0xc0, 0x09, 0xfa,
	0x5c, 0xe7, 0xf1, 0x8c, 0x3d, 0x83, 0x94, 0x07, 0x7d, 0xce, 0xde, 0x82, 0x05, 0x29, 0x86, 0x5e,
	0x28, 0xe2, 0x59, 0x66, 0xe6, 0x1a, 0xdc, 0x40, 0xe1, 0x09, 0x45, 0xf5, 0x47, 0x52, 0x40, 0xdb,
	0x63, 0x36, 0xd7, 0x90, 0x88, 0x61, 0xb0, 0x3e, 0x8d, 0x8e, 0x27, 0x04, 0x69, 0xfc, 0x42, 0x03,
	0xf2, 0x47, 0x99, 0x86, 0x37, 0x74, 0xf2, 0x50, 0x99, 0xf6, 0x1c, 0x17, 0x4b, 0x05, 0x4d, 0x2f,
	0x75, 0xec, 0x54, 0x7b, 0x74, 0xe6, 0x58, 0xdf, 0x51, 0x8c, 0x1e, 0x3c, 0xd9, 0xe1, 0xc1, 0xd1,
	0xdf, 0xcf, 0x03, 0xbd, 0x4d, 0x2c, 0x46, 0x48, 0xd8, 0x27, 0x46, 0x6a, 0x91, 0xae, 0xf4, 0x49,
	0x88, 0xaa, 0x9a, 0xa0, 0x60, 0x38, 0x0b, 0x15, 0x31, 0xea, 0x6a, 0x96, 0xa9, 0x59, 0xa6, 0x18,
	0x75, 0x15, 0xe3, 0x0a, 0x98, 0xd8, 0x74, 0xe8, 0xa6, 0x90, 0x34, 0x87, 0x78, 0x19, 0x6d, 0xaf,
	0x9a, 0xd1, 0xf6, 0x2c, 0x17, 0x23, 0x14, 0x41, 0x34, 0x89, 0x10, 0x79, 0x13, 0x8b, 0x10, 0x52,
	0x94, 0x05, 0xfb, 0xa1, 0x8e, 0xaf, 0x33, 0x7b, 0x3a, 0x84, 0xab, 0x7f, 0x56, 0xa0, 0x31, 0xae,
	0xd3, 0x07, 0x42, 0xee, 0xba, 0x1d, 0xc1, 0xde, 0x87, 0x46, 0x7a, 0x70, 0xc7, 0x96, 0x12, 0x6d,
	0x65, 0x7a, 0x0a, 0xd9, 0x5a, 0xce, 0x17, 0x40, 0x07, 0xac, 0x42, 0xa4, 0x38, 0x3e, 0xde, 0x4a,
	0x2a, 0xce, 0x18, 0xdd, 0x25, 0x15, 0x67, 0x4d, 0xc6, 0x26, 0x8a, 0xe3, 0xc3, 0xa5, 0xa4, 0xe2,
	0x8c, 0x41, 0x58, 0x52, 0x71, 0xd6, 0x5c, 0xca, 0x2a, 0xb0, 0x7b, 0x30, 0x97, 0x98, 0x68, 0xb0,
	0x0b, 0xd3, 0x6e, 0x4e, 0x86, 0x36, 0xad, 0xc5, 0x1c, 0x6e, 0x5a, 0xdf, 0x78, 0x66, 0x94, 0xd4,
	0x97, 0x9e, 0x69, 0x25, 0xf5, 0x4d, 0x0d, 0x9a, 0xac, 0x02, 0xfb, 0x00, 0xe6, 0x53, 0xe3, 0x01,
	0x76, 0x31, 0xbe, 0x66, 0x7a, 0x1a, 0xd2, 0x5a, 0xca, 0xe5, 0x47, 0x5a, 0xaf, 0x19, 0xaf, 0x18,
	0xec, 0x1d, 0xa8, 0xc5, 0x9f, 0xa9, 0xec, 0x7c, 0x7c, 0x59, 0xea, 0x7d, 0xdd, 0xba, 0x90, 0xcd,
	0x1c, 0x9b, 0xf9, 0x1e, 0xd4, 0x93, 0x2f, 0x25, 0x96, 0x44, 0x2a, 0xfd, 0x04, 0x6d, 0x5d, 0xcc,
	0x63, 0x8f, 0x55, 0xb6, 0x01, 0x26, 0xb7, 0x6c, 0x76, 0x2e, 0x51, 0x6f, 0xf1, 0x67, 0x4b, 0xab,
	0x95, 0xc5, 0x1a, 0xab, 0x79, 0x84, 0x00, 0xc6, 0xce, 0xb7, 0x24, 0x80, 0xd3, 0x27, 0x70, 0x12,
	0xc0, 0x8c, 0x83, 0x51, 0x01, 0x38, 0x31, 0x4f, 0x75, 0xd0, 0xb4, 0x79, 0xb1, 0xe3, 0x29, 0x6d,
	0x5e, 0xbc, 0x29, 0x4f, 0xbc, 0xc4, 0x56, 0x90, 0x54, 0x93, 0xe8, 0xa0, 0x49, 0x35, 0xc9, 0xce,
	0x61, 0x15, 0x1e, 0x9b, 0xfa, 0x5f, 0x84, 0x57, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff, 0xaa, 0x7d,
	0xb3, 0xe5, 0x6f, 0x18, 0x00, 0x00,
}
