#!/bin/bash

GINKGO_VERSION=`grep "Mayor version number" src/CMakeLists.txt | awk '{print $3}'`
GINKGO_REVISION=`grep "Incremental revision number" src/CMakeLists.txt | awk '{print $3}'`
GINKGO_BUILD=`grep "Incremental build number" src/CMakeLists.txt | awk '{print $3}'`

#########################################

VER=${GINKGO_VERSION}.${GINKGO_REVISION}.${GINKGO_BUILD}
echo "Building VERSION $VER"
TARGET="Release"

for arg in $*
do
	if [ X"$arg" == "XDEBUG" ] || [ X"$arg" == "Xdebug" ]
	then
		TARGET="Debug"
	fi
done

if [ "X`uname`" == X"Darwin" ]; then
	export COPYFILE_DISABLE=true
	export COPY_EXTENDED_ATTRIBUTES_DISABLED=true
	mkdir build >/dev/null 2>&1
	cd build || exit 1
	ARGS=".. -DCMAKE_BUILD_TYPE=${TARGET} -DINTERNET_DIST:BOOL=TRUE -DBUILD_OPHTALMOLOGY_EXT:BOOL=FALSE -DBUILD_DERMATHOLOGY_EXT:BOOL=FALSE -DUSE_SYSTEM_SQLITE:BOOL=FALSE -DUSE_PATCHED_LIBS:BOOL=TRUE -DUSE_CUSTOM_WX:BOOL=TRUE -DUSE_CUSTOM_VTK:BOOL=TRUE -DUSE_CUSTOM_ITK:BOOL=TRUE -DUSE_CUSTOM_DCMTK=TRUE -DCUSTOM_PACKAGE:BOOL=TRUE -DCMAKE_INSTALL_PREFIX:STRING=./deploy"

	echo cmake $ARGS
	cmake $ARGS || exit 1
	cmake $ARGS || exit 1
	make BUILD_ALL install || exit 1
	DIR="Ginkgo CADx ${VER}"
	rm -rf "${DIR}"
	mkdir "${DIR}" >/dev/null 2>&1
	cp -a "ginkgocadx/Ginkgo CADx.app" "${DIR}"
	upx -9 "${DIR}/Ginkgo CADx.app/Contents/MacOS/Ginkgo CADx"
	rm -rf "${DIR}/Ginkgo CADx.app/Contents/PlugIns"
	mkdir "${DIR}/Ginkgo CADx.app/Contents/PlugIns"
	cp "ginkgocadx/Ginkgo CADx.app/Contents/PlugIns/"*.inf "${DIR}/Ginkgo CADx.app/Contents/PlugIns"
	mv "${DIR}/Ginkgo CADx.app/Contents/MacOS/libvisualizator"*dylib* "${DIR}/Ginkgo CADx.app/Contents/PlugIns"
	upx -9 "${DIR}/Ginkgo CADx.app/Contents/PlugIns/"*dylib*
	rm -rf "${DIR}/Ginkgo CADx.app/Contents/Resources/lang"
	for lang in `cd ../cadxcore/lang; ls`; do
		if [ -d "../visualizator/lang/$lang" ]; then
			mkdir -p "${DIR}/Ginkgo CADx.app/Contents/Resources/lang/$lang"
			cp ../cadxcore/lang/$lang/*.mo "${DIR}/Ginkgo CADx.app/Contents/Resources/lang/$lang"
		fi
	done
	for lang in `cd ../visualizator/lang; ls`; do
		if [ -d "../visualizator/lang/$lang" ]; then
			mkdir -p "${DIR}/Ginkgo CADx.app/Contents/Resources/lang/$lang"
			cp ../visualizator/lang/$lang/*.mo "${DIR}/Ginkgo CADx.app/Contents/Resources/lang/$lang"
		fi
	done
	(cd "${DIR}"; pwd; tar -zxvf ../../ginkgocadx/dmg_template.tgz)
	rm -f "../Ginkgo_CADx-$VER.dmg"
	rm -f "pack.temp.dmg"
	hdiutil create -srcfolder "${DIR}" -volname "Ginkgo_CADx $VER" -fs HFS+ -fsargs "-c c=64,a=16,e=16" -format UDRW -size 100m pack.temp.dmg
	device=`hdiutil attach -readwrite -noverify -noautoopen "pack.temp.dmg" | egrep '^/dev/' | sed 1q | awk '{print $1}'`
	sleep 5
	echo '
	   tell application "Finder"
	     tell disk "'Ginkgo_CADx $VER'"
	           open
	           set current view of container window to icon view
	           set toolbar visible of container window to false
	           set statusbar visible of container window to false
	           set theViewOptions to the icon view options of container window
	           set arrangement of theViewOptions to not arranged
	           set icon size of theViewOptions to 72
	           set background picture of theViewOptions to file ".background:dmgbackground.png"
	           make new alias file at container window to POSIX file "/Applications" with properties {name:"Aplicaciones"}
	           update without registering applications
	           delay 5
	           eject
	     end tell
	   end tell
	' | osascript
	chmod -Rf go-w "/Volumes/Ginkgo_CADx $VER"
	sync
	sync
	hdiutil detach ${device}
	hdiutil convert "pack.temp.dmg" -format UDZO -imagekey zlib-level=9 -o "../Ginkgo_CADx-$VER.dmg"
	rm -f pack.temp.dmg
	cd ..
	cp "Ginkgo_CADx-$VER.dmg" ../../dist/0-ESTABLE/Internet/ 
	
	#set the bounds of container window to {400, 100, 885, 430}

else
	rm -rf dist
	if [ "X`uname -m`" == "Xx86_64" ]; then
		ARCH=x86_64
	else
		ARCH=x86
	fi

	mkdir build >/dev/null 2>&1
	cd build || exit 1
	ARGS=".. -DCMAKE_BUILD_TYPE=${TARGET} -DINTERNET_DIST:BOOL=TRUE -DBUILD_OPHTALMOLOGY_EXT:BOOL=FALSE -DBUILD_DERMATHOLOGY_EXT:BOOL=FALSE -DUSE_SYSTEM_SQLITE:BOOL=FALSE -DUSE_PATCHED_LIBS:BOOL=TRUE -DUSE_CUSTOM_WX:BOOL=TRUE -DUSE_CUSTOM_VTK:BOOL=TRUE -DUSE_CUSTOM_ITK:BOOL=TRUE -DUSE_CUSTOM_DCMTK=TRUE -DCUSTOM_PACKAGE:BOOL=TRUE -DCMAKE_INSTALL_PREFIX:STRING=./deploy"

	cmake $ARGS
	cmake $ARGS
	make -j4 BUILD_ALL || exit 1
	DIR="Ginkgo_CADx-${VER}_linux_${ARCH}"
	rm -rf "${DIR}"
	mkdir "${DIR}" >/dev/null 2>&1
	cp -a src/dist/ginkgocadx "${DIR}"/ginkgocadx
	cp -a src/dist/ginkgocadx-$ARCH "${DIR}"/
	chmod +x src/dist/ginkgocadx
	cp -a src/dist/*.so* "${DIR}"
	cp -a src/dist/*.xml "${DIR}"
	chmod -x "${DIR}"/*.so*
	mkdir -p "${DIR}"/lang/de "${DIR}"/lang/el "${DIR}"/lang/es "${DIR}"/lang/fr "${DIR}"/lang/ja "${DIR}"/lang/pl "${DIR}"/lang/pt "${DIR}"/lang/pt_BR "${DIR}"/lang/sr "${DIR}"/lang/tr "${DIR}"/zh_CN "${DIR}"/Plugins "${DIR}"/resources

	(cd src/dist/resources ; tar --exclude .svn -cvf - . ) | (cd "${DIR}"/resources; tar -xvf - >/dev/null)
	
	cp src/dist/lang/de/wxstd.mo "${DIR}"/lang/de/wxstd.mo
	cp src/dist/lang/de/cadxcore.mo "${DIR}"/lang/de/cadxcore.mo
	cp src/dist/lang/de/visualizator.mo "${DIR}"/lang/de/visualizator.mo
	
	cp src/dist/lang/el/wxstd.mo "${DIR}"/lang/el/wxstd.mo
	cp src/dist/lang/el/cadxcore.mo "${DIR}"/lang/el/cadxcore.mo
	cp src/dist/lang/el/visualizator.mo "${DIR}"/lang/el/visualizator.mo
	
	cp src/dist/lang/es/wxstd.mo "${DIR}"/lang/es/wxstd.mo 
	cp src/dist/lang/es/cadxcore.mo "${DIR}"/lang/es/cadxcore.mo
	cp src/dist/lang/es/visualizator.mo "${DIR}"/lang/es/visualizator.mo
	
	cp src/dist/lang/fr/wxstd.mo "${DIR}"/lang/fr/wxstd.mo
	cp src/dist/lang/fr/cadxcore.mo "${DIR}"/lang/fr/cadxcore.mo
	cp src/dist/lang/fr/visualizator.mo "${DIR}"/lang/fr/visualizator.mo
	
	cp src/dist/lang/ja/wxstd.mo "${DIR}"/lang/ja/wxstd.mo
	cp src/dist/lang/ja/cadxcore.mo "${DIR}"/lang/ja/cadxcore.mo
	cp src/dist/lang/ja/visualizator.mo "${DIR}"/lang/ja/visualizator.mo
	
	cp src/dist/lang/pl/wxstd.mo "${DIR}"/lang/pl/wxstd.mo
	cp src/dist/lang/pl/cadxcore.mo "${DIR}"/lang/pl/cadxcore.mo
	cp src/dist/lang/pl/visualizator.mo "${DIR}"/lang/tpl/visualizator.mo
	
	cp src/dist/lang/pt/wxstd.mo "${DIR}"/lang/pt/wxstd.mo 
	cp src/dist/lang/pt/cadxcore.mo "${DIR}"/lang/pt/cadxcore.mo
	cp src/dist/lang/pt/visualizator.mo "${DIR}"/lang/pt/visualizator.mo
	
	cp src/dist/lang/pt_BR/wxstd.mo "${DIR}"/lang/pt_BR/wxstd.mo 
	cp src/dist/lang/pt_BR/cadxcore.mo "${DIR}"/lang/pt_BR/cadxcore.mo
	cp src/dist/lang/pt_BR/visualizator.mo "${DIR}"/lang/pt_BR/visualizator.mo
	
	cp src/dist/lang/sr/cadxcore.mo "${DIR}"/lang/sr/cadxcore.mo
	cp src/dist/lang/sr/visualizator.mo "${DIR}"/lang/sr/visualizator.mo
	
	cp src/dist/lang/tr/wxstd.mo "${DIR}"/lang/tr/wxstd.mo
	cp src/dist/lang/tr/cadxcore.mo "${DIR}"/lang/tr/cadxcore.mo
	cp src/dist/lang/tr/visualizator.mo "${DIR}"/lang/tr/visualizator.mo
		
	cp src/dist/lang/zh_CN/wxstd.mo "${DIR}"/lang/zh_CN/wxstd.mo
	cp src/dist/lang/zh_CN/cadxcore.mo "${DIR}"/lang/zh_CN/cadxcore.mo
	cp src/dist/lang/zh_CN/visualizator.mo "${DIR}"/lang/zh_CN/visualizator.mo
	
	chmod -x src/dist/Plugins/* >/dev/null 2>&1
	mkdir ../dist > /dev/null 2>&1
	tar -zcvf ../dist/"${DIR}".tgz "${DIR}"
	
fi
