/*
*  
*  $Id: surfacecommand.h 3558 2011-03-20 20:02:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once

#define IDC_SURFACE_RECONSTRUCTION 4002

#include <api/icomando.h>
#include <yasper/yasper.h>
#include "../pipelines/surfacepipeline.h"


namespace MedicalViewer {
	namespace Reconstruction {
		namespace Surface {

			typedef MedicalViewer::Reconstruction::Pipelines::SurfacePipeline TPipeline;

			namespace Commands {

				class SurfaceCommandParams : public GNC::GCS::IComandoParams {
				public:

					typedef struct SurfaceProps {
						long ISOValue;
						bool Enabled;
						float Red;
						float Green;
						float Blue;
						float Alpha;

						inline SurfaceProps(
							bool  enabled,
							long  isoValue,
							float red,
							float green,
							float blue,
							float alpha
						)
						{
							Enabled = enabled;
							ISOValue = isoValue;
							Red = red;
							Green = green;
							Blue = blue;
							Alpha = alpha;
						}

					} SurfaceProps;

					/** Surface Command (setup) Parameters.
						pipeline: SurfaceReconstruction pipeline
						datasetNum: Loaded Volume index (VOI)
						preSmooth: Set Smooth (Apply gaussian blur for noise removal) for input voxel
						postSmooth: Set Smooth (Apply gaussian blur for noise removal) for low resolution voxel
						quality: Los resolution voxel quality value (0-3) (0: 32x32x32, 1: 64x64x64, 2: 128x128x128, 3: 256x256x256)
					Surface1:
						bool  enabled:  Visibility for Surface 1
						long  isovalue: Isovalue (HounsFiled Units) for Surface 1
						float red:      Red component color value for Surface 1
						float green:    Green component color value for Surface 1
						float blue:     Blue component color value for Surface 1
						float alpha:    Transparency for Surface 1
					Surface2:
						bool  enabled:  Visibility for Surface 2
						long  isovalue: Isovalue (HounsFiled Units) for Surface 2
						float red:      Red component color value for Surface 2
						float green:    Green component color value for Surface 2
						float blue:     Blue component color value for Surface 2
						float alpha:    Transparency for Surface 2
					**/
					SurfaceCommandParams(
						const GnkPtr<TPipeline>& pipeline,
						unsigned int datasetNum,
						bool         preSmooth,
						bool         postSmooth,
						unsigned int quality,
						const SurfaceProps& propsS1,
						const SurfaceProps& propsS2
					);

					virtual ~SurfaceCommandParams() ;

				public:

					GnkPtr<TPipeline>   Pipeline;
					unsigned int        DataSetNum;
					bool                PreSmooth;
					bool                PostSmooth;
					unsigned int        Quality;
					SurfaceProps        Surface1Props;
					SurfaceProps        Surface2Props;
				};


				class SurfaceCommand : public GNC::GCS::IComando, public MedicalViewer::Reconstruction::Pipelines::IReconstructionNotifier
				{
				public:
					SurfaceCommand(SurfaceCommandParams* pParams);
					~SurfaceCommand(void);

				protected:
				
					virtual void Execute();
					virtual void Update();

					virtual void OnAbort();

					void LiberarRecursos();

					virtual bool NotifyReconstructionProgress(const std::string& texto,  float progress);

					SurfaceCommandParams* m_pSurfaceParams;
				};
			}
		}
	}
}
