/*
 *  
 *  $Id: PDFExtracterCommandParameters.h 4499 2011-12-19 14:21:40Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
//#define _GINKGO_TRACE
#include <vector>
#include <api/globals.h>
#include <api/icomando.h>


namespace GNKVisualizator {
	namespace GADAPI {
		class PDFExtracterCommandParameters : public GNC::GCS::IComandoParams {
		public:
			PDFExtracterCommandParameters(const std::vector<std::string>& rutas, const std::vector<std::string>& dests = std::vector<std::string>(), bool forOpening = true) ;

			virtual ~PDFExtracterCommandParameters() ;

		public:
			std::vector<std::string> m_pathsOriginal;
			std::vector<std::string> m_pathsExtracted;
			bool m_error;
			bool m_ForOpening;
		};


		class PDFExtracterCommand : public GNC::GCS:: IComando {
		public:
			PDFExtracterCommand(PDFExtracterCommandParameters* pParams);

		 protected:
			virtual void Execute();

			virtual void Update();

			virtual void OnAbort();

			void LiberarRecursos();

			PDFExtracterCommandParameters* m_pExtracterParameters;
		};
	}
}
