/*
 *  
 *  $Id: wzoom.h 4488 2011-12-14 08:43:28Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <export/itoolslider.h>
#include <api/iwidgets.h>
#include <export/icontratoscore.h>
#include <api/math/geometria3d.h>
#include <vector>
#include <api/toolhandlers/izoomhandler.h>


namespace GNC {
	namespace GCS {
		namespace Widgets {
			//---------------------------------------------------------------------
			class WZoomBuilder : public GNC::GCS::Widgets::IWidgetBuilder {
			public:

				typedef GNC::GCS::Vector TVector;
				typedef GNC::GCS::Eventos::EventoRaton   TEventoRaton;
				typedef GNC::GCS::Eventos::EventoTeclado TEventoTeclado;
				typedef GNC::GCS::IWidgetsManager        TWidgetsManager;
				typedef GNC::GCS::Widgets::IWidget       TWidget;
				WZoomBuilder(TWidgetsManager* pManager, GNC::GCS::ToolHandlers::IZoomHandler* pObserver, const GNC::GCS::TriggerButton& buttonMask, long gid);

				~WZoomBuilder();

				virtual void OnMouseEvents(TEventoRaton& event);
				virtual void OnKeyEvents(TEventoTeclado& event);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual GNC::GCS::Widgets::TipoCursor GetCursor();

				//region "Helpers"

				bool         m_Dentro;
				//endregion


			protected:
				TVector  m_NodoMoviendose;  // Cursor
				
				double  m_Start;           // Displacement origin in screen pixels
				double  m_Stop;            // Displacement destination in screen pixels
				
				bool     m_MouseDown;
				Estado   m_Estado;
				ToolHandlers::IZoomHandler* m_pObserver;
			};
		}
	}
}
