/*
*  
*  $Id: toolpan.cpp 4869 2012-04-19 11:47:15Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "toolpan.h"
#include <resources/ginkgoresourcemanager.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <vtkRenderWindowInteractor.h>
#include <vtk/interactor/ginkgointeractorstyleimage2d.h>


GNC::ToolPan::ToolPan() {
	m_Activa = false;

	m_Descripcion = _Std("Pan\tCtrl+P");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoPan();
	m_pBuilder = NULL;
}

GNC::ToolPan::~ToolPan() {
	;
}

//region "Realización de la interfaz IHerramienta"

void GNC::ToolPan::CrearPaneles( wxPanel* /*panel*/ ) {
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::ToolPan::ConectarContratoFalso(bool activar) {
	if (TContractableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (TContractableWidgets::IteradorListaContratos it = TContractableWidgets::m_pListaActiva->begin(); it != TContractableWidgets::m_pListaActiva->end(); it++) {
		TContractWidgets* pC = (*it);
		if (pC->Inicializado()) {
			pC->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "ToolPan: Conectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
			} else {
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "ToolPan: Desconectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
			}
		}
	}
}

void GNC::ToolPan::SetVistaActiva(GNC::GCS::IVista* pVista) {
	if (pVista == NULL) {
		;
	}
	TContractableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::ToolPan::SetVistaActiva(" <<  pVista << ")");

}

void GNC::ToolPan::ConectarContratos(bool activar) {

	TContractableWidgets::ListaContratos* lista1 = TContractableWidgets::ObtenerContratosDeActiva();
	if (lista1 == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pBuilder != NULL)
			{
				delete m_pBuilder;
				m_pBuilder = NULL;
			}
		}
		return;
	}

	TContractableWidgets::IteradorListaContratos it1 = lista1->begin();

	for (; it1 != lista1->end(); it1++) {
		TContractWidgets* pC = (*it1);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE( "ToolPan: Conectando contratos de vista " << TContratableWidgets::m_pVistaActiva );
				m_pBuilder = new TBuilder(pC->GetManager(), GetTriggerButton(), (unsigned long)this);
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(m_pBuilder->GetCursor());
			}
			else {
				GTRACE( "ToolPan: Desconectando contratos de vista " << TContratableWidgets::m_pVistaActiva );
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				// DesSubscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				if (m_pBuilder != NULL) {
					delete m_pBuilder;
					m_pBuilder = NULL;
				}
			}
		}
	}
}

//endregion


//region "Eventos refinados desde los paneles"

//endregion
